# Autogenerated constants for Control service
from enum import IntEnum
from jacdac.constants import *
from jacdac.system.constants import *
JD_SERVICE_CLASS_CONTROL = const(0x0)


class ControlAnnounceFlags(IntEnum):
    RESTART_COUNTER_STEADY = const(0xf)
    RESTART_COUNTER1 = const(0x1)
    RESTART_COUNTER2 = const(0x2)
    RESTART_COUNTER4 = const(0x4)
    RESTART_COUNTER8 = const(0x8)
    STATUS_LIGHT_NONE = const(0x0)
    STATUS_LIGHT_MONO = const(0x10)
    STATUS_LIGHT_RGB_NO_FADE = const(0x20)
    STATUS_LIGHT_RGB_FADE = const(0x30)
    SUPPORTS_ACK = const(0x100)
    SUPPORTS_BROADCAST = const(0x200)
    SUPPORTS_FRAMES = const(0x400)
    IS_CLIENT = const(0x800)
    SUPPORTS_RELIABLE_COMMANDS = const(0x1000)


JD_CONTROL_CMD_SERVICES = const(JD_CMD_ANNOUNCE)
JD_CONTROL_CMD_NOOP = const(0x80)
JD_CONTROL_CMD_IDENTIFY = const(0x81)
JD_CONTROL_CMD_RESET = const(0x82)
JD_CONTROL_CMD_FLOOD_PING = const(0x83)
JD_CONTROL_CMD_SET_STATUS_LIGHT = const(0x84)
JD_CONTROL_CMD_PROXY = const(0x85)
JD_CONTROL_CMD_RELIABLE_COMMANDS = const(0x86)
JD_CONTROL_REG_RESET_IN = const(0x80)
JD_CONTROL_REG_DEVICE_DESCRIPTION = const(0x180)
JD_CONTROL_REG_PRODUCT_IDENTIFIER = const(0x181)
JD_CONTROL_REG_BOOTLOADER_PRODUCT_IDENTIFIER = const(0x184)
JD_CONTROL_REG_FIRMWARE_VERSION = const(0x185)
JD_CONTROL_REG_MCU_TEMPERATURE = const(0x182)
JD_CONTROL_REG_UPTIME = const(0x186)
JD_CONTROL_PACK_FORMATS = {
    JD_CONTROL_CMD_FLOOD_PING: "u32 u32 u8",
    JD_CONTROL_CMD_SET_STATUS_LIGHT: "u8 u8 u8 u8",
    JD_CONTROL_CMD_RELIABLE_COMMANDS: "u32",
    JD_CONTROL_REG_RESET_IN: "u32",
    JD_CONTROL_REG_DEVICE_DESCRIPTION: "s",
    JD_CONTROL_REG_PRODUCT_IDENTIFIER: "u32",
    JD_CONTROL_REG_BOOTLOADER_PRODUCT_IDENTIFIER: "u32",
    JD_CONTROL_REG_FIRMWARE_VERSION: "s",
    JD_CONTROL_REG_MCU_TEMPERATURE: "i16",
    JD_CONTROL_REG_UPTIME: "u64"
}
