# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class DotMatrixClient(Client):
    """
    A rectangular dot matrix display, made of monochrome LEDs or Braille pins.
    Implements a client for the `Dot Matrix <https://microsoft.github.io/jacdac-docs/services/dotmatrix>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_DOT_MATRIX, JD_DOT_MATRIX_PACK_FORMATS, role)


    @property
    def dots(self) -> Optional[bytes]:
        """
        The state of the screen where dot on/off state is
        stored as a bit, column by column. The column should be byte aligned.
        
        For example, if the display has no more than 8 rows in each column, then each byte contains bits corresponding
        to a single column. Least-significant bit is on top.
        If display has 10 rows, then each column is represented by two bytes.
        The top-most 8 rows sit in the first byte (with the least significant bit being on top),
        and the remainign 2 row sit in the second byte.
        
        The following C expression can be used to check if a given `column, row` coordinate is set:
        `dots[column * column_size + (row >> 3)] & (1 << (row & 7))`, where
        `column_size` is `(number_of_rows + 7) >> 3` (note that if number of rows is 8 or less then `column_size` is `1`),
        and `dots` is of `uint8_t*` type.
        
        The size of this register is `number_of_columns * column_size` bytes., 
        """
        return self.register(JD_DOT_MATRIX_REG_DOTS).value()

    @dots.setter
    def dots(self, value: bytes) -> None:
        self.register(JD_DOT_MATRIX_REG_DOTS).set_values(value)


    @property
    def brightness(self) -> Optional[float]:
        """
        (Optional) Reads the general brightness of the display, brightness for LEDs. `0` when the screen is off., _: /
        """
        return self.register(JD_DOT_MATRIX_REG_BRIGHTNESS).float_value(100)

    @brightness.setter
    def brightness(self, value: float) -> None:
        self.register(JD_DOT_MATRIX_REG_BRIGHTNESS).set_values(value / 100)


    @property
    def rows(self) -> Optional[int]:
        """
        Number of rows on the screen, _: #
        """
        return self.register(JD_DOT_MATRIX_REG_ROWS).value()

    @property
    def columns(self) -> Optional[int]:
        """
        Number of columns on the screen, _: #
        """
        return self.register(JD_DOT_MATRIX_REG_COLUMNS).value()

    @property
    def variant(self) -> Optional[DotMatrixVariant]:
        """
        (Optional) Describes the type of matrix used., 
        """
        return self.register(JD_DOT_MATRIX_REG_VARIANT).value()

    
