# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient, EventHandlerFn, UnsubscribeFn
from .constants import *
from typing import Optional, Tuple


class GamepadClient(SensorClient):
    """
    A two axis directional gamepad with optional buttons.
    Implements a client for the `Gamepad <https://microsoft.github.io/jacdac-docs/services/gamepad>`_ service.

    """

    def __init__(self, bus: Bus, role: str, *, missing_direction_value: Optional[Tuple[GamepadButtons, float, float]] = None) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_GAMEPAD, JD_GAMEPAD_PACK_FORMATS, role)
        self.missing_direction_value = missing_direction_value

    @property
    def direction(self) -> Optional[Tuple[GamepadButtons, float, float]]:
        """
        If the gamepad is analog, the directional buttons should be "simulated", based on gamepad position
        (`Left` is `{ x = -1, y = 0 }`, `Up` is `{ x = 0, y = -1}`).
        If the gamepad is digital, then each direction will read as either `-1`, `0`, or `1` (in fixed representation).
        The primary button on the gamepad is `A`., x: /,y: /
        """
        self.refresh_reading()
        return self.register(JD_GAMEPAD_REG_DIRECTION).value(self.missing_direction_value)

    @property
    def variant(self) -> Optional[GamepadVariant]:
        """
        (Optional) The type of physical gamepad., 
        """
        return self.register(JD_GAMEPAD_REG_VARIANT).value()

    @property
    def buttons_available(self) -> Optional[GamepadButtons]:
        """
        Indicates a bitmask of the buttons that are mounted on the gamepad.
        If the `Left`/`Up`/`Right`/`Down` buttons are marked as available here, the gamepad is digital.
        Even when marked as not available, they will still be simulated based on the analog gamepad., 
        """
        return self.register(JD_GAMEPAD_REG_BUTTONS_AVAILABLE).value()

    def on_buttons_changed(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted whenever the state of buttons changes.
        """
        return self.on_event(JD_GAMEPAD_EV_BUTTONS_CHANGED, handler)

    
