# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient
from .constants import *
from typing import Optional


class AirQualityIndexClient(SensorClient):
    """
    The Air Quality Index is a measure of how clean or polluted air is. From min, good quality, to high, low quality.
     * The range of AQI may vary between countries (https://en.wikipedia.org/wiki/Air_quality_index).
    Implements a client for the `Air Quality Index <https://microsoft.github.io/jacdac-docs/services/airqualityindex>`_ service.

    """

    def __init__(self, bus: Bus, role: str, *, missing_aqi_index_value: Optional[float] = None) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_AIR_QUALITY_INDEX, JD_AIR_QUALITY_INDEX_PACK_FORMATS, role, preferred_interval = 60000)
        self.missing_aqi_index_value = missing_aqi_index_value

    @property
    def aqi_index(self) -> Optional[float]:
        """
        Air quality index, typically refreshed every second., _: AQI
        """
        self.refresh_reading()
        return self.register(JD_AIR_QUALITY_INDEX_REG_AQI_INDEX).value(self.missing_aqi_index_value)

    @property
    def aqi_index_error(self) -> Optional[float]:
        """
        (Optional) Error on the AQI measure., _: AQI
        """
        return self.register(JD_AIR_QUALITY_INDEX_REG_AQI_INDEX_ERROR).value()

    @property
    def min_aqi_index(self) -> Optional[float]:
        """
        Minimum AQI reading, representing a good air quality. Typically 0., _: AQI
        """
        return self.register(JD_AIR_QUALITY_INDEX_REG_MIN_AQI_INDEX).value()

    @property
    def max_aqi_index(self) -> Optional[float]:
        """
        Maximum AQI reading, representing a very poor air quality., _: AQI
        """
        return self.register(JD_AIR_QUALITY_INDEX_REG_MAX_AQI_INDEX).value()

    
