# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient
from .constants import *
from typing import Optional


class DcVoltageMeasurementClient(SensorClient):
    """
    A service that reports a voltage measurement.
    Implements a client for the `DC Voltage Measurement <https://microsoft.github.io/jacdac-docs/services/dcvoltagemeasurement>`_ service.

    """

    def __init__(self, bus: Bus, role: str, *, missing_measurement_value: Optional[float] = None) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_DC_VOLTAGE_MEASUREMENT, JD_DC_VOLTAGE_MEASUREMENT_PACK_FORMATS, role)
        self.missing_measurement_value = missing_measurement_value

    @property
    def measurement_type(self) -> Optional[DcVoltageMeasurementVoltageMeasurementType]:
        """
        The type of measurement that is taking place. Absolute results are measured with respect to ground, whereas differential results are measured against another signal that is not ground., 
        """
        return self.register(JD_DC_VOLTAGE_MEASUREMENT_REG_MEASUREMENT_TYPE).value()

    @property
    def measurement_name(self) -> Optional[str]:
        """
        A string containing the net name that is being measured e.g. `POWER_DUT` or a reference e.g. `DIFF_DEV1_DEV2`. These constants can be used to identify a measurement from client code., 
        """
        return self.register(JD_DC_VOLTAGE_MEASUREMENT_REG_MEASUREMENT_NAME).value()

    @property
    def measurement(self) -> Optional[float]:
        """
        The voltage measurement., _: V
        """
        self.refresh_reading()
        return self.register(JD_DC_VOLTAGE_MEASUREMENT_REG_MEASUREMENT).value(self.missing_measurement_value)

    @property
    def measurement_error(self) -> Optional[float]:
        """
        (Optional) Absolute error on the reading value., _: V
        """
        return self.register(JD_DC_VOLTAGE_MEASUREMENT_REG_MEASUREMENT_ERROR).value()

    @property
    def min_measurement(self) -> Optional[float]:
        """
        (Optional) Minimum measurable current, _: V
        """
        return self.register(JD_DC_VOLTAGE_MEASUREMENT_REG_MIN_MEASUREMENT).value()

    @property
    def max_measurement(self) -> Optional[float]:
        """
        (Optional) Maximum measurable current, _: V
        """
        return self.register(JD_DC_VOLTAGE_MEASUREMENT_REG_MAX_MEASUREMENT).value()

    
