# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class PressureButtonClient(Client):
    """
    A pressure sensitive push-button.
    Implements a client for the `Pressure Button <https://microsoft.github.io/jacdac-docs/services/pressurebutton>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_PRESSURE_BUTTON, JD_PRESSURE_BUTTON_PACK_FORMATS, role)


    @property
    def threshold(self) -> Optional[float]:
        """
        Indicates the threshold for ``up`` events., _: /
        """
        return self.register(JD_PRESSURE_BUTTON_REG_THRESHOLD).float_value(100)

    @threshold.setter
    def threshold(self, value: float) -> None:
        self.register(JD_PRESSURE_BUTTON_REG_THRESHOLD).set_values(value / 100)


    
