# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient
from .constants import *
from typing import Optional, Tuple


class PlanarPositionClient(SensorClient):
    """
    A sensor that repors 2D position, typically an optical mouse tracking sensor.
     * 
     * The sensor starts at an arbitrary origin (0,0) and reports the distance from that origin.
     * 
     * The `streaming_interval` is respected when the position is changing. When the position is not changing, the streaming interval may be throttled to `500ms`.
    Implements a client for the `Planar position <https://microsoft.github.io/jacdac-docs/services/planarposition>`_ service.

    """

    def __init__(self, bus: Bus, role: str, *, missing_position_value: Optional[Tuple[float, float]] = None) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_PLANAR_POSITION, JD_PLANAR_POSITION_PACK_FORMATS, role)
        self.missing_position_value = missing_position_value

    @property
    def position(self) -> Optional[Tuple[float, float]]:
        """
        The current position of the sensor., x: mm,y: mm
        """
        self.refresh_reading()
        return self.register(JD_PLANAR_POSITION_REG_POSITION).value(self.missing_position_value)

    @property
    def variant(self) -> Optional[PlanarPositionVariant]:
        """
        (Optional) Specifies the type of physical sensor., 
        """
        return self.register(JD_PLANAR_POSITION_REG_VARIANT).value()

    
