# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient, EventHandlerFn, UnsubscribeFn
from .constants import *
from typing import Optional, Tuple


class SatNavClient(SensorClient):
    """
    A satellite-based navigation system like GPS, Gallileo, ...
    Implements a client for the `Satellite Navigation System <https://microsoft.github.io/jacdac-docs/services/satelittenavigationsystem>`_ service.

    """

    def __init__(self, bus: Bus, role: str, *, missing_position_value: Optional[Tuple[int, float, float, float, float, float]] = None) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_SAT_NAV, JD_SAT_NAV_PACK_FORMATS, role)
        self.missing_position_value = missing_position_value

    @property
    def position(self) -> Optional[Tuple[int, float, float, float, float, float]]:
        """
        Reported coordinates, geometric altitude and time of position. Altitude accuracy is 0 if not available., timestamp: ms,latitude: lat,longitude: lon,accuracy: m,altitude: m,altitudeAccuracy: m
        """
        self.refresh_reading()
        return self.register(JD_SAT_NAV_REG_POSITION).value(self.missing_position_value)

    @property
    def enabled(self) -> Optional[bool]:
        """
        Enables or disables the GPS module, 
        """
        return self.register(JD_SAT_NAV_REG_ENABLED).bool_value()

    @enabled.setter
    def enabled(self, value: bool) -> None:
        self.register(JD_SAT_NAV_REG_ENABLED).set_values(value)


    def on_inactive(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        The module is disabled or lost connection with satellites.
        """
        return self.on_event(JD_SAT_NAV_EV_INACTIVE, handler)

    
