# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class BitRadioClient(Client):
    """
    Support for sending and receiving packets using the [Bit Radio protocol](https://github.com/microsoft/pxt-common-packages/blob/master/libs/radio/docs/reference/radio.md), typically used between micro:bit devices.
    Implements a client for the `bit:radio <https://microsoft.github.io/jacdac-docs/services/bitradio>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_BIT_RADIO, JD_BIT_RADIO_PACK_FORMATS, role)


    @property
    def enabled(self) -> Optional[bool]:
        """
        Turns on/off the radio antenna., 
        """
        return self.register(JD_BIT_RADIO_REG_ENABLED).bool_value()

    @enabled.setter
    def enabled(self, value: bool) -> None:
        self.register(JD_BIT_RADIO_REG_ENABLED).set_values(value)


    @property
    def group(self) -> Optional[int]:
        """
        Group used to filter packets, 
        """
        return self.register(JD_BIT_RADIO_REG_GROUP).value()

    @group.setter
    def group(self, value: int) -> None:
        self.register(JD_BIT_RADIO_REG_GROUP).set_values(value)


    @property
    def transmission_power(self) -> Optional[int]:
        """
        Antenna power to increase or decrease range., 
        """
        return self.register(JD_BIT_RADIO_REG_TRANSMISSION_POWER).value()

    @transmission_power.setter
    def transmission_power(self, value: int) -> None:
        self.register(JD_BIT_RADIO_REG_TRANSMISSION_POWER).set_values(value)


    @property
    def frequency_band(self) -> Optional[int]:
        """
        Change the transmission and reception band of the radio to the given channel., 
        """
        return self.register(JD_BIT_RADIO_REG_FREQUENCY_BAND).value()

    @frequency_band.setter
    def frequency_band(self, value: int) -> None:
        self.register(JD_BIT_RADIO_REG_FREQUENCY_BAND).set_values(value)



    def send_string(self, message: str) -> None:
        """
        Sends a string payload as a radio message, maximum 18 characters.
        """
        self.send_cmd_packed(JD_BIT_RADIO_CMD_SEND_STRING, message)

    def send_number(self, value: float) -> None:
        """
        Sends a double precision number payload as a radio message
        """
        self.send_cmd_packed(JD_BIT_RADIO_CMD_SEND_NUMBER, value)

    def send_value(self, value: float, name: str) -> None:
        """
        Sends a double precision number and a name payload as a radio message
        """
        self.send_cmd_packed(JD_BIT_RADIO_CMD_SEND_VALUE, value, name)

    def send_buffer(self, data: bytes) -> None:
        """
        Sends a payload of bytes as a radio message
        """
        self.send_cmd_packed(JD_BIT_RADIO_CMD_SEND_BUFFER, data)
    
