# Janus Python SDK Documentation

This repository contains the official documentation for the Janus Python SDK - a comprehensive AI agent testing and evaluation framework.

## What is Janus?

Janus Python SDK helps you build, test, and evaluate AI applications through automated conversations, function call tracing, and rule-based evaluation. It's designed to stress-test your AI agents with thousands of conversations, each simulating different personalities, intents, and edge cases.

## Key Features

- **Automated Testing**: Run multiple conversation simulations with different personas
- **Function Tracing**: Track every function call and tool usage automatically
- **Performance Evaluation**: Enforce domain-specific rules and monitor custom KPIs
- **Hallucination Detection**: Validate agent responses against your knowledge base
- **Framework Integration**: Works seamlessly with popular frameworks like LangChain

## Quick Start

1. **Install the SDK**:
   ```bash
   pip install janus-python-sdk
   ```

2. **Get an API Key**: Contact [team@withjanus.com](mailto:team@withjanus.com)

3. **Run Your First Test**: Follow our [quickstart guide](quickstart) to test your first AI agent in under 5 minutes

## Documentation Structure

- **[Getting Started](index)**: Overview and introduction to Janus
- **[Quickstart](quickstart)**: Get up and running in 5 minutes
- **[Installation](installation)**: Setup and configuration guide
- **[Core Concepts](concepts/agent-testing)**: Understanding agent testing, tracing, and evaluation
- **[API Reference](api-reference/run-simulations)**: Complete SDK documentation
- **[Webapp Setup](concepts/webapp-setup)**: Configuring your testing environment
- **[Support](support)**: Get help and contact information

## Development

This documentation is built with [Mintlify](https://mintlify.com). To preview changes locally:

```bash
npm i -g mint
mint dev
```

## Need Help?

- **Documentation**: Browse the guides above
- **Support**: Email [team@withjanus.com](mailto:team@withjanus.com)
- **Dashboard**: Access your results at [app.withjanus.com](https://app.withjanus.com)

## Contributing

Found an issue or want to improve the documentation? Please open an issue or submit a pull request.
