from typing import Any, Optional, Union

from java.lang import Appendable, CharSequence, Object

class Buffer(Object):
    def array(self) -> Object: ...
    def arrayOffset(self) -> int: ...
    def capacity(self) -> int: ...
    def clear(self) -> Buffer: ...
    def duplicate(self) -> Buffer: ...
    def flip(self) -> Buffer: ...
    def hasArray(self) -> bool: ...
    def hasRemaining(self) -> bool: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def limit(self, nrewLimit: Optional[int] = ...) -> Union[Buffer, int]: ...
    def mark(self) -> Buffer: ...
    def position(self, newPosition: Optional[int] = ...) -> Union[Buffer, int]: ...
    def remaining(self) -> int: ...
    def reset(self) -> Buffer: ...
    def rewind(self) -> Buffer: ...
    def slice(self) -> Buffer: ...

class ByteBuffer(Buffer):
    def alignedSlice(self, unitSize: int) -> ByteBuffer: ...
    def alignmentOffset(self, index: int, unitSize: int) -> int: ...
    @staticmethod
    def allocate(capacity: int) -> ByteBuffer: ...
    @staticmethod
    def allocateDirect(capacity: int) -> ByteBuffer: ...
    def array(self) -> Object: ...
    def arrayOffset(self) -> int: ...
    def asCharBuffer(self) -> CharBuffer: ...
    def asDoubleBuffer(self) -> DoubleBuffer: ...
    def asFloatBuffer(self) -> FloatBuffer: ...
    def asIntBuffer(self) -> IntBuffer: ...
    def asLongBuffer(self) -> LongBuffer: ...
    def asReadOnlyBuffer(self) -> ByteBuffer: ...
    def asShortBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ByteBuffer: ...
    def compareTo(self, that: ByteBuffer) -> int: ...
    def duplicate(self) -> Buffer: ...
    def get(self, *args: Any) -> ByteBuffer: ...
    def getChar(self, index: int = ...) -> str: ...
    def getDouble(self, index: int = ...) -> float: ...
    def getFloat(self, index: int = ...) -> float: ...
    def getInt(self, index: int = ...) -> int: ...
    def getLong(self, index: int = ...) -> long: ...
    def getShort(self, index: int = ...) -> int: ...
    def hasArray(self) -> bool: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def mismatch(self, that: ByteBuffer) -> int: ...
    def order(self, bo: Optional[ByteOrder] = ...) -> ByteOrder: ...
    def put(self, *args: Any) -> ByteBuffer: ...
    def putChar(self, *args: Any) -> ByteBuffer: ...
    def putDouble(self, *args: Any) -> ByteBuffer: ...
    def putFloat(self, *args: Any) -> ByteBuffer: ...
    def putInt(self, *args: Any) -> ByteBuffer: ...
    def putLong(self, *args: Any) -> ByteBuffer: ...
    def putShort(self, *args: Any) -> ByteBuffer: ...
    def slice(self) -> ByteBuffer: ...
    @staticmethod
    def wrap(*arg: Any) -> ByteBuffer: ...

class ByteOrder(Object):
    BIG_ENDIAN: ByteOrder
    LITTLE_ENDIAN: ByteOrder
    @staticmethod
    def nativeOrder() -> ByteOrder: ...

class CharBuffer(Buffer, Appendable, CharSequence):
    @staticmethod
    def allocate(capacity: int) -> CharBuffer: ...
    def append(
        self, c_csq: Union[CharSequence, str], start: int = ..., end: int = ...
    ) -> CharBuffer: ...
    def array(self) -> Object: ...
    def arrayOffset(self) -> int: ...
    def charAt(self, index: int) -> str: ...
    def compact(self) -> CharBuffer: ...
    def compareTo(self, that: CharBuffer) -> int: ...
    def duplicate(self) -> CharBuffer: ...
    def get(self, *args: Any) -> CharBuffer: ...
    def hasArray(self) -> bool: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def length(self) -> int: ...
    def mismatch(self, that: CharBuffer) -> int: ...
    def order(self) -> ByteOrder: ...
    def put(self, *args: Any) -> CharBuffer: ...
    def read(self, target: CharBuffer) -> int: ...
    def slice(self) -> CharBuffer: ...
    def subSequence(self, start: int, end: int) -> CharSequence: ...
    @staticmethod
    def wrap(*args: Any) -> CharBuffer: ...

class DoubleBuffer(Buffer):
    @staticmethod
    def allocate(capacity: int) -> DoubleBuffer: ...
    def array(self) -> Object: ...
    def arrayOffset(self) -> int: ...
    def compact(self) -> DoubleBuffer: ...
    def compareTo(self, that: DoubleBuffer) -> int: ...
    def duplicate(self) -> DoubleBuffer: ...
    def get(self, *args: Any) -> DoubleBuffer: ...
    def hasArray(self) -> bool: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def mismatch(self, that: DoubleBuffer) -> int: ...
    def order(self) -> ByteOrder: ...
    def put(self, *args: Any) -> DoubleBuffer: ...
    def slice(self) -> DoubleBuffer: ...
    @staticmethod
    def wrap(*args: Any) -> DoubleBuffer: ...

class FloatBuffer(Buffer):
    @staticmethod
    def allocate(capacity: int) -> FloatBuffer: ...
    def array(self) -> Object: ...
    def arrayOffset(self) -> int: ...
    def compact(self) -> FloatBuffer: ...
    def compareTo(self, that: FloatBuffer) -> int: ...
    def duplicate(self) -> FloatBuffer: ...
    def get(self, *args: Any) -> FloatBuffer: ...
    def hasArray(self) -> bool: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def mismatch(self, that: FloatBuffer) -> int: ...
    def order(self) -> ByteOrder: ...
    def put(self, *args: Any) -> FloatBuffer: ...
    def slice(self) -> FloatBuffer: ...
    @staticmethod
    def wrap(*args: Any) -> FloatBuffer: ...

class IntBuffer(Buffer):
    @staticmethod
    def allocate(capacity: int) -> IntBuffer: ...
    def array(self) -> Object: ...
    def arrayOffset(self) -> int: ...
    def compact(self) -> IntBuffer: ...
    def compareTo(self, that: IntBuffer) -> int: ...
    def duplicate(self) -> IntBuffer: ...
    def get(self, *args: Any) -> IntBuffer: ...
    def hasArray(self) -> bool: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def mismatch(self, that: IntBuffer) -> int: ...
    def order(self) -> ByteOrder: ...
    def put(self, *args: Any) -> IntBuffer: ...
    def slice(self) -> IntBuffer: ...
    @staticmethod
    def wrap(*args: Any) -> IntBuffer: ...

class LongBuffer(Buffer):
    @staticmethod
    def allocate(capacity: int) -> LongBuffer: ...
    def array(self) -> Object: ...
    def arrayOffset(self) -> int: ...
    def compact(self) -> LongBuffer: ...
    def compareTo(self, that: LongBuffer) -> int: ...
    def duplicate(self) -> LongBuffer: ...
    def get(self, *args: Any) -> LongBuffer: ...
    def hasArray(self) -> bool: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def mismatch(self, that: LongBuffer) -> int: ...
    def order(self) -> ByteOrder: ...
    def put(self, *args: Any) -> LongBuffer: ...
    def slice(self) -> LongBuffer: ...
    @staticmethod
    def wrap(*args: Any) -> LongBuffer: ...

class ShortBuffer(Buffer):
    @staticmethod
    def allocate(capacity: int) -> ShortBuffer: ...
    def array(self) -> Object: ...
    def arrayOffset(self) -> int: ...
    def compact(self) -> ShortBuffer: ...
    def compareTo(self, that: ShortBuffer) -> int: ...
    def duplicate(self) -> ShortBuffer: ...
    def get(self, *args: Any) -> ShortBuffer: ...
    def hasArray(self) -> bool: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def mismatch(self, that: ShortBuffer) -> int: ...
    def order(self) -> ByteOrder: ...
    def put(self, *args: Any) -> ShortBuffer: ...
    def slice(self) -> ShortBuffer: ...
    @staticmethod
    def wrap(*args: Any) -> ShortBuffer: ...

class MappedByteBuffer(ByteBuffer):
    def force(self) -> MappedByteBuffer: ...
    def isLoaded(self) -> bool: ...
    def load(self) -> MappedByteBuffer: ...
