from typing import Any, List, Union

from java.lang import Enum, Object
from java.security import Principal
from java.time import Instant
from java.util.concurrent import TimeUnit

class AttributeView:
    def name(self) -> Union[str, unicode]: ...

class BasicFileAttributes:
    def creationTime(self) -> FileTime: ...
    def fileKey(self) -> Object: ...
    def isDirectory(self) -> bool: ...
    def isOther(self) -> bool: ...
    def isRegularFile(self) -> bool: ...
    def isSymbolicLink(self) -> bool: ...
    def lastAccessTime(self) -> FileTime: ...
    def lastModifiedTime(self) -> FileTime: ...
    def size(self) -> long: ...

class FileAttribute:
    def name(self) -> Union[str, unicode]: ...
    def value(self) -> Any: ...

class FileAttributeView(AttributeView):
    def name(self) -> Union[str, unicode]: ...

class FileTime(Object):
    def compareTo(self, other: FileTime) -> int: ...
    @staticmethod
    def fromMillis(value: long) -> FileTime: ...
    def to(self, unit: TimeUnit) -> long: ...
    def toInstant(self) -> Instant: ...
    def toMillis(self) -> long: ...

class PosixFilePermission(Enum):
    GROUP_EXECUTE: PosixFilePermission
    GROUP_READ: PosixFilePermission
    GROUP_WRITE: PosixFilePermission
    OTHERS_EXECUTE: PosixFilePermission
    OTHERS_READ: PosixFilePermission
    OTHERS_WRITE: PosixFilePermission
    OWNER_EXECUTE: PosixFilePermission
    OWNER_READ: PosixFilePermission
    OWNER_WRITE: PosixFilePermission
    @staticmethod
    def values() -> List[PosixFilePermission]: ...

class UserPrincipal(Principal):
    def equals(self, another: Object) -> bool: ...
    def getName(self) -> Union[str, unicode]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> Union[str, unicode]: ...

class FileStoreAttributeView(AttributeView):
    def name(self) -> Union[str, unicode]: ...
