from typing import Any, List, Optional, Union

from java.lang import CharSequence, Object, StringBuffer, StringBuilder
from java.util.function import Function, Predicate

class MatchResult:
    def end(self, group: Optional[int] = ...) -> int: ...
    def group(self, group: Optional[int] = ...) -> Union[str, unicode]: ...
    def groupCount(self) -> int: ...
    def start(self, group: Optional[int] = ...) -> int: ...

class Matcher(Object, MatchResult):
    def appendReplacement(
        self, sb: Union[StringBuffer, StringBuilder], replacement: Union[str, unicode]
    ) -> Matcher: ...
    def appendTail(
        self, sb: Union[StringBuffer, StringBuilder]
    ) -> Union[StringBuffer, StringBuilder]: ...
    def end(self, group: Optional[int] = ...) -> int: ...
    def find(self, start: Optional[int] = ...) -> bool: ...
    def group(
        self, group: Union[int, str, unicode, None] = ...
    ) -> Union[str, unicode]: ...
    def groupCount(self) -> int: ...
    def hasAnchoringBounds(self) -> bool: ...
    def hasTransparentBounds(self) -> bool: ...
    def hitEnd(self) -> bool: ...
    def lookingAt(self) -> bool: ...
    def matches(self) -> bool: ...
    def pattern(self) -> Pattern: ...
    @staticmethod
    def quoteReplacement(s: Union[str, unicode]) -> Union[str, unicode]: ...
    def region(self, start: int, end: int) -> Matcher: ...
    def regionEnd(self) -> int: ...
    def regionStart(self) -> int: ...
    def replaceAll(self, arg: Union[str, unicode, Function]) -> Union[str, unicode]: ...
    def replaceFirst(
        self, arg: Union[str, unicode, Function]
    ) -> Union[str, unicode]: ...
    def requireEnd(self) -> bool: ...
    def reset(self, input: Optional[CharSequence] = ...) -> Matcher: ...
    def results(self) -> Any: ...
    def start(self, group: Optional[int] = ...) -> int: ...
    def toMatchResult(self) -> MatchResult: ...
    def useAnchoringBounds(self, b: bool) -> Matcher: ...
    def usePattern(self, newPattern: Pattern) -> Matcher: ...
    def useTransparentBounds(self, b: bool) -> Matcher: ...

class Pattern(Object):
    CANON_EQ: int
    CASE_INSENSITIVE: int
    COMMENTS: int
    DOTALL: int
    LITERAL: int
    MULTILINE: int
    UNICODE_CASE: int
    UNICODE_CHARACTER_CLASS: int
    UNIX_LINES: int
    def asMatchPredicate(self) -> Predicate: ...
    def asPredicate(self) -> Predicate: ...
    @staticmethod
    def compile(regex: Union[str, unicode], flags: Optional[int] = ...) -> Pattern: ...
    def flags(self) -> int: ...
    def matcher(self, input: CharSequence) -> Matcher: ...
    @staticmethod
    def matches(regex: Union[str, unicode], input: CharSequence) -> bool: ...
    def pattern(self) -> Union[str, unicode]: ...
    @staticmethod
    def quote(s: Union[str, unicode]) -> Union[str, unicode]: ...
    def split(
        self, input: CharSequence, limit: Optional[int] = ...
    ) -> List[Union[str, unicode]]: ...
    def splitAsStream(self, input: CharSequence) -> Any: ...
