from typing import Any, Dict, List, Optional, Union

from java.lang import Enum, Object
from java.time import Duration
from java.time.format import ResolverStyle
from java.util import Locale

class TemporalAccessor:
    def get(self, field: TemporalField) -> int: ...
    def getLong(self, field: TemporalField) -> long: ...
    def isSupported(self, field: TemporalField) -> bool: ...
    def query(self, query: TemporalQuery) -> Any: ...
    def range(self, field: TemporalField) -> ValueRange: ...

class TemporalAdjuster:
    def adjustInto(self, temporal: Temporal) -> Temporal: ...

class TemporalAmount:
    def addTo(self, temporal: Temporal) -> Temporal: ...
    def get(self, unit: TemporalUnit) -> long: ...
    def getUnits(self) -> List[TemporalUnit]: ...
    def subtractFrom(self, temporal: Temporal) -> Temporal: ...

class TemporalField:
    def adjustInto(self, temporal: Any, newValue: long) -> Temporal: ...
    def getBaseUnit(self) -> TemporalUnit: ...
    def getDisplayName(self, locale: Locale) -> Union[str, unicode]: ...
    def getFrom(self, temporal: TemporalAccessor) -> long: ...
    def getRangeUnit(self) -> TemporalUnit: ...
    def isDateBased(self) -> bool: ...
    def isSupportedBy(self, temporal: TemporalAccessor) -> bool: ...
    def isTimeBased(self) -> bool: ...
    def range(self) -> ValueRange: ...
    def rangeRefinedBy(self, temporal: TemporalAccessor) -> ValueRange: ...
    def resolve(
        self,
        fieldValues: Dict[TemporalField, long],
        partialTemporal: TemporalAccessor,
        resolverStyle: ResolverStyle,
    ) -> TemporalAccessor: ...
    def toString(self) -> Union[str, unicode]: ...

class TemporalQuery:
    def queryFrom(self, temporal: TemporalAccessor) -> Any: ...

class TemporalUnit:
    def addTo(self, temporal: Temporal, amount: long) -> Temporal: ...
    def between(
        self, temporal1Inclusive: Temporal, temporal2Exclusive: Temporal
    ) -> Temporal: ...
    def isSupportedBy(self, temporal: Temporal) -> bool: ...
    def getDuration(self) -> Duration: ...
    def isDateBased(self) -> bool: ...
    def isDurationEstimated(self) -> bool: ...
    def isTimeBased(self) -> bool: ...
    def toString(self) -> Union[str, unicode]: ...

class Temporal(TemporalAccessor):
    def minus(self, amount: long, unit: Optional[TemporalUnit] = ...) -> Temporal: ...
    def plus(self, amount: long, unit: Optional[TemporalUnit] = ...) -> Temporal: ...
    def until(self, endExclusive: Temporal, unit: TemporalUnit) -> long: ...

class ChronoField(Enum, TemporalField):
    ALIGNED_DAY_OF_WEEK_IN_MONTH: ChronoField
    ALIGNED_DAY_OF_WEEK_IN_YEAR: ChronoField
    ALIGNED_WEEK_OF_MONTH: ChronoField
    ALIGNED_WEEK_OF_YEAR: ChronoField
    AMPM_OF_DAY: ChronoField
    CLOCK_HOUR_OF_AMPM: ChronoField
    CLOCK_HOUR_OF_DAY: ChronoField
    DAY_OF_MONTH: ChronoField
    DAY_OF_WEEK: ChronoField
    DAY_OF_YEAR: ChronoField
    EPOCH_DAY: ChronoField
    ERA: ChronoField
    HOUR_OF_AMPM: ChronoField
    HOUR_OF_DAY: ChronoField
    INSTANT_SECONDS: ChronoField
    MICRO_OF_DAY: ChronoField
    MICRO_OF_SECOND: ChronoField
    MILLI_OF_DAY: ChronoField
    MILLI_OF_SECOND: ChronoField
    MINUTE_OF_DAY: ChronoField
    MINUTE_OF_HOUR: ChronoField
    MONTH_OF_YEAR: ChronoField
    NANO_OF_DAY: ChronoField
    NANO_OF_SECOND: ChronoField
    OFFSET_SECONDS: ChronoField
    PROLEPTIC_MONTH: ChronoField
    SECOND_OF_DAY: ChronoField
    SECOND_OF_MINUTE: ChronoField
    YEAR: ChronoField
    YEAR_OF_ERA: ChronoField
    def adjustInto(self, temporal: Temporal, newValue: long) -> Temporal: ...
    def checkValidIntValue(self, value: long) -> int: ...
    def checkValidValue(self, value: long) -> long: ...
    def getBaseUnit(self) -> TemporalUnit: ...
    def getFrom(self, temporal: TemporalAccessor) -> long: ...
    def getRangeUnit(self) -> TemporalUnit: ...
    def isDateBased(self) -> bool: ...
    def isSupportedBy(self, temporal: TemporalAccessor) -> bool: ...
    def isTimeBased(self) -> bool: ...
    def range(self) -> ValueRange: ...
    def rangeRefinedBy(self, temporal: TemporalAccessor) -> ValueRange: ...
    @staticmethod
    def values() -> List[ChronoField]: ...

class ChronoUnit(Enum, TemporalUnit):
    CENTURIES: ChronoUnit
    DAYS: ChronoUnit
    DECADES: ChronoUnit
    ERAS: ChronoUnit
    FOREVER: ChronoUnit
    MICROS: ChronoUnit
    MILLENNIA: ChronoUnit
    MILLIS: ChronoUnit
    MINUTES: ChronoUnit
    MONTHS: ChronoUnit
    NANOS: ChronoUnit
    SECONDS: ChronoUnit
    HALF_DAYS: ChronoUnit
    HOURS: ChronoUnit
    WEEKS: ChronoUnit
    YEARS: ChronoUnit
    def addTo(self, temporal: Temporal, amount: long) -> Temporal: ...
    def between(
        self, temporal1Inclusive: Temporal, temporal2Exclusive: Temporal
    ) -> Temporal: ...
    def getDuration(self) -> Duration: ...
    def isDateBased(self) -> bool: ...
    def isDurationEstimated(self) -> bool: ...
    def isTimeBased(self) -> bool: ...
    @staticmethod
    def values() -> List[ChronoUnit]: ...

class ValueRange(Object):
    def checkValidIntValue(self, value: long, field: TemporalField) -> int: ...
    def checkValidValue(self, value: long, field: TemporalField) -> long: ...
    def getLargestMinimum(self) -> long: ...
    def getMaximum(self) -> long: ...
    def getMinimum(self) -> long: ...
    def getSmallestMaximum(self) -> long: ...
    def isFixed(self) -> bool: ...
    def isIntValue(self) -> bool: ...
    def isValidIntValue(self, value: long) -> bool: ...
    def isValidValue(self, value: long) -> bool: ...
    @staticmethod
    def of(*args: Any) -> ValueRange: ...
