from typing import Any

from java.lang import Object

class BiConsumer:
    def accept(self, t: Any, u: Any) -> None: ...
    def andThen(self, after: BiConsumer) -> BiConsumer: ...

class BiFunction:
    def andThen(self, after: Function) -> BiFunction: ...
    def apply(self, t: Any, u: Any) -> Any: ...

class BiPredicate:
    def negate(self) -> BiPredicate: ...
    def test(self, t: Any, u: Any) -> bool: ...

class BinaryOperator(BiFunction):
    def apply(self, t: Any, u: Any) -> Any: ...
    @staticmethod
    def maxBy(comparator: Any) -> BinaryOperator: ...
    @staticmethod
    def minBy(comparator: Any) -> BinaryOperator: ...

class Consumer:
    def accept(self, t: Any) -> None: ...
    def andThen(self, after: Consumer) -> Consumer: ...

class Function:
    def andThen(self, after: Function) -> Function: ...
    def apply(self, t: Any) -> Any: ...
    def compose(self, before: Function) -> Function: ...
    @staticmethod
    def identity() -> Function: ...

class IntConsumer:
    def accept(self, value: int) -> None: ...
    def andThen(self, after: IntConsumer) -> IntConsumer: ...

class IntPredicate:
    def negate(self) -> IntPredicate: ...
    def test(self, value: int) -> bool: ...

class Predicate:
    @staticmethod
    def isEqual(targetRef: Object) -> Predicate: ...
    def negate(self) -> Predicate: ...
    def test(self, t: Any) -> bool: ...

class Supplier:
    def get(self) -> Any: ...

class ToDoubleFunction:
    def applyAsDouble(self, value: Any) -> object: ...

class ToIntFunction:
    def applyAsInt(self, value: Any) -> object: ...

class ToLongFunction:
    def applyAsLong(self, value: Any) -> object: ...
