
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.awt
import java.awt.datatransfer
import java.awt.dnd
import typing



class DragSourceContextPeer:
    def getCursor(self) -> java.awt.Cursor: ...
    def setCursor(self, cursor: java.awt.Cursor) -> None: ...
    def startDrag(self, dragSourceContext: java.awt.dnd.DragSourceContext, cursor: java.awt.Cursor, image: java.awt.Image, point: java.awt.Point) -> None: ...
    def transferablesFlavorsChanged(self) -> None: ...

class DropTargetContextPeer:
    def acceptDrag(self, int: int) -> None: ...
    def acceptDrop(self, int: int) -> None: ...
    def dropComplete(self, boolean: bool) -> None: ...
    def getDropTarget(self) -> java.awt.dnd.DropTarget: ...
    def getTargetActions(self) -> int: ...
    def getTransferDataFlavors(self) -> typing.MutableSequence[java.awt.datatransfer.DataFlavor]: ...
    def getTransferable(self) -> java.awt.datatransfer.Transferable: ...
    def isTransferableJVMLocal(self) -> bool: ...
    def rejectDrag(self) -> None: ...
    def rejectDrop(self) -> None: ...
    def setTargetActions(self, int: int) -> None: ...

class DropTargetPeer:
    def addDropTarget(self, dropTarget: java.awt.dnd.DropTarget) -> None: ...
    def removeDropTarget(self, dropTarget: java.awt.dnd.DropTarget) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.awt.dnd.peer")``.

    DragSourceContextPeer: typing.Type[DragSourceContextPeer]
    DropTargetContextPeer: typing.Type[DropTargetContextPeer]
    DropTargetPeer: typing.Type[DropTargetPeer]
