
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.awt
import java.awt.geom
import java.awt.image
import java.io
import java.lang
import java.util
import typing



class ParameterBlock(java.lang.Cloneable, java.io.Serializable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, vector: java.util.Vector[typing.Any]): ...
    @typing.overload
    def __init__(self, vector: java.util.Vector[typing.Any], vector2: java.util.Vector[typing.Any]): ...
    @typing.overload
    def add(self, byte: int) -> 'ParameterBlock': ...
    @typing.overload
    def add(self, char: str) -> 'ParameterBlock': ...
    @typing.overload
    def add(self, double: float) -> 'ParameterBlock': ...
    @typing.overload
    def add(self, float: float) -> 'ParameterBlock': ...
    @typing.overload
    def add(self, int: int) -> 'ParameterBlock': ...
    @typing.overload
    def add(self, object: typing.Any) -> 'ParameterBlock': ...
    @typing.overload
    def add(self, long: int) -> 'ParameterBlock': ...
    @typing.overload
    def add(self, short: int) -> 'ParameterBlock': ...
    def addSource(self, object: typing.Any) -> 'ParameterBlock': ...
    def clone(self) -> typing.Any: ...
    def getByteParameter(self, int: int) -> int: ...
    def getCharParameter(self, int: int) -> str: ...
    def getDoubleParameter(self, int: int) -> float: ...
    def getFloatParameter(self, int: int) -> float: ...
    def getIntParameter(self, int: int) -> int: ...
    def getLongParameter(self, int: int) -> int: ...
    def getNumParameters(self) -> int: ...
    def getNumSources(self) -> int: ...
    def getObjectParameter(self, int: int) -> typing.Any: ...
    def getParamClasses(self) -> typing.MutableSequence[typing.Type[typing.Any]]: ...
    def getParameters(self) -> java.util.Vector[typing.Any]: ...
    def getRenderableSource(self, int: int) -> 'RenderableImage': ...
    def getRenderedSource(self, int: int) -> java.awt.image.RenderedImage: ...
    def getShortParameter(self, int: int) -> int: ...
    def getSource(self, int: int) -> typing.Any: ...
    def getSources(self) -> java.util.Vector[typing.Any]: ...
    def removeParameters(self) -> None: ...
    def removeSources(self) -> None: ...
    @typing.overload
    def set(self, byte: int, int: int) -> 'ParameterBlock': ...
    @typing.overload
    def set(self, char: str, int: int) -> 'ParameterBlock': ...
    @typing.overload
    def set(self, double: float, int: int) -> 'ParameterBlock': ...
    @typing.overload
    def set(self, float: float, int: int) -> 'ParameterBlock': ...
    @typing.overload
    def set(self, int: int, int2: int) -> 'ParameterBlock': ...
    @typing.overload
    def set(self, object: typing.Any, int: int) -> 'ParameterBlock': ...
    @typing.overload
    def set(self, long: int, int: int) -> 'ParameterBlock': ...
    @typing.overload
    def set(self, short: int, int: int) -> 'ParameterBlock': ...
    def setParameters(self, vector: java.util.Vector[typing.Any]) -> None: ...
    def setSource(self, object: typing.Any, int: int) -> 'ParameterBlock': ...
    def setSources(self, vector: java.util.Vector[typing.Any]) -> None: ...
    def shallowClone(self) -> typing.Any: ...

class RenderContext(java.lang.Cloneable):
    @typing.overload
    def __init__(self, affineTransform: java.awt.geom.AffineTransform): ...
    @typing.overload
    def __init__(self, affineTransform: java.awt.geom.AffineTransform, renderingHints: java.awt.RenderingHints): ...
    @typing.overload
    def __init__(self, affineTransform: java.awt.geom.AffineTransform, shape: java.awt.Shape): ...
    @typing.overload
    def __init__(self, affineTransform: java.awt.geom.AffineTransform, shape: java.awt.Shape, renderingHints: java.awt.RenderingHints): ...
    def clone(self) -> typing.Any: ...
    def concatenateTransform(self, affineTransform: java.awt.geom.AffineTransform) -> None: ...
    def concetenateTransform(self, affineTransform: java.awt.geom.AffineTransform) -> None: ...
    def getAreaOfInterest(self) -> java.awt.Shape: ...
    def getRenderingHints(self) -> java.awt.RenderingHints: ...
    def getTransform(self) -> java.awt.geom.AffineTransform: ...
    def preConcatenateTransform(self, affineTransform: java.awt.geom.AffineTransform) -> None: ...
    def preConcetenateTransform(self, affineTransform: java.awt.geom.AffineTransform) -> None: ...
    def setAreaOfInterest(self, shape: java.awt.Shape) -> None: ...
    def setRenderingHints(self, renderingHints: java.awt.RenderingHints) -> None: ...
    def setTransform(self, affineTransform: java.awt.geom.AffineTransform) -> None: ...

class RenderableImage:
    HINTS_OBSERVED: typing.ClassVar[str] = ...
    def createDefaultRendering(self) -> java.awt.image.RenderedImage: ...
    def createRendering(self, renderContext: RenderContext) -> java.awt.image.RenderedImage: ...
    def createScaledRendering(self, int: int, int2: int, renderingHints: java.awt.RenderingHints) -> java.awt.image.RenderedImage: ...
    def getHeight(self) -> float: ...
    def getMinX(self) -> float: ...
    def getMinY(self) -> float: ...
    def getProperty(self, string: str) -> typing.Any: ...
    def getPropertyNames(self) -> typing.MutableSequence[str]: ...
    def getSources(self) -> java.util.Vector['RenderableImage']: ...
    def getWidth(self) -> float: ...
    def isDynamic(self) -> bool: ...

class RenderableImageProducer(java.awt.image.ImageProducer, java.lang.Runnable):
    def __init__(self, renderableImage: RenderableImage, renderContext: RenderContext): ...
    def addConsumer(self, imageConsumer: java.awt.image.ImageConsumer) -> None: ...
    def isConsumer(self, imageConsumer: java.awt.image.ImageConsumer) -> bool: ...
    def removeConsumer(self, imageConsumer: java.awt.image.ImageConsumer) -> None: ...
    def requestTopDownLeftRightResend(self, imageConsumer: java.awt.image.ImageConsumer) -> None: ...
    def run(self) -> None: ...
    def setRenderContext(self, renderContext: RenderContext) -> None: ...
    def startProduction(self, imageConsumer: java.awt.image.ImageConsumer) -> None: ...

class RenderedImageFactory:
    def create(self, parameterBlock: ParameterBlock, renderingHints: java.awt.RenderingHints) -> java.awt.image.RenderedImage: ...

class ContextualRenderedImageFactory(RenderedImageFactory):
    @typing.overload
    def create(self, renderContext: RenderContext, parameterBlock: ParameterBlock) -> java.awt.image.RenderedImage: ...
    @typing.overload
    def create(self, parameterBlock: ParameterBlock, renderingHints: java.awt.RenderingHints) -> java.awt.image.RenderedImage: ...
    def getBounds2D(self, parameterBlock: ParameterBlock) -> java.awt.geom.Rectangle2D: ...
    def getProperty(self, parameterBlock: ParameterBlock, string: str) -> typing.Any: ...
    def getPropertyNames(self) -> typing.MutableSequence[str]: ...
    def isDynamic(self) -> bool: ...
    def mapRenderContext(self, int: int, renderContext: RenderContext, parameterBlock: ParameterBlock, renderableImage: RenderableImage) -> RenderContext: ...

class RenderableImageOp(RenderableImage):
    def __init__(self, contextualRenderedImageFactory: ContextualRenderedImageFactory, parameterBlock: ParameterBlock): ...
    def createDefaultRendering(self) -> java.awt.image.RenderedImage: ...
    def createRendering(self, renderContext: RenderContext) -> java.awt.image.RenderedImage: ...
    def createScaledRendering(self, int: int, int2: int, renderingHints: java.awt.RenderingHints) -> java.awt.image.RenderedImage: ...
    def getHeight(self) -> float: ...
    def getMinX(self) -> float: ...
    def getMinY(self) -> float: ...
    def getParameterBlock(self) -> ParameterBlock: ...
    def getProperty(self, string: str) -> typing.Any: ...
    def getPropertyNames(self) -> typing.MutableSequence[str]: ...
    def getSources(self) -> java.util.Vector[RenderableImage]: ...
    def getWidth(self) -> float: ...
    def isDynamic(self) -> bool: ...
    def setParameterBlock(self, parameterBlock: ParameterBlock) -> ParameterBlock: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.awt.image.renderable")``.

    ContextualRenderedImageFactory: typing.Type[ContextualRenderedImageFactory]
    ParameterBlock: typing.Type[ParameterBlock]
    RenderContext: typing.Type[RenderContext]
    RenderableImage: typing.Type[RenderableImage]
    RenderableImageOp: typing.Type[RenderableImageOp]
    RenderableImageProducer: typing.Type[RenderableImageProducer]
    RenderedImageFactory: typing.Type[RenderedImageFactory]
