
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java
import java.io
import java.lang
import java.lang.classfile.attribute
import java.lang.classfile.constantpool
import java.lang.classfile.instruction
import java.lang.constant
import java.lang.invoke
import java.lang.reflect
import java.nio.file
import java.util
import java.util.function
import java.util.stream
import jpype
import jpype.protocol
import typing



class Annotation:
    def className(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    def classSymbol(self) -> java.lang.constant.ClassDesc: ...
    def elements(self) -> java.util.List['AnnotationElement']: ...
    @typing.overload
    @staticmethod
    def of(utf8Entry: java.lang.classfile.constantpool.Utf8Entry, *annotationElement: 'AnnotationElement') -> 'Annotation': ...
    @typing.overload
    @staticmethod
    def of(utf8Entry: java.lang.classfile.constantpool.Utf8Entry, list: java.util.List['AnnotationElement']) -> 'Annotation': ...
    @typing.overload
    @staticmethod
    def of(classDesc: java.lang.constant.ClassDesc, *annotationElement: 'AnnotationElement') -> 'Annotation': ...
    @typing.overload
    @staticmethod
    def of(classDesc: java.lang.constant.ClassDesc, list: java.util.List['AnnotationElement']) -> 'Annotation': ...

class AnnotationElement:
    def name(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    @typing.overload
    @staticmethod
    def of(string: str, annotationValue: 'AnnotationValue') -> 'AnnotationElement': ...
    @typing.overload
    @staticmethod
    def of(utf8Entry: java.lang.classfile.constantpool.Utf8Entry, annotationValue: 'AnnotationValue') -> 'AnnotationElement': ...
    @staticmethod
    def ofAnnotation(string: str, annotation: Annotation) -> 'AnnotationElement': ...
    @staticmethod
    def ofArray(string: str, *annotationValue: 'AnnotationValue') -> 'AnnotationElement': ...
    @staticmethod
    def ofBoolean(string: str, boolean: bool) -> 'AnnotationElement': ...
    @staticmethod
    def ofByte(string: str, byte: int) -> 'AnnotationElement': ...
    @staticmethod
    def ofChar(string: str, char: str) -> 'AnnotationElement': ...
    @staticmethod
    def ofClass(string: str, classDesc: java.lang.constant.ClassDesc) -> 'AnnotationElement': ...
    @staticmethod
    def ofDouble(string: str, double: float) -> 'AnnotationElement': ...
    @staticmethod
    def ofFloat(string: str, float: float) -> 'AnnotationElement': ...
    @staticmethod
    def ofInt(string: str, int: int) -> 'AnnotationElement': ...
    @staticmethod
    def ofLong(string: str, long: int) -> 'AnnotationElement': ...
    @staticmethod
    def ofShort(string: str, short: int) -> 'AnnotationElement': ...
    @staticmethod
    def ofString(string: str, string2: str) -> 'AnnotationElement': ...
    def value(self) -> 'AnnotationValue': ...

_AttributeMapper__A = typing.TypeVar('_AttributeMapper__A', bound='Attribute')  # <A>
class AttributeMapper(typing.Generic[_AttributeMapper__A]):
    def allowMultiple(self) -> bool: ...
    def name(self) -> str: ...
    def readAttribute(self, attributedElement: 'AttributedElement', classReader: 'ClassReader', int: int) -> _AttributeMapper__A: ...
    def stability(self) -> 'AttributeMapper.AttributeStability': ...
    def writeAttribute(self, bufWriter: 'BufWriter', a: _AttributeMapper__A) -> None: ...
    class AttributeStability(java.lang.Enum['AttributeMapper.AttributeStability']):
        STATELESS: typing.ClassVar['AttributeMapper.AttributeStability'] = ...
        CP_REFS: typing.ClassVar['AttributeMapper.AttributeStability'] = ...
        LABELS: typing.ClassVar['AttributeMapper.AttributeStability'] = ...
        UNSTABLE: typing.ClassVar['AttributeMapper.AttributeStability'] = ...
        UNKNOWN: typing.ClassVar['AttributeMapper.AttributeStability'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'AttributeMapper.AttributeStability': ...
        @staticmethod
        def values() -> typing.MutableSequence['AttributeMapper.AttributeStability']: ...

class Attributes:
    NAME_ANNOTATION_DEFAULT: typing.ClassVar[str] = ...
    NAME_BOOTSTRAP_METHODS: typing.ClassVar[str] = ...
    NAME_CHARACTER_RANGE_TABLE: typing.ClassVar[str] = ...
    NAME_CODE: typing.ClassVar[str] = ...
    NAME_COMPILATION_ID: typing.ClassVar[str] = ...
    NAME_CONSTANT_VALUE: typing.ClassVar[str] = ...
    NAME_DEPRECATED: typing.ClassVar[str] = ...
    NAME_ENCLOSING_METHOD: typing.ClassVar[str] = ...
    NAME_EXCEPTIONS: typing.ClassVar[str] = ...
    NAME_INNER_CLASSES: typing.ClassVar[str] = ...
    NAME_LINE_NUMBER_TABLE: typing.ClassVar[str] = ...
    NAME_LOCAL_VARIABLE_TABLE: typing.ClassVar[str] = ...
    NAME_LOCAL_VARIABLE_TYPE_TABLE: typing.ClassVar[str] = ...
    NAME_METHOD_PARAMETERS: typing.ClassVar[str] = ...
    NAME_MODULE: typing.ClassVar[str] = ...
    NAME_MODULE_HASHES: typing.ClassVar[str] = ...
    NAME_MODULE_MAIN_CLASS: typing.ClassVar[str] = ...
    NAME_MODULE_PACKAGES: typing.ClassVar[str] = ...
    NAME_MODULE_RESOLUTION: typing.ClassVar[str] = ...
    NAME_MODULE_TARGET: typing.ClassVar[str] = ...
    NAME_NEST_HOST: typing.ClassVar[str] = ...
    NAME_NEST_MEMBERS: typing.ClassVar[str] = ...
    NAME_PERMITTED_SUBCLASSES: typing.ClassVar[str] = ...
    NAME_RECORD: typing.ClassVar[str] = ...
    NAME_RUNTIME_INVISIBLE_ANNOTATIONS: typing.ClassVar[str] = ...
    NAME_RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS: typing.ClassVar[str] = ...
    NAME_RUNTIME_INVISIBLE_TYPE_ANNOTATIONS: typing.ClassVar[str] = ...
    NAME_RUNTIME_VISIBLE_ANNOTATIONS: typing.ClassVar[str] = ...
    NAME_RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS: typing.ClassVar[str] = ...
    NAME_RUNTIME_VISIBLE_TYPE_ANNOTATIONS: typing.ClassVar[str] = ...
    NAME_SIGNATURE: typing.ClassVar[str] = ...
    NAME_SOURCE_DEBUG_EXTENSION: typing.ClassVar[str] = ...
    NAME_SOURCE_FILE: typing.ClassVar[str] = ...
    NAME_SOURCE_ID: typing.ClassVar[str] = ...
    NAME_STACK_MAP_TABLE: typing.ClassVar[str] = ...
    NAME_SYNTHETIC: typing.ClassVar[str] = ...
    @staticmethod
    def annotationDefault() -> AttributeMapper[java.lang.classfile.attribute.AnnotationDefaultAttribute]: ...
    @staticmethod
    def bootstrapMethods() -> AttributeMapper[java.lang.classfile.attribute.BootstrapMethodsAttribute]: ...
    @staticmethod
    def characterRangeTable() -> AttributeMapper[java.lang.classfile.attribute.CharacterRangeTableAttribute]: ...
    @staticmethod
    def code() -> AttributeMapper[java.lang.classfile.attribute.CodeAttribute]: ...
    @staticmethod
    def compilationId() -> AttributeMapper[java.lang.classfile.attribute.CompilationIDAttribute]: ...
    @staticmethod
    def constantValue() -> AttributeMapper[java.lang.classfile.attribute.ConstantValueAttribute]: ...
    @staticmethod
    def deprecated() -> AttributeMapper[java.lang.classfile.attribute.DeprecatedAttribute]: ...
    @staticmethod
    def enclosingMethod() -> AttributeMapper[java.lang.classfile.attribute.EnclosingMethodAttribute]: ...
    @staticmethod
    def exceptions() -> AttributeMapper[java.lang.classfile.attribute.ExceptionsAttribute]: ...
    @staticmethod
    def innerClasses() -> AttributeMapper[java.lang.classfile.attribute.InnerClassesAttribute]: ...
    @staticmethod
    def lineNumberTable() -> AttributeMapper[java.lang.classfile.attribute.LineNumberTableAttribute]: ...
    @staticmethod
    def localVariableTable() -> AttributeMapper[java.lang.classfile.attribute.LocalVariableTableAttribute]: ...
    @staticmethod
    def localVariableTypeTable() -> AttributeMapper[java.lang.classfile.attribute.LocalVariableTypeTableAttribute]: ...
    @staticmethod
    def methodParameters() -> AttributeMapper[java.lang.classfile.attribute.MethodParametersAttribute]: ...
    @staticmethod
    def module() -> AttributeMapper[java.lang.classfile.attribute.ModuleAttribute]: ...
    @staticmethod
    def moduleHashes() -> AttributeMapper[java.lang.classfile.attribute.ModuleHashesAttribute]: ...
    @staticmethod
    def moduleMainClass() -> AttributeMapper[java.lang.classfile.attribute.ModuleMainClassAttribute]: ...
    @staticmethod
    def modulePackages() -> AttributeMapper[java.lang.classfile.attribute.ModulePackagesAttribute]: ...
    @staticmethod
    def moduleResolution() -> AttributeMapper[java.lang.classfile.attribute.ModuleResolutionAttribute]: ...
    @staticmethod
    def moduleTarget() -> AttributeMapper[java.lang.classfile.attribute.ModuleTargetAttribute]: ...
    @staticmethod
    def nestHost() -> AttributeMapper[java.lang.classfile.attribute.NestHostAttribute]: ...
    @staticmethod
    def nestMembers() -> AttributeMapper[java.lang.classfile.attribute.NestMembersAttribute]: ...
    @staticmethod
    def permittedSubclasses() -> AttributeMapper[java.lang.classfile.attribute.PermittedSubclassesAttribute]: ...
    @staticmethod
    def record() -> AttributeMapper[java.lang.classfile.attribute.RecordAttribute]: ...
    @staticmethod
    def runtimeInvisibleAnnotations() -> AttributeMapper[java.lang.classfile.attribute.RuntimeInvisibleAnnotationsAttribute]: ...
    @staticmethod
    def runtimeInvisibleParameterAnnotations() -> AttributeMapper[java.lang.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute]: ...
    @staticmethod
    def runtimeInvisibleTypeAnnotations() -> AttributeMapper[java.lang.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute]: ...
    @staticmethod
    def runtimeVisibleAnnotations() -> AttributeMapper[java.lang.classfile.attribute.RuntimeVisibleAnnotationsAttribute]: ...
    @staticmethod
    def runtimeVisibleParameterAnnotations() -> AttributeMapper[java.lang.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute]: ...
    @staticmethod
    def runtimeVisibleTypeAnnotations() -> AttributeMapper[java.lang.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute]: ...
    @staticmethod
    def signature() -> AttributeMapper[java.lang.classfile.attribute.SignatureAttribute]: ...
    @staticmethod
    def sourceDebugExtension() -> AttributeMapper[java.lang.classfile.attribute.SourceDebugExtensionAttribute]: ...
    @staticmethod
    def sourceFile() -> AttributeMapper[java.lang.classfile.attribute.SourceFileAttribute]: ...
    @staticmethod
    def sourceId() -> AttributeMapper[java.lang.classfile.attribute.SourceIDAttribute]: ...
    @staticmethod
    def stackMapTable() -> AttributeMapper[java.lang.classfile.attribute.StackMapTableAttribute]: ...
    @staticmethod
    def synthetic() -> AttributeMapper[java.lang.classfile.attribute.SyntheticAttribute]: ...

class BootstrapMethodEntry:
    def arguments(self) -> java.util.List[java.lang.classfile.constantpool.LoadableConstantEntry]: ...
    def bootstrapMethod(self) -> java.lang.classfile.constantpool.MethodHandleEntry: ...
    def bsmIndex(self) -> int: ...
    def constantPool(self) -> java.lang.classfile.constantpool.ConstantPool: ...

class BufWriter:
    def canWriteDirect(self, constantPool: java.lang.classfile.constantpool.ConstantPool) -> bool: ...
    def constantPool(self) -> java.lang.classfile.constantpool.ConstantPoolBuilder: ...
    def patchInt(self, int: int, int2: int, int3: int) -> None: ...
    def reserveSpace(self, int: int) -> None: ...
    def size(self) -> int: ...
    @typing.overload
    def writeBytes(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> None: ...
    @typing.overload
    def writeBytes(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes], int: int, int2: int) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeIndex(self, poolEntry: java.lang.classfile.constantpool.PoolEntry) -> None: ...
    def writeIndexOrZero(self, poolEntry: java.lang.classfile.constantpool.PoolEntry) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeIntBytes(self, int: int, long: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeU1(self, int: int) -> None: ...
    def writeU2(self, int: int) -> None: ...

_ClassFileBuilder__E = typing.TypeVar('_ClassFileBuilder__E', bound='ClassFileElement')  # <E>
_ClassFileBuilder__B = typing.TypeVar('_ClassFileBuilder__B', bound='ClassFileBuilder')  # <B>
class ClassFileBuilder(java.util.function.Consumer[_ClassFileBuilder__E], typing.Generic[_ClassFileBuilder__E, _ClassFileBuilder__B]):
    def accept(self, e: _ClassFileBuilder__E) -> None: ...
    def constantPool(self) -> java.lang.classfile.constantpool.ConstantPoolBuilder: ...
    def transform(self, compoundElement: 'CompoundElement'[_ClassFileBuilder__E], classFileTransform: 'ClassFileTransform'[typing.Any, _ClassFileBuilder__E, _ClassFileBuilder__B]) -> _ClassFileBuilder__B: ...
    def with_(self, e: _ClassFileBuilder__E) -> _ClassFileBuilder__B: ...

class ClassFileElement: ...

_ClassFileTransform__C = typing.TypeVar('_ClassFileTransform__C', bound='ClassFileTransform')  # <C>
_ClassFileTransform__E = typing.TypeVar('_ClassFileTransform__E', bound=ClassFileElement)  # <E>
_ClassFileTransform__B = typing.TypeVar('_ClassFileTransform__B', bound=ClassFileBuilder)  # <B>
class ClassFileTransform(typing.Generic[_ClassFileTransform__C, _ClassFileTransform__E, _ClassFileTransform__B]):
    def accept(self, b: _ClassFileTransform__B, e: _ClassFileTransform__E) -> None: ...
    def andThen(self, c: _ClassFileTransform__C) -> _ClassFileTransform__C: ...
    def atEnd(self, b: _ClassFileTransform__B) -> None: ...
    def atStart(self, b: _ClassFileTransform__B) -> None: ...

class ClassHierarchyResolver:
    @typing.overload
    def cached(self) -> 'ClassHierarchyResolver': ...
    @typing.overload
    def cached(self, supplier: typing.Union[java.util.function.Supplier[typing.Union[java.util.Map[java.lang.constant.ClassDesc, 'ClassHierarchyResolver.ClassHierarchyInfo'], typing.Mapping[java.lang.constant.ClassDesc, 'ClassHierarchyResolver.ClassHierarchyInfo']]], typing.Callable[[], typing.Union[java.util.Map[java.lang.constant.ClassDesc, 'ClassHierarchyResolver.ClassHierarchyInfo'], typing.Mapping[java.lang.constant.ClassDesc, 'ClassHierarchyResolver.ClassHierarchyInfo']]]]) -> 'ClassHierarchyResolver': ...
    @staticmethod
    def defaultResolver() -> 'ClassHierarchyResolver': ...
    def getClassInfo(self, classDesc: java.lang.constant.ClassDesc) -> 'ClassHierarchyResolver.ClassHierarchyInfo': ...
    @staticmethod
    def of(collection: typing.Union[java.util.Collection[java.lang.constant.ClassDesc], typing.Sequence[java.lang.constant.ClassDesc], typing.Set[java.lang.constant.ClassDesc]], map: typing.Union[java.util.Map[java.lang.constant.ClassDesc, java.lang.constant.ClassDesc], typing.Mapping[java.lang.constant.ClassDesc, java.lang.constant.ClassDesc]]) -> 'ClassHierarchyResolver': ...
    @typing.overload
    @staticmethod
    def ofClassLoading(classLoader: java.lang.ClassLoader) -> 'ClassHierarchyResolver': ...
    @typing.overload
    @staticmethod
    def ofClassLoading(lookup: java.lang.invoke.MethodHandles.Lookup) -> 'ClassHierarchyResolver': ...
    @typing.overload
    @staticmethod
    def ofResourceParsing(classLoader: java.lang.ClassLoader) -> 'ClassHierarchyResolver': ...
    @typing.overload
    @staticmethod
    def ofResourceParsing(function: typing.Union[java.util.function.Function[java.lang.constant.ClassDesc, java.io.InputStream], typing.Callable[[java.lang.constant.ClassDesc], java.io.InputStream]]) -> 'ClassHierarchyResolver': ...
    def orElse(self, classHierarchyResolver: typing.Union['ClassHierarchyResolver', typing.Callable]) -> 'ClassHierarchyResolver': ...
    class ClassHierarchyInfo:
        @staticmethod
        def ofClass(classDesc: java.lang.constant.ClassDesc) -> 'ClassHierarchyResolver.ClassHierarchyInfo': ...
        @staticmethod
        def ofInterface() -> 'ClassHierarchyResolver.ClassHierarchyInfo': ...

class ClassReader(java.lang.classfile.constantpool.ConstantPool):
    def classfileLength(self) -> int: ...
    def copyBytesTo(self, bufWriter: BufWriter, int: int, int2: int) -> None: ...
    def customAttributes(self) -> java.util.function.Function[java.lang.classfile.constantpool.Utf8Entry, AttributeMapper[typing.Any]]: ...
    def flags(self) -> int: ...
    def readBytes(self, int: int, int2: int) -> typing.MutableSequence[int]: ...
    def readDouble(self, int: int) -> float: ...
    _readEntry_1__T = typing.TypeVar('_readEntry_1__T', bound=java.lang.classfile.constantpool.PoolEntry)  # <T>
    @typing.overload
    def readEntry(self, int: int) -> java.lang.classfile.constantpool.PoolEntry: ...
    @typing.overload
    def readEntry(self, int: int, class_: typing.Type[_readEntry_1__T]) -> _readEntry_1__T: ...
    _readEntryOrNull_1__T = typing.TypeVar('_readEntryOrNull_1__T', bound=java.lang.classfile.constantpool.PoolEntry)  # <T>
    @typing.overload
    def readEntryOrNull(self, int: int) -> java.lang.classfile.constantpool.PoolEntry: ...
    @typing.overload
    def readEntryOrNull(self, int: int, class_: typing.Type[_readEntryOrNull_1__T]) -> _readEntryOrNull_1__T: ...
    def readFloat(self, int: int) -> float: ...
    def readInt(self, int: int) -> int: ...
    def readLong(self, int: int) -> int: ...
    def readS1(self, int: int) -> int: ...
    def readS2(self, int: int) -> int: ...
    def readU1(self, int: int) -> int: ...
    def readU2(self, int: int) -> int: ...
    def superclassEntry(self) -> java.util.Optional[java.lang.classfile.constantpool.ClassEntry]: ...
    def thisClassEntry(self) -> java.lang.classfile.constantpool.ClassEntry: ...

class ClassSignature:
    @typing.overload
    @staticmethod
    def of(classTypeSig: 'Signature.ClassTypeSig', *classTypeSig2: 'Signature.ClassTypeSig') -> 'ClassSignature': ...
    @typing.overload
    @staticmethod
    def of(list: java.util.List['Signature.TypeParam'], classTypeSig: 'Signature.ClassTypeSig', *classTypeSig2: 'Signature.ClassTypeSig') -> 'ClassSignature': ...
    @staticmethod
    def parseFrom(string: str) -> 'ClassSignature': ...
    def signatureString(self) -> str: ...
    def superclassSignature(self) -> 'Signature.ClassTypeSig': ...
    def superinterfaceSignatures(self) -> java.util.List['Signature.ClassTypeSig']: ...
    def typeParameters(self) -> java.util.List['Signature.TypeParam']: ...

class Label: ...

class MethodSignature:
    def arguments(self) -> java.util.List['Signature']: ...
    @typing.overload
    @staticmethod
    def of(signature: 'Signature', *signature2: 'Signature') -> 'MethodSignature': ...
    @typing.overload
    @staticmethod
    def of(methodTypeDesc: java.lang.constant.MethodTypeDesc) -> 'MethodSignature': ...
    @typing.overload
    @staticmethod
    def of(list: java.util.List['Signature.TypeParam'], list2: java.util.List['Signature.ThrowableSig'], signature: 'Signature', *signature2: 'Signature') -> 'MethodSignature': ...
    @staticmethod
    def parseFrom(string: str) -> 'MethodSignature': ...
    def result(self) -> 'Signature': ...
    def signatureString(self) -> str: ...
    def throwableSignatures(self) -> java.util.List['Signature.ThrowableSig']: ...
    def typeParameters(self) -> java.util.List['Signature.TypeParam']: ...

class Opcode(java.lang.Enum['Opcode']):
    NOP: typing.ClassVar['Opcode'] = ...
    ACONST_NULL: typing.ClassVar['Opcode'] = ...
    ICONST_M1: typing.ClassVar['Opcode'] = ...
    ICONST_0: typing.ClassVar['Opcode'] = ...
    ICONST_1: typing.ClassVar['Opcode'] = ...
    ICONST_2: typing.ClassVar['Opcode'] = ...
    ICONST_3: typing.ClassVar['Opcode'] = ...
    ICONST_4: typing.ClassVar['Opcode'] = ...
    ICONST_5: typing.ClassVar['Opcode'] = ...
    LCONST_0: typing.ClassVar['Opcode'] = ...
    LCONST_1: typing.ClassVar['Opcode'] = ...
    FCONST_0: typing.ClassVar['Opcode'] = ...
    FCONST_1: typing.ClassVar['Opcode'] = ...
    FCONST_2: typing.ClassVar['Opcode'] = ...
    DCONST_0: typing.ClassVar['Opcode'] = ...
    DCONST_1: typing.ClassVar['Opcode'] = ...
    BIPUSH: typing.ClassVar['Opcode'] = ...
    SIPUSH: typing.ClassVar['Opcode'] = ...
    LDC: typing.ClassVar['Opcode'] = ...
    LDC_W: typing.ClassVar['Opcode'] = ...
    LDC2_W: typing.ClassVar['Opcode'] = ...
    ILOAD: typing.ClassVar['Opcode'] = ...
    LLOAD: typing.ClassVar['Opcode'] = ...
    FLOAD: typing.ClassVar['Opcode'] = ...
    DLOAD: typing.ClassVar['Opcode'] = ...
    ALOAD: typing.ClassVar['Opcode'] = ...
    ILOAD_0: typing.ClassVar['Opcode'] = ...
    ILOAD_1: typing.ClassVar['Opcode'] = ...
    ILOAD_2: typing.ClassVar['Opcode'] = ...
    ILOAD_3: typing.ClassVar['Opcode'] = ...
    LLOAD_0: typing.ClassVar['Opcode'] = ...
    LLOAD_1: typing.ClassVar['Opcode'] = ...
    LLOAD_2: typing.ClassVar['Opcode'] = ...
    LLOAD_3: typing.ClassVar['Opcode'] = ...
    FLOAD_0: typing.ClassVar['Opcode'] = ...
    FLOAD_1: typing.ClassVar['Opcode'] = ...
    FLOAD_2: typing.ClassVar['Opcode'] = ...
    FLOAD_3: typing.ClassVar['Opcode'] = ...
    DLOAD_0: typing.ClassVar['Opcode'] = ...
    DLOAD_1: typing.ClassVar['Opcode'] = ...
    DLOAD_2: typing.ClassVar['Opcode'] = ...
    DLOAD_3: typing.ClassVar['Opcode'] = ...
    ALOAD_0: typing.ClassVar['Opcode'] = ...
    ALOAD_1: typing.ClassVar['Opcode'] = ...
    ALOAD_2: typing.ClassVar['Opcode'] = ...
    ALOAD_3: typing.ClassVar['Opcode'] = ...
    IALOAD: typing.ClassVar['Opcode'] = ...
    LALOAD: typing.ClassVar['Opcode'] = ...
    FALOAD: typing.ClassVar['Opcode'] = ...
    DALOAD: typing.ClassVar['Opcode'] = ...
    AALOAD: typing.ClassVar['Opcode'] = ...
    BALOAD: typing.ClassVar['Opcode'] = ...
    CALOAD: typing.ClassVar['Opcode'] = ...
    SALOAD: typing.ClassVar['Opcode'] = ...
    ISTORE: typing.ClassVar['Opcode'] = ...
    LSTORE: typing.ClassVar['Opcode'] = ...
    FSTORE: typing.ClassVar['Opcode'] = ...
    DSTORE: typing.ClassVar['Opcode'] = ...
    ASTORE: typing.ClassVar['Opcode'] = ...
    ISTORE_0: typing.ClassVar['Opcode'] = ...
    ISTORE_1: typing.ClassVar['Opcode'] = ...
    ISTORE_2: typing.ClassVar['Opcode'] = ...
    ISTORE_3: typing.ClassVar['Opcode'] = ...
    LSTORE_0: typing.ClassVar['Opcode'] = ...
    LSTORE_1: typing.ClassVar['Opcode'] = ...
    LSTORE_2: typing.ClassVar['Opcode'] = ...
    LSTORE_3: typing.ClassVar['Opcode'] = ...
    FSTORE_0: typing.ClassVar['Opcode'] = ...
    FSTORE_1: typing.ClassVar['Opcode'] = ...
    FSTORE_2: typing.ClassVar['Opcode'] = ...
    FSTORE_3: typing.ClassVar['Opcode'] = ...
    DSTORE_0: typing.ClassVar['Opcode'] = ...
    DSTORE_1: typing.ClassVar['Opcode'] = ...
    DSTORE_2: typing.ClassVar['Opcode'] = ...
    DSTORE_3: typing.ClassVar['Opcode'] = ...
    ASTORE_0: typing.ClassVar['Opcode'] = ...
    ASTORE_1: typing.ClassVar['Opcode'] = ...
    ASTORE_2: typing.ClassVar['Opcode'] = ...
    ASTORE_3: typing.ClassVar['Opcode'] = ...
    IASTORE: typing.ClassVar['Opcode'] = ...
    LASTORE: typing.ClassVar['Opcode'] = ...
    FASTORE: typing.ClassVar['Opcode'] = ...
    DASTORE: typing.ClassVar['Opcode'] = ...
    AASTORE: typing.ClassVar['Opcode'] = ...
    BASTORE: typing.ClassVar['Opcode'] = ...
    CASTORE: typing.ClassVar['Opcode'] = ...
    SASTORE: typing.ClassVar['Opcode'] = ...
    POP: typing.ClassVar['Opcode'] = ...
    POP2: typing.ClassVar['Opcode'] = ...
    DUP: typing.ClassVar['Opcode'] = ...
    DUP_X1: typing.ClassVar['Opcode'] = ...
    DUP_X2: typing.ClassVar['Opcode'] = ...
    DUP2: typing.ClassVar['Opcode'] = ...
    DUP2_X1: typing.ClassVar['Opcode'] = ...
    DUP2_X2: typing.ClassVar['Opcode'] = ...
    SWAP: typing.ClassVar['Opcode'] = ...
    IADD: typing.ClassVar['Opcode'] = ...
    LADD: typing.ClassVar['Opcode'] = ...
    FADD: typing.ClassVar['Opcode'] = ...
    DADD: typing.ClassVar['Opcode'] = ...
    ISUB: typing.ClassVar['Opcode'] = ...
    LSUB: typing.ClassVar['Opcode'] = ...
    FSUB: typing.ClassVar['Opcode'] = ...
    DSUB: typing.ClassVar['Opcode'] = ...
    IMUL: typing.ClassVar['Opcode'] = ...
    LMUL: typing.ClassVar['Opcode'] = ...
    FMUL: typing.ClassVar['Opcode'] = ...
    DMUL: typing.ClassVar['Opcode'] = ...
    IDIV: typing.ClassVar['Opcode'] = ...
    LDIV: typing.ClassVar['Opcode'] = ...
    FDIV: typing.ClassVar['Opcode'] = ...
    DDIV: typing.ClassVar['Opcode'] = ...
    IREM: typing.ClassVar['Opcode'] = ...
    LREM: typing.ClassVar['Opcode'] = ...
    FREM: typing.ClassVar['Opcode'] = ...
    DREM: typing.ClassVar['Opcode'] = ...
    INEG: typing.ClassVar['Opcode'] = ...
    LNEG: typing.ClassVar['Opcode'] = ...
    FNEG: typing.ClassVar['Opcode'] = ...
    DNEG: typing.ClassVar['Opcode'] = ...
    ISHL: typing.ClassVar['Opcode'] = ...
    LSHL: typing.ClassVar['Opcode'] = ...
    ISHR: typing.ClassVar['Opcode'] = ...
    LSHR: typing.ClassVar['Opcode'] = ...
    IUSHR: typing.ClassVar['Opcode'] = ...
    LUSHR: typing.ClassVar['Opcode'] = ...
    IAND: typing.ClassVar['Opcode'] = ...
    LAND: typing.ClassVar['Opcode'] = ...
    IOR: typing.ClassVar['Opcode'] = ...
    LOR: typing.ClassVar['Opcode'] = ...
    IXOR: typing.ClassVar['Opcode'] = ...
    LXOR: typing.ClassVar['Opcode'] = ...
    IINC: typing.ClassVar['Opcode'] = ...
    I2L: typing.ClassVar['Opcode'] = ...
    I2F: typing.ClassVar['Opcode'] = ...
    I2D: typing.ClassVar['Opcode'] = ...
    L2I: typing.ClassVar['Opcode'] = ...
    L2F: typing.ClassVar['Opcode'] = ...
    L2D: typing.ClassVar['Opcode'] = ...
    F2I: typing.ClassVar['Opcode'] = ...
    F2L: typing.ClassVar['Opcode'] = ...
    F2D: typing.ClassVar['Opcode'] = ...
    D2I: typing.ClassVar['Opcode'] = ...
    D2L: typing.ClassVar['Opcode'] = ...
    D2F: typing.ClassVar['Opcode'] = ...
    I2B: typing.ClassVar['Opcode'] = ...
    I2C: typing.ClassVar['Opcode'] = ...
    I2S: typing.ClassVar['Opcode'] = ...
    LCMP: typing.ClassVar['Opcode'] = ...
    FCMPL: typing.ClassVar['Opcode'] = ...
    FCMPG: typing.ClassVar['Opcode'] = ...
    DCMPL: typing.ClassVar['Opcode'] = ...
    DCMPG: typing.ClassVar['Opcode'] = ...
    IFEQ: typing.ClassVar['Opcode'] = ...
    IFNE: typing.ClassVar['Opcode'] = ...
    IFLT: typing.ClassVar['Opcode'] = ...
    IFGE: typing.ClassVar['Opcode'] = ...
    IFGT: typing.ClassVar['Opcode'] = ...
    IFLE: typing.ClassVar['Opcode'] = ...
    IF_ICMPEQ: typing.ClassVar['Opcode'] = ...
    IF_ICMPNE: typing.ClassVar['Opcode'] = ...
    IF_ICMPLT: typing.ClassVar['Opcode'] = ...
    IF_ICMPGE: typing.ClassVar['Opcode'] = ...
    IF_ICMPGT: typing.ClassVar['Opcode'] = ...
    IF_ICMPLE: typing.ClassVar['Opcode'] = ...
    IF_ACMPEQ: typing.ClassVar['Opcode'] = ...
    IF_ACMPNE: typing.ClassVar['Opcode'] = ...
    GOTO: typing.ClassVar['Opcode'] = ...
    JSR: typing.ClassVar['Opcode'] = ...
    RET: typing.ClassVar['Opcode'] = ...
    TABLESWITCH: typing.ClassVar['Opcode'] = ...
    LOOKUPSWITCH: typing.ClassVar['Opcode'] = ...
    IRETURN: typing.ClassVar['Opcode'] = ...
    LRETURN: typing.ClassVar['Opcode'] = ...
    FRETURN: typing.ClassVar['Opcode'] = ...
    DRETURN: typing.ClassVar['Opcode'] = ...
    ARETURN: typing.ClassVar['Opcode'] = ...
    RETURN: typing.ClassVar['Opcode'] = ...
    GETSTATIC: typing.ClassVar['Opcode'] = ...
    PUTSTATIC: typing.ClassVar['Opcode'] = ...
    GETFIELD: typing.ClassVar['Opcode'] = ...
    PUTFIELD: typing.ClassVar['Opcode'] = ...
    INVOKEVIRTUAL: typing.ClassVar['Opcode'] = ...
    INVOKESPECIAL: typing.ClassVar['Opcode'] = ...
    INVOKESTATIC: typing.ClassVar['Opcode'] = ...
    INVOKEINTERFACE: typing.ClassVar['Opcode'] = ...
    INVOKEDYNAMIC: typing.ClassVar['Opcode'] = ...
    NEW: typing.ClassVar['Opcode'] = ...
    NEWARRAY: typing.ClassVar['Opcode'] = ...
    ANEWARRAY: typing.ClassVar['Opcode'] = ...
    ARRAYLENGTH: typing.ClassVar['Opcode'] = ...
    ATHROW: typing.ClassVar['Opcode'] = ...
    CHECKCAST: typing.ClassVar['Opcode'] = ...
    INSTANCEOF: typing.ClassVar['Opcode'] = ...
    MONITORENTER: typing.ClassVar['Opcode'] = ...
    MONITOREXIT: typing.ClassVar['Opcode'] = ...
    MULTIANEWARRAY: typing.ClassVar['Opcode'] = ...
    IFNULL: typing.ClassVar['Opcode'] = ...
    IFNONNULL: typing.ClassVar['Opcode'] = ...
    GOTO_W: typing.ClassVar['Opcode'] = ...
    JSR_W: typing.ClassVar['Opcode'] = ...
    ILOAD_W: typing.ClassVar['Opcode'] = ...
    LLOAD_W: typing.ClassVar['Opcode'] = ...
    FLOAD_W: typing.ClassVar['Opcode'] = ...
    DLOAD_W: typing.ClassVar['Opcode'] = ...
    ALOAD_W: typing.ClassVar['Opcode'] = ...
    ISTORE_W: typing.ClassVar['Opcode'] = ...
    LSTORE_W: typing.ClassVar['Opcode'] = ...
    FSTORE_W: typing.ClassVar['Opcode'] = ...
    DSTORE_W: typing.ClassVar['Opcode'] = ...
    ASTORE_W: typing.ClassVar['Opcode'] = ...
    RET_W: typing.ClassVar['Opcode'] = ...
    IINC_W: typing.ClassVar['Opcode'] = ...
    def bytecode(self) -> int: ...
    def isWide(self) -> bool: ...
    def kind(self) -> 'Opcode.Kind': ...
    def sizeIfFixed(self) -> int: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'Opcode': ...
    @staticmethod
    def values() -> typing.MutableSequence['Opcode']: ...
    class Kind(java.lang.Enum['Opcode.Kind']):
        LOAD: typing.ClassVar['Opcode.Kind'] = ...
        STORE: typing.ClassVar['Opcode.Kind'] = ...
        INCREMENT: typing.ClassVar['Opcode.Kind'] = ...
        BRANCH: typing.ClassVar['Opcode.Kind'] = ...
        LOOKUP_SWITCH: typing.ClassVar['Opcode.Kind'] = ...
        TABLE_SWITCH: typing.ClassVar['Opcode.Kind'] = ...
        RETURN: typing.ClassVar['Opcode.Kind'] = ...
        THROW_EXCEPTION: typing.ClassVar['Opcode.Kind'] = ...
        FIELD_ACCESS: typing.ClassVar['Opcode.Kind'] = ...
        INVOKE: typing.ClassVar['Opcode.Kind'] = ...
        INVOKE_DYNAMIC: typing.ClassVar['Opcode.Kind'] = ...
        NEW_OBJECT: typing.ClassVar['Opcode.Kind'] = ...
        NEW_PRIMITIVE_ARRAY: typing.ClassVar['Opcode.Kind'] = ...
        NEW_REF_ARRAY: typing.ClassVar['Opcode.Kind'] = ...
        NEW_MULTI_ARRAY: typing.ClassVar['Opcode.Kind'] = ...
        TYPE_CHECK: typing.ClassVar['Opcode.Kind'] = ...
        ARRAY_LOAD: typing.ClassVar['Opcode.Kind'] = ...
        ARRAY_STORE: typing.ClassVar['Opcode.Kind'] = ...
        STACK: typing.ClassVar['Opcode.Kind'] = ...
        CONVERT: typing.ClassVar['Opcode.Kind'] = ...
        OPERATOR: typing.ClassVar['Opcode.Kind'] = ...
        CONSTANT: typing.ClassVar['Opcode.Kind'] = ...
        MONITOR: typing.ClassVar['Opcode.Kind'] = ...
        NOP: typing.ClassVar['Opcode.Kind'] = ...
        DISCONTINUED_JSR: typing.ClassVar['Opcode.Kind'] = ...
        DISCONTINUED_RET: typing.ClassVar['Opcode.Kind'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'Opcode.Kind': ...
        @staticmethod
        def values() -> typing.MutableSequence['Opcode.Kind']: ...

class TypeKind(java.lang.Enum['TypeKind']):
    BOOLEAN: typing.ClassVar['TypeKind'] = ...
    BYTE: typing.ClassVar['TypeKind'] = ...
    CHAR: typing.ClassVar['TypeKind'] = ...
    SHORT: typing.ClassVar['TypeKind'] = ...
    INT: typing.ClassVar['TypeKind'] = ...
    LONG: typing.ClassVar['TypeKind'] = ...
    FLOAT: typing.ClassVar['TypeKind'] = ...
    DOUBLE: typing.ClassVar['TypeKind'] = ...
    REFERENCE: typing.ClassVar['TypeKind'] = ...
    VOID: typing.ClassVar['TypeKind'] = ...
    def asLoadable(self) -> 'TypeKind': ...
    @staticmethod
    def fromDescriptor(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'TypeKind': ...
    @staticmethod
    def fromNewarrayCode(int: int) -> 'TypeKind': ...
    @staticmethod
    def from_(ofField: java.lang.invoke.TypeDescriptor.OfField[typing.Any]) -> 'TypeKind': ...
    def newarrayCode(self) -> int: ...
    def slotSize(self) -> int: ...
    def upperBound(self) -> java.lang.constant.ClassDesc: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'TypeKind': ...
    @staticmethod
    def values() -> typing.MutableSequence['TypeKind']: ...

_Attribute__A = typing.TypeVar('_Attribute__A', bound='Attribute')  # <A>
class Attribute(ClassFileElement, typing.Generic[_Attribute__A]):
    def attributeMapper(self) -> AttributeMapper[_Attribute__A]: ...
    def attributeName(self) -> java.lang.classfile.constantpool.Utf8Entry: ...

class AttributedElement(ClassFileElement):
    def attributes(self) -> java.util.List[Attribute[typing.Any]]: ...
    _findAttribute__T = typing.TypeVar('_findAttribute__T', bound=Attribute)  # <T>
    def findAttribute(self, attributeMapper: AttributeMapper[_findAttribute__T]) -> java.util.Optional[_findAttribute__T]: ...
    _findAttributes__T = typing.TypeVar('_findAttributes__T', bound=Attribute)  # <T>
    def findAttributes(self, attributeMapper: AttributeMapper[_findAttributes__T]) -> java.util.List[_findAttributes__T]: ...

class ClassBuilder(ClassFileBuilder['ClassElement', 'ClassBuilder']):
    def transformField(self, fieldModel: 'FieldModel', fieldTransform: typing.Union['FieldTransform', typing.Callable]) -> 'ClassBuilder': ...
    def transformMethod(self, methodModel: 'MethodModel', methodTransform: typing.Union['MethodTransform', typing.Callable]) -> 'ClassBuilder': ...
    @typing.overload
    def withField(self, utf8Entry: java.lang.classfile.constantpool.Utf8Entry, utf8Entry2: java.lang.classfile.constantpool.Utf8Entry, consumer: typing.Union[java.util.function.Consumer['FieldBuilder'], typing.Callable[['FieldBuilder'], None]]) -> 'ClassBuilder': ...
    @typing.overload
    def withField(self, string: str, classDesc: java.lang.constant.ClassDesc, int: int) -> 'ClassBuilder': ...
    @typing.overload
    def withField(self, string: str, classDesc: java.lang.constant.ClassDesc, consumer: typing.Union[java.util.function.Consumer['FieldBuilder'], typing.Callable[['FieldBuilder'], None]]) -> 'ClassBuilder': ...
    @typing.overload
    def withField(self, utf8Entry: java.lang.classfile.constantpool.Utf8Entry, utf8Entry2: java.lang.classfile.constantpool.Utf8Entry, int: int) -> 'ClassBuilder': ...
    @typing.overload
    def withFlags(self, int: int) -> 'ClassBuilder': ...
    @typing.overload
    def withFlags(self, *accessFlag: java.lang.reflect.AccessFlag) -> 'ClassBuilder': ...
    @typing.overload
    def withInterfaceSymbols(self, *classDesc: java.lang.constant.ClassDesc) -> 'ClassBuilder': ...
    @typing.overload
    def withInterfaceSymbols(self, list: java.util.List[java.lang.constant.ClassDesc]) -> 'ClassBuilder': ...
    @typing.overload
    def withInterfaces(self, *classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'ClassBuilder': ...
    @typing.overload
    def withInterfaces(self, list: java.util.List[java.lang.classfile.constantpool.ClassEntry]) -> 'ClassBuilder': ...
    @typing.overload
    def withMethod(self, utf8Entry: java.lang.classfile.constantpool.Utf8Entry, utf8Entry2: java.lang.classfile.constantpool.Utf8Entry, int: int, consumer: typing.Union[java.util.function.Consumer['MethodBuilder'], typing.Callable[['MethodBuilder'], None]]) -> 'ClassBuilder': ...
    @typing.overload
    def withMethod(self, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc, int: int, consumer: typing.Union[java.util.function.Consumer['MethodBuilder'], typing.Callable[['MethodBuilder'], None]]) -> 'ClassBuilder': ...
    @typing.overload
    def withMethodBody(self, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc, int: int, consumer: typing.Union[java.util.function.Consumer['CodeBuilder'], typing.Callable[['CodeBuilder'], None]]) -> 'ClassBuilder': ...
    @typing.overload
    def withMethodBody(self, utf8Entry: java.lang.classfile.constantpool.Utf8Entry, utf8Entry2: java.lang.classfile.constantpool.Utf8Entry, int: int, consumer: typing.Union[java.util.function.Consumer['CodeBuilder'], typing.Callable[['CodeBuilder'], None]]) -> 'ClassBuilder': ...
    @typing.overload
    def withSuperclass(self, classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'ClassBuilder': ...
    @typing.overload
    def withSuperclass(self, classDesc: java.lang.constant.ClassDesc) -> 'ClassBuilder': ...
    def withVersion(self, int: int, int2: int) -> 'ClassBuilder': ...

class ClassElement(ClassFileElement): ...

class ClassTransform(ClassFileTransform['ClassTransform', ClassElement, ClassBuilder]):
    ACCEPT_ALL: typing.ClassVar['ClassTransform'] = ...
    def andThen(self, classTransform: typing.Union['ClassTransform', typing.Callable]) -> 'ClassTransform': ...
    @staticmethod
    def dropping(predicate: typing.Union[java.util.function.Predicate[ClassElement], typing.Callable[[ClassElement], bool]]) -> 'ClassTransform': ...
    @staticmethod
    def endHandler(consumer: typing.Union[java.util.function.Consumer[ClassBuilder], typing.Callable[[ClassBuilder], None]]) -> 'ClassTransform': ...
    @staticmethod
    def ofStateful(supplier: typing.Union[java.util.function.Supplier[typing.Union['ClassTransform', typing.Callable]], typing.Callable[[], typing.Union['ClassTransform', typing.Callable]]]) -> 'ClassTransform': ...
    @staticmethod
    def transformingFields(fieldTransform: typing.Union['FieldTransform', typing.Callable]) -> 'ClassTransform': ...
    @typing.overload
    @staticmethod
    def transformingMethodBodies(codeTransform: typing.Union['CodeTransform', typing.Callable]) -> 'ClassTransform': ...
    @typing.overload
    @staticmethod
    def transformingMethodBodies(predicate: typing.Union[java.util.function.Predicate['MethodModel'], typing.Callable[['MethodModel'], bool]], codeTransform: typing.Union['CodeTransform', typing.Callable]) -> 'ClassTransform': ...
    @typing.overload
    @staticmethod
    def transformingMethods(methodTransform: typing.Union['MethodTransform', typing.Callable]) -> 'ClassTransform': ...
    @typing.overload
    @staticmethod
    def transformingMethods(predicate: typing.Union[java.util.function.Predicate['MethodModel'], typing.Callable[['MethodModel'], bool]], methodTransform: typing.Union['MethodTransform', typing.Callable]) -> 'ClassTransform': ...

class CodeElement(ClassFileElement): ...

class CodeTransform(ClassFileTransform['CodeTransform', CodeElement, 'CodeBuilder']):
    ACCEPT_ALL: typing.ClassVar['CodeTransform'] = ...
    def andThen(self, codeTransform: typing.Union['CodeTransform', typing.Callable]) -> 'CodeTransform': ...
    @staticmethod
    def endHandler(consumer: typing.Union[java.util.function.Consumer['CodeBuilder'], typing.Callable[['CodeBuilder'], None]]) -> 'CodeTransform': ...
    @staticmethod
    def ofStateful(supplier: typing.Union[java.util.function.Supplier[typing.Union['CodeTransform', typing.Callable]], typing.Callable[[], typing.Union['CodeTransform', typing.Callable]]]) -> 'CodeTransform': ...

_CompoundElement__E = typing.TypeVar('_CompoundElement__E', bound=ClassFileElement)  # <E>
class CompoundElement(ClassFileElement, java.lang.Iterable[_CompoundElement__E], typing.Generic[_CompoundElement__E]):
    def elementList(self) -> java.util.List[_CompoundElement__E]: ...
    def elementStream(self) -> java.util.stream.Stream[_CompoundElement__E]: ...
    def forEach(self, consumer: typing.Union[java.util.function.Consumer[_CompoundElement__E], typing.Callable[[_CompoundElement__E], None]]) -> None: ...
    def iterator(self) -> java.util.Iterator[_CompoundElement__E]: ...
    def toDebugString(self) -> str: ...

class FieldBuilder(ClassFileBuilder['FieldElement', 'FieldBuilder']):
    @typing.overload
    def withFlags(self, int: int) -> 'FieldBuilder': ...
    @typing.overload
    def withFlags(self, *accessFlag: java.lang.reflect.AccessFlag) -> 'FieldBuilder': ...

class FieldElement(ClassFileElement): ...

class FieldTransform(ClassFileTransform['FieldTransform', FieldElement, FieldBuilder]):
    ACCEPT_ALL: typing.ClassVar['FieldTransform'] = ...
    def andThen(self, fieldTransform: typing.Union['FieldTransform', typing.Callable]) -> 'FieldTransform': ...
    @staticmethod
    def dropping(predicate: typing.Union[java.util.function.Predicate[FieldElement], typing.Callable[[FieldElement], bool]]) -> 'FieldTransform': ...
    @staticmethod
    def endHandler(consumer: typing.Union[java.util.function.Consumer[FieldBuilder], typing.Callable[[FieldBuilder], None]]) -> 'FieldTransform': ...
    @staticmethod
    def ofStateful(supplier: typing.Union[java.util.function.Supplier[typing.Union['FieldTransform', typing.Callable]], typing.Callable[[], typing.Union['FieldTransform', typing.Callable]]]) -> 'FieldTransform': ...

class MethodBuilder(ClassFileBuilder['MethodElement', 'MethodBuilder']):
    def transformCode(self, codeModel: 'CodeModel', codeTransform: typing.Union[CodeTransform, typing.Callable]) -> 'MethodBuilder': ...
    def withCode(self, consumer: typing.Union[java.util.function.Consumer['CodeBuilder'], typing.Callable[['CodeBuilder'], None]]) -> 'MethodBuilder': ...
    @typing.overload
    def withFlags(self, int: int) -> 'MethodBuilder': ...
    @typing.overload
    def withFlags(self, *accessFlag: java.lang.reflect.AccessFlag) -> 'MethodBuilder': ...

class MethodElement(ClassFileElement): ...

class MethodTransform(ClassFileTransform['MethodTransform', MethodElement, MethodBuilder]):
    ACCEPT_ALL: typing.ClassVar['MethodTransform'] = ...
    def andThen(self, methodTransform: typing.Union['MethodTransform', typing.Callable]) -> 'MethodTransform': ...
    @staticmethod
    def dropping(predicate: typing.Union[java.util.function.Predicate[MethodElement], typing.Callable[[MethodElement], bool]]) -> 'MethodTransform': ...
    @staticmethod
    def endHandler(consumer: typing.Union[java.util.function.Consumer[MethodBuilder], typing.Callable[[MethodBuilder], None]]) -> 'MethodTransform': ...
    @staticmethod
    def ofStateful(supplier: typing.Union[java.util.function.Supplier[typing.Union['MethodTransform', typing.Callable]], typing.Callable[[], typing.Union['MethodTransform', typing.Callable]]]) -> 'MethodTransform': ...
    @staticmethod
    def transformingCode(codeTransform: typing.Union[CodeTransform, typing.Callable]) -> 'MethodTransform': ...

class AccessFlags(ClassElement, MethodElement, FieldElement):
    def flags(self) -> java.util.Set[java.lang.reflect.AccessFlag]: ...
    def flagsMask(self) -> int: ...
    def has(self, accessFlag: java.lang.reflect.AccessFlag) -> bool: ...
    def location(self) -> java.lang.reflect.AccessFlag.Location: ...

class ClassFileVersion(ClassElement):
    def majorVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    @staticmethod
    def of(int: int, int2: int) -> 'ClassFileVersion': ...

class ClassModel(CompoundElement[ClassElement], AttributedElement):
    def constantPool(self) -> java.lang.classfile.constantpool.ConstantPool: ...
    def fields(self) -> java.util.List['FieldModel']: ...
    def flags(self) -> AccessFlags: ...
    def interfaces(self) -> java.util.List[java.lang.classfile.constantpool.ClassEntry]: ...
    def isModuleInfo(self) -> bool: ...
    def majorVersion(self) -> int: ...
    def methods(self) -> java.util.List['MethodModel']: ...
    def minorVersion(self) -> int: ...
    def superclass(self) -> java.util.Optional[java.lang.classfile.constantpool.ClassEntry]: ...
    def thisClass(self) -> java.lang.classfile.constantpool.ClassEntry: ...

class CodeModel(CompoundElement[CodeElement], AttributedElement, MethodElement):
    def exceptionHandlers(self) -> java.util.List[java.lang.classfile.instruction.ExceptionCatch]: ...
    def parent(self) -> java.util.Optional['MethodModel']: ...

_CustomAttribute__T = typing.TypeVar('_CustomAttribute__T', bound='CustomAttribute')  # <T>
class CustomAttribute(Attribute[_CustomAttribute__T], CodeElement, ClassElement, MethodElement, FieldElement, typing.Generic[_CustomAttribute__T]):
    def attributeMapper(self) -> AttributeMapper[_CustomAttribute__T]: ...
    def attributeName(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    def toString(self) -> str: ...

class FieldModel(CompoundElement[FieldElement], AttributedElement, ClassElement):
    def fieldName(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    def fieldType(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    def fieldTypeSymbol(self) -> java.lang.constant.ClassDesc: ...
    def flags(self) -> AccessFlags: ...
    def parent(self) -> java.util.Optional[ClassModel]: ...

class Instruction(CodeElement):
    def opcode(self) -> Opcode: ...
    def sizeInBytes(self) -> int: ...

class Interfaces(ClassElement):
    def interfaces(self) -> java.util.List[java.lang.classfile.constantpool.ClassEntry]: ...
    @typing.overload
    @staticmethod
    def of(*classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'Interfaces': ...
    @typing.overload
    @staticmethod
    def of(list: java.util.List[java.lang.classfile.constantpool.ClassEntry]) -> 'Interfaces': ...
    @typing.overload
    @staticmethod
    def ofSymbols(*classDesc: java.lang.constant.ClassDesc) -> 'Interfaces': ...
    @typing.overload
    @staticmethod
    def ofSymbols(list: java.util.List[java.lang.constant.ClassDesc]) -> 'Interfaces': ...

class MethodModel(CompoundElement[MethodElement], AttributedElement, ClassElement):
    def code(self) -> java.util.Optional[CodeModel]: ...
    def flags(self) -> AccessFlags: ...
    def methodName(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    def methodType(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    def methodTypeSymbol(self) -> java.lang.constant.MethodTypeDesc: ...
    def parent(self) -> java.util.Optional[ClassModel]: ...

class PseudoInstruction(CodeElement): ...

class Superclass(ClassElement):
    @staticmethod
    def of(classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'Superclass': ...
    def superclassEntry(self) -> java.lang.classfile.constantpool.ClassEntry: ...

class AnnotationValue:
    TAG_BYTE: typing.ClassVar[int] = ...
    TAG_CHAR: typing.ClassVar[int] = ...
    TAG_DOUBLE: typing.ClassVar[int] = ...
    TAG_FLOAT: typing.ClassVar[int] = ...
    TAG_INT: typing.ClassVar[int] = ...
    TAG_LONG: typing.ClassVar[int] = ...
    TAG_SHORT: typing.ClassVar[int] = ...
    TAG_BOOLEAN: typing.ClassVar[int] = ...
    TAG_STRING: typing.ClassVar[int] = ...
    TAG_ENUM: typing.ClassVar[int] = ...
    TAG_CLASS: typing.ClassVar[int] = ...
    TAG_ANNOTATION: typing.ClassVar[int] = ...
    TAG_ARRAY: typing.ClassVar[int] = ...
    @staticmethod
    def of(object: typing.Any) -> 'AnnotationValue': ...
    @staticmethod
    def ofAnnotation(annotation: Annotation) -> 'AnnotationValue.OfAnnotation': ...
    @typing.overload
    @staticmethod
    def ofArray(*annotationValue: 'AnnotationValue') -> 'AnnotationValue.OfArray': ...
    @typing.overload
    @staticmethod
    def ofArray(list: java.util.List['AnnotationValue']) -> 'AnnotationValue.OfArray': ...
    @typing.overload
    @staticmethod
    def ofBoolean(boolean: bool) -> 'AnnotationValue.OfBoolean': ...
    @typing.overload
    @staticmethod
    def ofBoolean(integerEntry: java.lang.classfile.constantpool.IntegerEntry) -> 'AnnotationValue.OfBoolean': ...
    @typing.overload
    @staticmethod
    def ofByte(byte: int) -> 'AnnotationValue.OfByte': ...
    @typing.overload
    @staticmethod
    def ofByte(integerEntry: java.lang.classfile.constantpool.IntegerEntry) -> 'AnnotationValue.OfByte': ...
    @typing.overload
    @staticmethod
    def ofChar(char: str) -> 'AnnotationValue.OfChar': ...
    @typing.overload
    @staticmethod
    def ofChar(integerEntry: java.lang.classfile.constantpool.IntegerEntry) -> 'AnnotationValue.OfChar': ...
    @typing.overload
    @staticmethod
    def ofClass(utf8Entry: java.lang.classfile.constantpool.Utf8Entry) -> 'AnnotationValue.OfClass': ...
    @typing.overload
    @staticmethod
    def ofClass(classDesc: java.lang.constant.ClassDesc) -> 'AnnotationValue.OfClass': ...
    @typing.overload
    @staticmethod
    def ofDouble(double: float) -> 'AnnotationValue.OfDouble': ...
    @typing.overload
    @staticmethod
    def ofDouble(doubleEntry: java.lang.classfile.constantpool.DoubleEntry) -> 'AnnotationValue.OfDouble': ...
    @typing.overload
    @staticmethod
    def ofEnum(utf8Entry: java.lang.classfile.constantpool.Utf8Entry, utf8Entry2: java.lang.classfile.constantpool.Utf8Entry) -> 'AnnotationValue.OfEnum': ...
    @typing.overload
    @staticmethod
    def ofEnum(classDesc: java.lang.constant.ClassDesc, string: str) -> 'AnnotationValue.OfEnum': ...
    @typing.overload
    @staticmethod
    def ofFloat(float: float) -> 'AnnotationValue.OfFloat': ...
    @typing.overload
    @staticmethod
    def ofFloat(floatEntry: java.lang.classfile.constantpool.FloatEntry) -> 'AnnotationValue.OfFloat': ...
    @typing.overload
    @staticmethod
    def ofInt(int: int) -> 'AnnotationValue.OfInt': ...
    @typing.overload
    @staticmethod
    def ofInt(integerEntry: java.lang.classfile.constantpool.IntegerEntry) -> 'AnnotationValue.OfInt': ...
    @typing.overload
    @staticmethod
    def ofLong(longEntry: java.lang.classfile.constantpool.LongEntry) -> 'AnnotationValue.OfLong': ...
    @typing.overload
    @staticmethod
    def ofLong(long: int) -> 'AnnotationValue.OfLong': ...
    @typing.overload
    @staticmethod
    def ofShort(integerEntry: java.lang.classfile.constantpool.IntegerEntry) -> 'AnnotationValue.OfShort': ...
    @typing.overload
    @staticmethod
    def ofShort(short: int) -> 'AnnotationValue.OfShort': ...
    @typing.overload
    @staticmethod
    def ofString(string: str) -> 'AnnotationValue.OfString': ...
    @typing.overload
    @staticmethod
    def ofString(utf8Entry: java.lang.classfile.constantpool.Utf8Entry) -> 'AnnotationValue.OfString': ...
    def tag(self) -> int: ...
    class OfAnnotation(java.lang.classfile.AnnotationValue):
        def annotation(self) -> Annotation: ...
    class OfArray(java.lang.classfile.AnnotationValue):
        def values(self) -> java.util.List['AnnotationValue']: ...
    class OfBoolean(java.lang.classfile.AnnotationValue.OfConstant):
        def booleanValue(self) -> bool: ...
        def constant(self) -> java.lang.classfile.constantpool.IntegerEntry: ...
        def resolvedValue(self) -> bool: ...
    class OfByte(java.lang.classfile.AnnotationValue.OfConstant):
        def byteValue(self) -> int: ...
        def constant(self) -> java.lang.classfile.constantpool.IntegerEntry: ...
        def resolvedValue(self) -> int: ...
    class OfChar(java.lang.classfile.AnnotationValue.OfConstant):
        def charValue(self) -> str: ...
        def constant(self) -> java.lang.classfile.constantpool.IntegerEntry: ...
        def resolvedValue(self) -> str: ...
    class OfClass(java.lang.classfile.AnnotationValue):
        def className(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
        def classSymbol(self) -> java.lang.constant.ClassDesc: ...
    class OfConstant(java.lang.classfile.AnnotationValue):
        def constant(self) -> java.lang.classfile.constantpool.AnnotationConstantValueEntry: ...
        def resolvedValue(self) -> java.lang.constant.Constable: ...
    class OfDouble(java.lang.classfile.AnnotationValue.OfConstant):
        def constant(self) -> java.lang.classfile.constantpool.DoubleEntry: ...
        def doubleValue(self) -> float: ...
        def resolvedValue(self) -> float: ...
    class OfEnum(java.lang.classfile.AnnotationValue):
        def className(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
        def classSymbol(self) -> java.lang.constant.ClassDesc: ...
        def constantName(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    class OfFloat(java.lang.classfile.AnnotationValue.OfConstant):
        def constant(self) -> java.lang.classfile.constantpool.FloatEntry: ...
        def floatValue(self) -> float: ...
        def resolvedValue(self) -> float: ...
    class OfInt(java.lang.classfile.AnnotationValue.OfConstant):
        def constant(self) -> java.lang.classfile.constantpool.IntegerEntry: ...
        def intValue(self) -> int: ...
        def resolvedValue(self) -> int: ...
    class OfLong(java.lang.classfile.AnnotationValue.OfConstant):
        def constant(self) -> java.lang.classfile.constantpool.LongEntry: ...
        def longValue(self) -> int: ...
        def resolvedValue(self) -> int: ...
    class OfShort(java.lang.classfile.AnnotationValue.OfConstant):
        def constant(self) -> java.lang.classfile.constantpool.IntegerEntry: ...
        def resolvedValue(self) -> int: ...
        def shortValue(self) -> int: ...
    class OfString(java.lang.classfile.AnnotationValue.OfConstant):
        def constant(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
        def resolvedValue(self) -> str: ...
        def stringValue(self) -> str: ...

class ClassFile:
    MAGIC_NUMBER: typing.ClassVar[int] = ...
    ACC_PUBLIC: typing.ClassVar[int] = ...
    ACC_PROTECTED: typing.ClassVar[int] = ...
    ACC_PRIVATE: typing.ClassVar[int] = ...
    ACC_INTERFACE: typing.ClassVar[int] = ...
    ACC_ENUM: typing.ClassVar[int] = ...
    ACC_ANNOTATION: typing.ClassVar[int] = ...
    ACC_SUPER: typing.ClassVar[int] = ...
    ACC_ABSTRACT: typing.ClassVar[int] = ...
    ACC_VOLATILE: typing.ClassVar[int] = ...
    ACC_TRANSIENT: typing.ClassVar[int] = ...
    ACC_SYNTHETIC: typing.ClassVar[int] = ...
    ACC_STATIC: typing.ClassVar[int] = ...
    ACC_FINAL: typing.ClassVar[int] = ...
    ACC_SYNCHRONIZED: typing.ClassVar[int] = ...
    ACC_BRIDGE: typing.ClassVar[int] = ...
    ACC_VARARGS: typing.ClassVar[int] = ...
    ACC_NATIVE: typing.ClassVar[int] = ...
    ACC_STRICT: typing.ClassVar[int] = ...
    ACC_MODULE: typing.ClassVar[int] = ...
    ACC_OPEN: typing.ClassVar[int] = ...
    ACC_MANDATED: typing.ClassVar[int] = ...
    ACC_TRANSITIVE: typing.ClassVar[int] = ...
    ACC_STATIC_PHASE: typing.ClassVar[int] = ...
    JAVA_1_VERSION: typing.ClassVar[int] = ...
    JAVA_2_VERSION: typing.ClassVar[int] = ...
    JAVA_3_VERSION: typing.ClassVar[int] = ...
    JAVA_4_VERSION: typing.ClassVar[int] = ...
    JAVA_5_VERSION: typing.ClassVar[int] = ...
    JAVA_6_VERSION: typing.ClassVar[int] = ...
    JAVA_7_VERSION: typing.ClassVar[int] = ...
    JAVA_8_VERSION: typing.ClassVar[int] = ...
    JAVA_9_VERSION: typing.ClassVar[int] = ...
    JAVA_10_VERSION: typing.ClassVar[int] = ...
    JAVA_11_VERSION: typing.ClassVar[int] = ...
    JAVA_12_VERSION: typing.ClassVar[int] = ...
    JAVA_13_VERSION: typing.ClassVar[int] = ...
    JAVA_14_VERSION: typing.ClassVar[int] = ...
    JAVA_15_VERSION: typing.ClassVar[int] = ...
    JAVA_16_VERSION: typing.ClassVar[int] = ...
    JAVA_17_VERSION: typing.ClassVar[int] = ...
    JAVA_18_VERSION: typing.ClassVar[int] = ...
    JAVA_19_VERSION: typing.ClassVar[int] = ...
    JAVA_20_VERSION: typing.ClassVar[int] = ...
    JAVA_21_VERSION: typing.ClassVar[int] = ...
    JAVA_22_VERSION: typing.ClassVar[int] = ...
    JAVA_23_VERSION: typing.ClassVar[int] = ...
    JAVA_24_VERSION: typing.ClassVar[int] = ...
    JAVA_25_VERSION: typing.ClassVar[int] = ...
    PREVIEW_MINOR_VERSION: typing.ClassVar[int] = ...
    @typing.overload
    def build(self, classEntry: java.lang.classfile.constantpool.ClassEntry, constantPoolBuilder: java.lang.classfile.constantpool.ConstantPoolBuilder, consumer: typing.Union[java.util.function.Consumer[ClassBuilder], typing.Callable[[ClassBuilder], None]]) -> typing.MutableSequence[int]: ...
    @typing.overload
    def build(self, classDesc: java.lang.constant.ClassDesc, consumer: typing.Union[java.util.function.Consumer[ClassBuilder], typing.Callable[[ClassBuilder], None]]) -> typing.MutableSequence[int]: ...
    @typing.overload
    def buildModule(self, moduleAttribute: java.lang.classfile.attribute.ModuleAttribute) -> typing.MutableSequence[int]: ...
    @typing.overload
    def buildModule(self, moduleAttribute: java.lang.classfile.attribute.ModuleAttribute, consumer: typing.Union[java.util.function.Consumer[ClassBuilder], typing.Callable[[ClassBuilder], None]]) -> typing.MutableSequence[int]: ...
    @typing.overload
    def buildModuleTo(self, path: typing.Union[java.nio.file.Path, jpype.protocol.SupportsPath], moduleAttribute: java.lang.classfile.attribute.ModuleAttribute) -> None: ...
    @typing.overload
    def buildModuleTo(self, path: typing.Union[java.nio.file.Path, jpype.protocol.SupportsPath], moduleAttribute: java.lang.classfile.attribute.ModuleAttribute, consumer: typing.Union[java.util.function.Consumer[ClassBuilder], typing.Callable[[ClassBuilder], None]]) -> None: ...
    @typing.overload
    def buildTo(self, path: typing.Union[java.nio.file.Path, jpype.protocol.SupportsPath], classEntry: java.lang.classfile.constantpool.ClassEntry, constantPoolBuilder: java.lang.classfile.constantpool.ConstantPoolBuilder, consumer: typing.Union[java.util.function.Consumer[ClassBuilder], typing.Callable[[ClassBuilder], None]]) -> None: ...
    @typing.overload
    def buildTo(self, path: typing.Union[java.nio.file.Path, jpype.protocol.SupportsPath], classDesc: java.lang.constant.ClassDesc, consumer: typing.Union[java.util.function.Consumer[ClassBuilder], typing.Callable[[ClassBuilder], None]]) -> None: ...
    @staticmethod
    def latestMajorVersion() -> int: ...
    @staticmethod
    def latestMinorVersion() -> int: ...
    @typing.overload
    @staticmethod
    def of() -> 'ClassFile': ...
    @typing.overload
    @staticmethod
    def of(*option: 'ClassFile.Option') -> 'ClassFile': ...
    @typing.overload
    def parse(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> ClassModel: ...
    @typing.overload
    def parse(self, path: typing.Union[java.nio.file.Path, jpype.protocol.SupportsPath]) -> ClassModel: ...
    @typing.overload
    def transformClass(self, classModel: ClassModel, classEntry: java.lang.classfile.constantpool.ClassEntry, classTransform: typing.Union[ClassTransform, typing.Callable]) -> typing.MutableSequence[int]: ...
    @typing.overload
    def transformClass(self, classModel: ClassModel, classTransform: typing.Union[ClassTransform, typing.Callable]) -> typing.MutableSequence[int]: ...
    @typing.overload
    def transformClass(self, classModel: ClassModel, classDesc: java.lang.constant.ClassDesc, classTransform: typing.Union[ClassTransform, typing.Callable]) -> typing.MutableSequence[int]: ...
    @typing.overload
    def verify(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> java.util.List[java.lang.VerifyError]: ...
    @typing.overload
    def verify(self, classModel: ClassModel) -> java.util.List[java.lang.VerifyError]: ...
    @typing.overload
    def verify(self, path: typing.Union[java.nio.file.Path, jpype.protocol.SupportsPath]) -> java.util.List[java.lang.VerifyError]: ...
    def withOptions(self, *option: 'ClassFile.Option') -> 'ClassFile': ...
    class AttributeMapperOption(java.lang.classfile.ClassFile.Option):
        def attributeMapper(self) -> java.util.function.Function[java.lang.classfile.constantpool.Utf8Entry, AttributeMapper[typing.Any]]: ...
        @staticmethod
        def of(function: typing.Union[java.util.function.Function[java.lang.classfile.constantpool.Utf8Entry, AttributeMapper[typing.Any]], typing.Callable[[java.lang.classfile.constantpool.Utf8Entry], AttributeMapper[typing.Any]]]) -> 'ClassFile.AttributeMapperOption': ...
    class AttributesProcessingOption(java.lang.Enum['ClassFile.AttributesProcessingOption'], java.lang.classfile.ClassFile.Option):
        PASS_ALL_ATTRIBUTES: typing.ClassVar['ClassFile.AttributesProcessingOption'] = ...
        DROP_UNKNOWN_ATTRIBUTES: typing.ClassVar['ClassFile.AttributesProcessingOption'] = ...
        DROP_UNSTABLE_ATTRIBUTES: typing.ClassVar['ClassFile.AttributesProcessingOption'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'ClassFile.AttributesProcessingOption': ...
        @staticmethod
        def values() -> typing.MutableSequence['ClassFile.AttributesProcessingOption']: ...
    class ClassHierarchyResolverOption(java.lang.classfile.ClassFile.Option):
        def classHierarchyResolver(self) -> ClassHierarchyResolver: ...
        @staticmethod
        def of(classHierarchyResolver: typing.Union[ClassHierarchyResolver, typing.Callable]) -> 'ClassFile.ClassHierarchyResolverOption': ...
    class ConstantPoolSharingOption(java.lang.Enum['ClassFile.ConstantPoolSharingOption'], java.lang.classfile.ClassFile.Option):
        SHARED_POOL: typing.ClassVar['ClassFile.ConstantPoolSharingOption'] = ...
        NEW_POOL: typing.ClassVar['ClassFile.ConstantPoolSharingOption'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'ClassFile.ConstantPoolSharingOption': ...
        @staticmethod
        def values() -> typing.MutableSequence['ClassFile.ConstantPoolSharingOption']: ...
    class DeadCodeOption(java.lang.Enum['ClassFile.DeadCodeOption'], java.lang.classfile.ClassFile.Option):
        PATCH_DEAD_CODE: typing.ClassVar['ClassFile.DeadCodeOption'] = ...
        KEEP_DEAD_CODE: typing.ClassVar['ClassFile.DeadCodeOption'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'ClassFile.DeadCodeOption': ...
        @staticmethod
        def values() -> typing.MutableSequence['ClassFile.DeadCodeOption']: ...
    class DeadLabelsOption(java.lang.Enum['ClassFile.DeadLabelsOption'], java.lang.classfile.ClassFile.Option):
        FAIL_ON_DEAD_LABELS: typing.ClassVar['ClassFile.DeadLabelsOption'] = ...
        DROP_DEAD_LABELS: typing.ClassVar['ClassFile.DeadLabelsOption'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'ClassFile.DeadLabelsOption': ...
        @staticmethod
        def values() -> typing.MutableSequence['ClassFile.DeadLabelsOption']: ...
    class DebugElementsOption(java.lang.Enum['ClassFile.DebugElementsOption'], java.lang.classfile.ClassFile.Option):
        PASS_DEBUG: typing.ClassVar['ClassFile.DebugElementsOption'] = ...
        DROP_DEBUG: typing.ClassVar['ClassFile.DebugElementsOption'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'ClassFile.DebugElementsOption': ...
        @staticmethod
        def values() -> typing.MutableSequence['ClassFile.DebugElementsOption']: ...
    class LineNumbersOption(java.lang.Enum['ClassFile.LineNumbersOption'], java.lang.classfile.ClassFile.Option):
        PASS_LINE_NUMBERS: typing.ClassVar['ClassFile.LineNumbersOption'] = ...
        DROP_LINE_NUMBERS: typing.ClassVar['ClassFile.LineNumbersOption'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'ClassFile.LineNumbersOption': ...
        @staticmethod
        def values() -> typing.MutableSequence['ClassFile.LineNumbersOption']: ...
    class Option: ...
    class ShortJumpsOption(java.lang.Enum['ClassFile.ShortJumpsOption'], java.lang.classfile.ClassFile.Option):
        FIX_SHORT_JUMPS: typing.ClassVar['ClassFile.ShortJumpsOption'] = ...
        FAIL_ON_SHORT_JUMPS: typing.ClassVar['ClassFile.ShortJumpsOption'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'ClassFile.ShortJumpsOption': ...
        @staticmethod
        def values() -> typing.MutableSequence['ClassFile.ShortJumpsOption']: ...
    class StackMapsOption(java.lang.Enum['ClassFile.StackMapsOption'], java.lang.classfile.ClassFile.Option):
        STACK_MAPS_WHEN_REQUIRED: typing.ClassVar['ClassFile.StackMapsOption'] = ...
        GENERATE_STACK_MAPS: typing.ClassVar['ClassFile.StackMapsOption'] = ...
        DROP_STACK_MAPS: typing.ClassVar['ClassFile.StackMapsOption'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'ClassFile.StackMapsOption': ...
        @staticmethod
        def values() -> typing.MutableSequence['ClassFile.StackMapsOption']: ...

class CodeBuilder(ClassFileBuilder[CodeElement, 'CodeBuilder']):
    def aaload(self) -> 'CodeBuilder': ...
    def aastore(self) -> 'CodeBuilder': ...
    def aconst_null(self) -> 'CodeBuilder': ...
    def allocateLocal(self, typeKind: TypeKind) -> int: ...
    def aload(self, int: int) -> 'CodeBuilder': ...
    @typing.overload
    def anewarray(self, classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'CodeBuilder': ...
    @typing.overload
    def anewarray(self, classDesc: java.lang.constant.ClassDesc) -> 'CodeBuilder': ...
    def areturn(self) -> 'CodeBuilder': ...
    def arrayLoad(self, typeKind: TypeKind) -> 'CodeBuilder': ...
    def arrayStore(self, typeKind: TypeKind) -> 'CodeBuilder': ...
    def arraylength(self) -> 'CodeBuilder': ...
    def astore(self, int: int) -> 'CodeBuilder': ...
    def athrow(self) -> 'CodeBuilder': ...
    def baload(self) -> 'CodeBuilder': ...
    def bastore(self) -> 'CodeBuilder': ...
    def bipush(self, int: int) -> 'CodeBuilder': ...
    def block(self, consumer: typing.Union[java.util.function.Consumer['CodeBuilder.BlockCodeBuilder'], typing.Callable[['CodeBuilder.BlockCodeBuilder'], None]]) -> 'CodeBuilder': ...
    def branch(self, opcode: Opcode, label: Label) -> 'CodeBuilder': ...
    def caload(self) -> 'CodeBuilder': ...
    def castore(self) -> 'CodeBuilder': ...
    def characterRange(self, label: Label, label2: Label, int: int, int2: int, int3: int) -> 'CodeBuilder': ...
    @typing.overload
    def checkcast(self, classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'CodeBuilder': ...
    @typing.overload
    def checkcast(self, classDesc: java.lang.constant.ClassDesc) -> 'CodeBuilder': ...
    def conversion(self, typeKind: TypeKind, typeKind2: TypeKind) -> 'CodeBuilder': ...
    def d2f(self) -> 'CodeBuilder': ...
    def d2i(self) -> 'CodeBuilder': ...
    def d2l(self) -> 'CodeBuilder': ...
    def dadd(self) -> 'CodeBuilder': ...
    def daload(self) -> 'CodeBuilder': ...
    def dastore(self) -> 'CodeBuilder': ...
    def dcmpg(self) -> 'CodeBuilder': ...
    def dcmpl(self) -> 'CodeBuilder': ...
    def dconst_0(self) -> 'CodeBuilder': ...
    def dconst_1(self) -> 'CodeBuilder': ...
    def ddiv(self) -> 'CodeBuilder': ...
    def dload(self, int: int) -> 'CodeBuilder': ...
    def dmul(self) -> 'CodeBuilder': ...
    def dneg(self) -> 'CodeBuilder': ...
    def drem(self) -> 'CodeBuilder': ...
    def dreturn(self) -> 'CodeBuilder': ...
    def dstore(self, int: int) -> 'CodeBuilder': ...
    def dsub(self) -> 'CodeBuilder': ...
    def dup(self) -> 'CodeBuilder': ...
    def dup2(self) -> 'CodeBuilder': ...
    def dup2_x1(self) -> 'CodeBuilder': ...
    def dup2_x2(self) -> 'CodeBuilder': ...
    def dup_x1(self) -> 'CodeBuilder': ...
    def dup_x2(self) -> 'CodeBuilder': ...
    def endLabel(self) -> Label: ...
    @typing.overload
    def exceptionCatch(self, label: Label, label2: Label, label3: Label, classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'CodeBuilder': ...
    @typing.overload
    def exceptionCatch(self, label: Label, label2: Label, label3: Label, classDesc: java.lang.constant.ClassDesc) -> 'CodeBuilder': ...
    @typing.overload
    def exceptionCatch(self, label: Label, label2: Label, label3: Label, optional: java.util.Optional[java.lang.classfile.constantpool.ClassEntry]) -> 'CodeBuilder': ...
    def exceptionCatchAll(self, label: Label, label2: Label, label3: Label) -> 'CodeBuilder': ...
    def f2d(self) -> 'CodeBuilder': ...
    def f2i(self) -> 'CodeBuilder': ...
    def f2l(self) -> 'CodeBuilder': ...
    def fadd(self) -> 'CodeBuilder': ...
    def faload(self) -> 'CodeBuilder': ...
    def fastore(self) -> 'CodeBuilder': ...
    def fcmpg(self) -> 'CodeBuilder': ...
    def fcmpl(self) -> 'CodeBuilder': ...
    def fconst_0(self) -> 'CodeBuilder': ...
    def fconst_1(self) -> 'CodeBuilder': ...
    def fconst_2(self) -> 'CodeBuilder': ...
    def fdiv(self) -> 'CodeBuilder': ...
    @typing.overload
    def fieldAccess(self, opcode: Opcode, fieldRefEntry: java.lang.classfile.constantpool.FieldRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def fieldAccess(self, opcode: Opcode, classDesc: java.lang.constant.ClassDesc, string: str, classDesc2: java.lang.constant.ClassDesc) -> 'CodeBuilder': ...
    def fload(self, int: int) -> 'CodeBuilder': ...
    def fmul(self) -> 'CodeBuilder': ...
    def fneg(self) -> 'CodeBuilder': ...
    def frem(self) -> 'CodeBuilder': ...
    def freturn(self) -> 'CodeBuilder': ...
    def fstore(self, int: int) -> 'CodeBuilder': ...
    def fsub(self) -> 'CodeBuilder': ...
    @typing.overload
    def getfield(self, fieldRefEntry: java.lang.classfile.constantpool.FieldRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def getfield(self, classDesc: java.lang.constant.ClassDesc, string: str, classDesc2: java.lang.constant.ClassDesc) -> 'CodeBuilder': ...
    @typing.overload
    def getstatic(self, fieldRefEntry: java.lang.classfile.constantpool.FieldRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def getstatic(self, classDesc: java.lang.constant.ClassDesc, string: str, classDesc2: java.lang.constant.ClassDesc) -> 'CodeBuilder': ...
    def goto_(self, label: Label) -> 'CodeBuilder': ...
    def goto_w(self, label: Label) -> 'CodeBuilder': ...
    def i2b(self) -> 'CodeBuilder': ...
    def i2c(self) -> 'CodeBuilder': ...
    def i2d(self) -> 'CodeBuilder': ...
    def i2f(self) -> 'CodeBuilder': ...
    def i2l(self) -> 'CodeBuilder': ...
    def i2s(self) -> 'CodeBuilder': ...
    def iadd(self) -> 'CodeBuilder': ...
    def iaload(self) -> 'CodeBuilder': ...
    def iand(self) -> 'CodeBuilder': ...
    def iastore(self) -> 'CodeBuilder': ...
    def iconst_0(self) -> 'CodeBuilder': ...
    def iconst_1(self) -> 'CodeBuilder': ...
    def iconst_2(self) -> 'CodeBuilder': ...
    def iconst_3(self) -> 'CodeBuilder': ...
    def iconst_4(self) -> 'CodeBuilder': ...
    def iconst_5(self) -> 'CodeBuilder': ...
    def iconst_m1(self) -> 'CodeBuilder': ...
    def idiv(self) -> 'CodeBuilder': ...
    @typing.overload
    def ifThen(self, opcode: Opcode, consumer: typing.Union[java.util.function.Consumer['CodeBuilder.BlockCodeBuilder'], typing.Callable[['CodeBuilder.BlockCodeBuilder'], None]]) -> 'CodeBuilder': ...
    @typing.overload
    def ifThen(self, consumer: typing.Union[java.util.function.Consumer['CodeBuilder.BlockCodeBuilder'], typing.Callable[['CodeBuilder.BlockCodeBuilder'], None]]) -> 'CodeBuilder': ...
    @typing.overload
    def ifThenElse(self, opcode: Opcode, consumer: typing.Union[java.util.function.Consumer['CodeBuilder.BlockCodeBuilder'], typing.Callable[['CodeBuilder.BlockCodeBuilder'], None]], consumer2: typing.Union[java.util.function.Consumer['CodeBuilder.BlockCodeBuilder'], typing.Callable[['CodeBuilder.BlockCodeBuilder'], None]]) -> 'CodeBuilder': ...
    @typing.overload
    def ifThenElse(self, consumer: typing.Union[java.util.function.Consumer['CodeBuilder.BlockCodeBuilder'], typing.Callable[['CodeBuilder.BlockCodeBuilder'], None]], consumer2: typing.Union[java.util.function.Consumer['CodeBuilder.BlockCodeBuilder'], typing.Callable[['CodeBuilder.BlockCodeBuilder'], None]]) -> 'CodeBuilder': ...
    def if_acmpeq(self, label: Label) -> 'CodeBuilder': ...
    def if_acmpne(self, label: Label) -> 'CodeBuilder': ...
    def if_icmpeq(self, label: Label) -> 'CodeBuilder': ...
    def if_icmpge(self, label: Label) -> 'CodeBuilder': ...
    def if_icmpgt(self, label: Label) -> 'CodeBuilder': ...
    def if_icmple(self, label: Label) -> 'CodeBuilder': ...
    def if_icmplt(self, label: Label) -> 'CodeBuilder': ...
    def if_icmpne(self, label: Label) -> 'CodeBuilder': ...
    def ifeq(self, label: Label) -> 'CodeBuilder': ...
    def ifge(self, label: Label) -> 'CodeBuilder': ...
    def ifgt(self, label: Label) -> 'CodeBuilder': ...
    def ifle(self, label: Label) -> 'CodeBuilder': ...
    def iflt(self, label: Label) -> 'CodeBuilder': ...
    def ifne(self, label: Label) -> 'CodeBuilder': ...
    def ifnonnull(self, label: Label) -> 'CodeBuilder': ...
    def ifnull(self, label: Label) -> 'CodeBuilder': ...
    def iinc(self, int: int, int2: int) -> 'CodeBuilder': ...
    def iload(self, int: int) -> 'CodeBuilder': ...
    def imul(self) -> 'CodeBuilder': ...
    def ineg(self) -> 'CodeBuilder': ...
    @typing.overload
    def instanceOf(self, classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'CodeBuilder': ...
    @typing.overload
    def instanceOf(self, classDesc: java.lang.constant.ClassDesc) -> 'CodeBuilder': ...
    @typing.overload
    def invoke(self, opcode: Opcode, memberRefEntry: java.lang.classfile.constantpool.MemberRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def invoke(self, opcode: Opcode, classDesc: java.lang.constant.ClassDesc, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc, boolean: bool) -> 'CodeBuilder': ...
    @typing.overload
    def invokedynamic(self, invokeDynamicEntry: java.lang.classfile.constantpool.InvokeDynamicEntry) -> 'CodeBuilder': ...
    @typing.overload
    def invokedynamic(self, dynamicCallSiteDesc: java.lang.constant.DynamicCallSiteDesc) -> 'CodeBuilder': ...
    @typing.overload
    def invokeinterface(self, interfaceMethodRefEntry: java.lang.classfile.constantpool.InterfaceMethodRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def invokeinterface(self, classDesc: java.lang.constant.ClassDesc, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc) -> 'CodeBuilder': ...
    @typing.overload
    def invokespecial(self, interfaceMethodRefEntry: java.lang.classfile.constantpool.InterfaceMethodRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def invokespecial(self, methodRefEntry: java.lang.classfile.constantpool.MethodRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def invokespecial(self, classDesc: java.lang.constant.ClassDesc, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc) -> 'CodeBuilder': ...
    @typing.overload
    def invokespecial(self, classDesc: java.lang.constant.ClassDesc, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc, boolean: bool) -> 'CodeBuilder': ...
    @typing.overload
    def invokestatic(self, interfaceMethodRefEntry: java.lang.classfile.constantpool.InterfaceMethodRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def invokestatic(self, methodRefEntry: java.lang.classfile.constantpool.MethodRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def invokestatic(self, classDesc: java.lang.constant.ClassDesc, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc) -> 'CodeBuilder': ...
    @typing.overload
    def invokestatic(self, classDesc: java.lang.constant.ClassDesc, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc, boolean: bool) -> 'CodeBuilder': ...
    @typing.overload
    def invokevirtual(self, methodRefEntry: java.lang.classfile.constantpool.MethodRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def invokevirtual(self, classDesc: java.lang.constant.ClassDesc, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc) -> 'CodeBuilder': ...
    def ior(self) -> 'CodeBuilder': ...
    def irem(self) -> 'CodeBuilder': ...
    def ireturn(self) -> 'CodeBuilder': ...
    def ishl(self) -> 'CodeBuilder': ...
    def ishr(self) -> 'CodeBuilder': ...
    def istore(self, int: int) -> 'CodeBuilder': ...
    def isub(self) -> 'CodeBuilder': ...
    def iushr(self) -> 'CodeBuilder': ...
    def ixor(self) -> 'CodeBuilder': ...
    def l2d(self) -> 'CodeBuilder': ...
    def l2f(self) -> 'CodeBuilder': ...
    def l2i(self) -> 'CodeBuilder': ...
    def labelBinding(self, label: Label) -> 'CodeBuilder': ...
    def ladd(self) -> 'CodeBuilder': ...
    def laload(self) -> 'CodeBuilder': ...
    def land(self) -> 'CodeBuilder': ...
    def lastore(self) -> 'CodeBuilder': ...
    def lcmp(self) -> 'CodeBuilder': ...
    def lconst_0(self) -> 'CodeBuilder': ...
    def lconst_1(self) -> 'CodeBuilder': ...
    @typing.overload
    def ldc(self, loadableConstantEntry: java.lang.classfile.constantpool.LoadableConstantEntry) -> 'CodeBuilder': ...
    @typing.overload
    def ldc(self, constantDesc: java.lang.constant.ConstantDesc) -> 'CodeBuilder': ...
    def ldiv(self) -> 'CodeBuilder': ...
    def lineNumber(self, int: int) -> 'CodeBuilder': ...
    def lload(self, int: int) -> 'CodeBuilder': ...
    def lmul(self) -> 'CodeBuilder': ...
    def lneg(self) -> 'CodeBuilder': ...
    @typing.overload
    def loadConstant(self, double: float) -> 'CodeBuilder': ...
    @typing.overload
    def loadConstant(self, float: float) -> 'CodeBuilder': ...
    @typing.overload
    def loadConstant(self, int: int) -> 'CodeBuilder': ...
    @typing.overload
    def loadConstant(self, constantDesc: java.lang.constant.ConstantDesc) -> 'CodeBuilder': ...
    @typing.overload
    def loadConstant(self, long: int) -> 'CodeBuilder': ...
    def loadLocal(self, typeKind: TypeKind, int: int) -> 'CodeBuilder': ...
    @typing.overload
    def localVariable(self, int: int, string: str, classDesc: java.lang.constant.ClassDesc, label: Label, label2: Label) -> 'CodeBuilder': ...
    @typing.overload
    def localVariable(self, int: int, utf8Entry: java.lang.classfile.constantpool.Utf8Entry, utf8Entry2: java.lang.classfile.constantpool.Utf8Entry, label: Label, label2: Label) -> 'CodeBuilder': ...
    @typing.overload
    def localVariableType(self, int: int, string: str, signature: 'Signature', label: Label, label2: Label) -> 'CodeBuilder': ...
    @typing.overload
    def localVariableType(self, int: int, utf8Entry: java.lang.classfile.constantpool.Utf8Entry, utf8Entry2: java.lang.classfile.constantpool.Utf8Entry, label: Label, label2: Label) -> 'CodeBuilder': ...
    def lookupswitch(self, label: Label, list: java.util.List[java.lang.classfile.instruction.SwitchCase]) -> 'CodeBuilder': ...
    def lor(self) -> 'CodeBuilder': ...
    def lrem(self) -> 'CodeBuilder': ...
    def lreturn(self) -> 'CodeBuilder': ...
    def lshl(self) -> 'CodeBuilder': ...
    def lshr(self) -> 'CodeBuilder': ...
    def lstore(self, int: int) -> 'CodeBuilder': ...
    def lsub(self) -> 'CodeBuilder': ...
    def lushr(self) -> 'CodeBuilder': ...
    def lxor(self) -> 'CodeBuilder': ...
    def monitorenter(self) -> 'CodeBuilder': ...
    def monitorexit(self) -> 'CodeBuilder': ...
    @typing.overload
    def multianewarray(self, classEntry: java.lang.classfile.constantpool.ClassEntry, int: int) -> 'CodeBuilder': ...
    @typing.overload
    def multianewarray(self, classDesc: java.lang.constant.ClassDesc, int: int) -> 'CodeBuilder': ...
    def newBoundLabel(self) -> Label: ...
    def newLabel(self) -> Label: ...
    @typing.overload
    def new_(self, classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'CodeBuilder': ...
    @typing.overload
    def new_(self, classDesc: java.lang.constant.ClassDesc) -> 'CodeBuilder': ...
    def newarray(self, typeKind: TypeKind) -> 'CodeBuilder': ...
    def nop(self) -> 'CodeBuilder': ...
    def parameterSlot(self, int: int) -> int: ...
    def pop(self) -> 'CodeBuilder': ...
    def pop2(self) -> 'CodeBuilder': ...
    @typing.overload
    def putfield(self, fieldRefEntry: java.lang.classfile.constantpool.FieldRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def putfield(self, classDesc: java.lang.constant.ClassDesc, string: str, classDesc2: java.lang.constant.ClassDesc) -> 'CodeBuilder': ...
    @typing.overload
    def putstatic(self, fieldRefEntry: java.lang.classfile.constantpool.FieldRefEntry) -> 'CodeBuilder': ...
    @typing.overload
    def putstatic(self, classDesc: java.lang.constant.ClassDesc, string: str, classDesc2: java.lang.constant.ClassDesc) -> 'CodeBuilder': ...
    def receiverSlot(self) -> int: ...
    @typing.overload
    def return_(self) -> 'CodeBuilder': ...
    @typing.overload
    def return_(self, typeKind: TypeKind) -> 'CodeBuilder': ...
    def saload(self) -> 'CodeBuilder': ...
    def sastore(self) -> 'CodeBuilder': ...
    def sipush(self, int: int) -> 'CodeBuilder': ...
    def startLabel(self) -> Label: ...
    def storeLocal(self, typeKind: TypeKind, int: int) -> 'CodeBuilder': ...
    def swap(self) -> 'CodeBuilder': ...
    @typing.overload
    def tableswitch(self, int: int, int2: int, label: Label, list: java.util.List[java.lang.classfile.instruction.SwitchCase]) -> 'CodeBuilder': ...
    @typing.overload
    def tableswitch(self, label: Label, list: java.util.List[java.lang.classfile.instruction.SwitchCase]) -> 'CodeBuilder': ...
    def transforming(self, codeTransform: typing.Union[CodeTransform, typing.Callable], consumer: typing.Union[java.util.function.Consumer['CodeBuilder'], typing.Callable[['CodeBuilder'], None]]) -> 'CodeBuilder': ...
    def trying(self, consumer: typing.Union[java.util.function.Consumer['CodeBuilder.BlockCodeBuilder'], typing.Callable[['CodeBuilder.BlockCodeBuilder'], None]], consumer2: typing.Union[java.util.function.Consumer['CodeBuilder.CatchBuilder'], typing.Callable[['CodeBuilder.CatchBuilder'], None]]) -> 'CodeBuilder': ...
    class BlockCodeBuilder(java.lang.classfile.CodeBuilder):
        def breakLabel(self) -> Label: ...
    class CatchBuilder:
        def catching(self, classDesc: java.lang.constant.ClassDesc, consumer: typing.Union[java.util.function.Consumer['CodeBuilder.BlockCodeBuilder'], typing.Callable[['CodeBuilder.BlockCodeBuilder'], None]]) -> 'CodeBuilder.CatchBuilder': ...
        def catchingAll(self, consumer: typing.Union[java.util.function.Consumer['CodeBuilder.BlockCodeBuilder'], typing.Callable[['CodeBuilder.BlockCodeBuilder'], None]]) -> None: ...
        def catchingMulti(self, list: java.util.List[java.lang.constant.ClassDesc], consumer: typing.Union[java.util.function.Consumer['CodeBuilder.BlockCodeBuilder'], typing.Callable[['CodeBuilder.BlockCodeBuilder'], None]]) -> 'CodeBuilder.CatchBuilder': ...

class Signature:
    @staticmethod
    def of(classDesc: java.lang.constant.ClassDesc) -> 'Signature': ...
    @staticmethod
    def parseFrom(string: str) -> 'Signature': ...
    def signatureString(self) -> str: ...
    class ArrayTypeSig(java.lang.classfile.Signature.RefTypeSig):
        def componentSignature(self) -> 'Signature': ...
        @typing.overload
        @staticmethod
        def of(int: int, signature: 'Signature') -> 'Signature.ArrayTypeSig': ...
        @typing.overload
        @staticmethod
        def of(signature: 'Signature') -> 'Signature.ArrayTypeSig': ...
    class BaseTypeSig(java.lang.classfile.Signature):
        def baseType(self) -> str: ...
        @typing.overload
        @staticmethod
        def of(char: str) -> 'Signature.BaseTypeSig': ...
        @typing.overload
        @staticmethod
        def of(classDesc: java.lang.constant.ClassDesc) -> 'Signature.BaseTypeSig': ...
    class ClassTypeSig(java.lang.classfile.Signature.RefTypeSig, java.lang.classfile.Signature.ThrowableSig):
        def classDesc(self) -> java.lang.constant.ClassDesc: ...
        def className(self) -> str: ...
        @typing.overload
        @staticmethod
        def of(string: str, *typeArg: 'Signature.TypeArg') -> 'Signature.ClassTypeSig': ...
        @typing.overload
        @staticmethod
        def of(classTypeSig: 'Signature.ClassTypeSig', string: str, *typeArg: 'Signature.TypeArg') -> 'Signature.ClassTypeSig': ...
        @typing.overload
        @staticmethod
        def of(classTypeSig: 'Signature.ClassTypeSig', classDesc: java.lang.constant.ClassDesc, *typeArg: 'Signature.TypeArg') -> 'Signature.ClassTypeSig': ...
        @typing.overload
        @staticmethod
        def of(classDesc: java.lang.constant.ClassDesc, *typeArg: 'Signature.TypeArg') -> 'Signature.ClassTypeSig': ...
        def outerType(self) -> java.util.Optional['Signature.ClassTypeSig']: ...
        def typeArgs(self) -> java.util.List['Signature.TypeArg']: ...
    class RefTypeSig(java.lang.classfile.Signature): ...
    class ThrowableSig(java.lang.classfile.Signature): ...
    class TypeArg:
        @staticmethod
        def bounded(wildcardIndicator: 'Signature.TypeArg.Bounded.WildcardIndicator', refTypeSig: 'Signature.RefTypeSig') -> 'Signature.TypeArg.Bounded': ...
        @staticmethod
        def extendsOf(refTypeSig: 'Signature.RefTypeSig') -> 'Signature.TypeArg.Bounded': ...
        @staticmethod
        def of(refTypeSig: 'Signature.RefTypeSig') -> 'Signature.TypeArg.Bounded': ...
        @staticmethod
        def superOf(refTypeSig: 'Signature.RefTypeSig') -> 'Signature.TypeArg.Bounded': ...
        @staticmethod
        def unbounded() -> 'Signature.TypeArg.Unbounded': ...
        class Bounded(java.lang.classfile.Signature.TypeArg):
            def boundType(self) -> 'Signature.RefTypeSig': ...
            def wildcardIndicator(self) -> 'Signature.TypeArg.Bounded.WildcardIndicator': ...
            class WildcardIndicator(java.lang.Enum['Signature.TypeArg.Bounded.WildcardIndicator']):
                NONE: typing.ClassVar['Signature.TypeArg.Bounded.WildcardIndicator'] = ...
                EXTENDS: typing.ClassVar['Signature.TypeArg.Bounded.WildcardIndicator'] = ...
                SUPER: typing.ClassVar['Signature.TypeArg.Bounded.WildcardIndicator'] = ...
                _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
                @typing.overload
                @staticmethod
                def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
                @typing.overload
                @staticmethod
                def valueOf(string: str) -> 'Signature.TypeArg.Bounded.WildcardIndicator': ...
                @staticmethod
                def values() -> typing.MutableSequence['Signature.TypeArg.Bounded.WildcardIndicator']: ...
        class Unbounded(java.lang.classfile.Signature.TypeArg): ...
    class TypeParam:
        def classBound(self) -> java.util.Optional['Signature.RefTypeSig']: ...
        def identifier(self) -> str: ...
        def interfaceBounds(self) -> java.util.List['Signature.RefTypeSig']: ...
        @typing.overload
        @staticmethod
        def of(string: str, refTypeSig: 'Signature.RefTypeSig', *refTypeSig2: 'Signature.RefTypeSig') -> 'Signature.TypeParam': ...
        @typing.overload
        @staticmethod
        def of(string: str, optional: java.util.Optional['Signature.RefTypeSig'], *refTypeSig: 'Signature.RefTypeSig') -> 'Signature.TypeParam': ...
    class TypeVarSig(java.lang.classfile.Signature.RefTypeSig, java.lang.classfile.Signature.ThrowableSig):
        def identifier(self) -> str: ...
        @staticmethod
        def of(string: str) -> 'Signature.TypeVarSig': ...

class TypeAnnotation:
    def annotation(self) -> Annotation: ...
    @staticmethod
    def of(targetInfo: 'TypeAnnotation.TargetInfo', list: java.util.List['TypeAnnotation.TypePathComponent'], annotation: Annotation) -> 'TypeAnnotation': ...
    def targetInfo(self) -> 'TypeAnnotation.TargetInfo': ...
    def targetPath(self) -> java.util.List['TypeAnnotation.TypePathComponent']: ...
    class CatchTarget(java.lang.classfile.TypeAnnotation.TargetInfo):
        def exceptionTableIndex(self) -> int: ...
    class EmptyTarget(java.lang.classfile.TypeAnnotation.TargetInfo): ...
    class FormalParameterTarget(java.lang.classfile.TypeAnnotation.TargetInfo):
        def formalParameterIndex(self) -> int: ...
    class LocalVarTarget(java.lang.classfile.TypeAnnotation.TargetInfo):
        def table(self) -> java.util.List['TypeAnnotation.LocalVarTargetInfo']: ...
    class LocalVarTargetInfo:
        def endLabel(self) -> Label: ...
        def index(self) -> int: ...
        @staticmethod
        def of(label: Label, label2: Label, int: int) -> 'TypeAnnotation.LocalVarTargetInfo': ...
        def startLabel(self) -> Label: ...
    class OffsetTarget(java.lang.classfile.TypeAnnotation.TargetInfo):
        def target(self) -> Label: ...
    class SupertypeTarget(java.lang.classfile.TypeAnnotation.TargetInfo):
        def supertypeIndex(self) -> int: ...
    class TargetInfo:
        TARGET_CLASS_TYPE_PARAMETER: typing.ClassVar[int] = ...
        TARGET_METHOD_TYPE_PARAMETER: typing.ClassVar[int] = ...
        TARGET_CLASS_EXTENDS: typing.ClassVar[int] = ...
        TARGET_CLASS_TYPE_PARAMETER_BOUND: typing.ClassVar[int] = ...
        TARGET_METHOD_TYPE_PARAMETER_BOUND: typing.ClassVar[int] = ...
        TARGET_FIELD: typing.ClassVar[int] = ...
        TARGET_METHOD_RETURN: typing.ClassVar[int] = ...
        TARGET_METHOD_RECEIVER: typing.ClassVar[int] = ...
        TARGET_METHOD_FORMAL_PARAMETER: typing.ClassVar[int] = ...
        TARGET_THROWS: typing.ClassVar[int] = ...
        TARGET_LOCAL_VARIABLE: typing.ClassVar[int] = ...
        TARGET_RESOURCE_VARIABLE: typing.ClassVar[int] = ...
        TARGET_EXCEPTION_PARAMETER: typing.ClassVar[int] = ...
        TARGET_INSTANCEOF: typing.ClassVar[int] = ...
        TARGET_NEW: typing.ClassVar[int] = ...
        TARGET_CONSTRUCTOR_REFERENCE: typing.ClassVar[int] = ...
        TARGET_METHOD_REFERENCE: typing.ClassVar[int] = ...
        TARGET_CAST: typing.ClassVar[int] = ...
        TARGET_CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: typing.ClassVar[int] = ...
        TARGET_METHOD_INVOCATION_TYPE_ARGUMENT: typing.ClassVar[int] = ...
        TARGET_CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: typing.ClassVar[int] = ...
        TARGET_METHOD_REFERENCE_TYPE_ARGUMENT: typing.ClassVar[int] = ...
        @staticmethod
        def of(targetType: 'TypeAnnotation.TargetType') -> 'TypeAnnotation.EmptyTarget': ...
        @staticmethod
        def ofCastExpr(label: Label, int: int) -> 'TypeAnnotation.TypeArgumentTarget': ...
        @staticmethod
        def ofClassExtends(int: int) -> 'TypeAnnotation.SupertypeTarget': ...
        @staticmethod
        def ofClassTypeParameter(int: int) -> 'TypeAnnotation.TypeParameterTarget': ...
        @staticmethod
        def ofClassTypeParameterBound(int: int, int2: int) -> 'TypeAnnotation.TypeParameterBoundTarget': ...
        @staticmethod
        def ofConstructorInvocationTypeArgument(label: Label, int: int) -> 'TypeAnnotation.TypeArgumentTarget': ...
        @staticmethod
        def ofConstructorReference(label: Label) -> 'TypeAnnotation.OffsetTarget': ...
        @staticmethod
        def ofConstructorReferenceTypeArgument(label: Label, int: int) -> 'TypeAnnotation.TypeArgumentTarget': ...
        @staticmethod
        def ofExceptionParameter(int: int) -> 'TypeAnnotation.CatchTarget': ...
        @staticmethod
        def ofField() -> 'TypeAnnotation.EmptyTarget': ...
        @staticmethod
        def ofInstanceofExpr(label: Label) -> 'TypeAnnotation.OffsetTarget': ...
        @staticmethod
        def ofLocalVariable(list: java.util.List['TypeAnnotation.LocalVarTargetInfo']) -> 'TypeAnnotation.LocalVarTarget': ...
        @staticmethod
        def ofMethodFormalParameter(int: int) -> 'TypeAnnotation.FormalParameterTarget': ...
        @staticmethod
        def ofMethodInvocationTypeArgument(label: Label, int: int) -> 'TypeAnnotation.TypeArgumentTarget': ...
        @staticmethod
        def ofMethodReceiver() -> 'TypeAnnotation.EmptyTarget': ...
        @staticmethod
        def ofMethodReference(label: Label) -> 'TypeAnnotation.OffsetTarget': ...
        @staticmethod
        def ofMethodReferenceTypeArgument(label: Label, int: int) -> 'TypeAnnotation.TypeArgumentTarget': ...
        @staticmethod
        def ofMethodReturn() -> 'TypeAnnotation.EmptyTarget': ...
        @staticmethod
        def ofMethodTypeParameter(int: int) -> 'TypeAnnotation.TypeParameterTarget': ...
        @staticmethod
        def ofMethodTypeParameterBound(int: int, int2: int) -> 'TypeAnnotation.TypeParameterBoundTarget': ...
        @staticmethod
        def ofNewExpr(label: Label) -> 'TypeAnnotation.OffsetTarget': ...
        @staticmethod
        def ofOffset(targetType: 'TypeAnnotation.TargetType', label: Label) -> 'TypeAnnotation.OffsetTarget': ...
        @staticmethod
        def ofResourceVariable(list: java.util.List['TypeAnnotation.LocalVarTargetInfo']) -> 'TypeAnnotation.LocalVarTarget': ...
        @staticmethod
        def ofThrows(int: int) -> 'TypeAnnotation.ThrowsTarget': ...
        @staticmethod
        def ofTypeArgument(targetType: 'TypeAnnotation.TargetType', label: Label, int: int) -> 'TypeAnnotation.TypeArgumentTarget': ...
        @staticmethod
        def ofTypeParameter(targetType: 'TypeAnnotation.TargetType', int: int) -> 'TypeAnnotation.TypeParameterTarget': ...
        @staticmethod
        def ofTypeParameterBound(targetType: 'TypeAnnotation.TargetType', int: int, int2: int) -> 'TypeAnnotation.TypeParameterBoundTarget': ...
        @staticmethod
        def ofVariable(targetType: 'TypeAnnotation.TargetType', list: java.util.List['TypeAnnotation.LocalVarTargetInfo']) -> 'TypeAnnotation.LocalVarTarget': ...
        def size(self) -> int: ...
        def targetType(self) -> 'TypeAnnotation.TargetType': ...
    class TargetType(java.lang.Enum['TypeAnnotation.TargetType']):
        CLASS_TYPE_PARAMETER: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        METHOD_TYPE_PARAMETER: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        CLASS_EXTENDS: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        CLASS_TYPE_PARAMETER_BOUND: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        METHOD_TYPE_PARAMETER_BOUND: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        FIELD: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        METHOD_RETURN: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        METHOD_RECEIVER: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        METHOD_FORMAL_PARAMETER: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        THROWS: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        LOCAL_VARIABLE: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        RESOURCE_VARIABLE: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        EXCEPTION_PARAMETER: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        INSTANCEOF: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        NEW: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        CONSTRUCTOR_REFERENCE: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        METHOD_REFERENCE: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        CAST: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        METHOD_INVOCATION_TYPE_ARGUMENT: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        METHOD_REFERENCE_TYPE_ARGUMENT: typing.ClassVar['TypeAnnotation.TargetType'] = ...
        def sizeIfFixed(self) -> int: ...
        def targetTypeValue(self) -> int: ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'TypeAnnotation.TargetType': ...
        @staticmethod
        def values() -> typing.MutableSequence['TypeAnnotation.TargetType']: ...
    class ThrowsTarget(java.lang.classfile.TypeAnnotation.TargetInfo):
        def throwsTargetIndex(self) -> int: ...
    class TypeArgumentTarget(java.lang.classfile.TypeAnnotation.TargetInfo):
        def target(self) -> Label: ...
        def typeArgumentIndex(self) -> int: ...
    class TypeParameterBoundTarget(java.lang.classfile.TypeAnnotation.TargetInfo):
        def boundIndex(self) -> int: ...
        def typeParameterIndex(self) -> int: ...
    class TypeParameterTarget(java.lang.classfile.TypeAnnotation.TargetInfo):
        def typeParameterIndex(self) -> int: ...
    class TypePathComponent:
        ARRAY: typing.ClassVar['TypeAnnotation.TypePathComponent'] = ...
        INNER_TYPE: typing.ClassVar['TypeAnnotation.TypePathComponent'] = ...
        WILDCARD: typing.ClassVar['TypeAnnotation.TypePathComponent'] = ...
        @staticmethod
        def of(kind: 'TypeAnnotation.TypePathComponent.Kind', int: int) -> 'TypeAnnotation.TypePathComponent': ...
        def typeArgumentIndex(self) -> int: ...
        def typePathKind(self) -> 'TypeAnnotation.TypePathComponent.Kind': ...
        class Kind(java.lang.Enum['TypeAnnotation.TypePathComponent.Kind']):
            ARRAY: typing.ClassVar['TypeAnnotation.TypePathComponent.Kind'] = ...
            INNER_TYPE: typing.ClassVar['TypeAnnotation.TypePathComponent.Kind'] = ...
            WILDCARD: typing.ClassVar['TypeAnnotation.TypePathComponent.Kind'] = ...
            TYPE_ARGUMENT: typing.ClassVar['TypeAnnotation.TypePathComponent.Kind'] = ...
            def tag(self) -> int: ...
            _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
            @typing.overload
            @staticmethod
            def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
            @typing.overload
            @staticmethod
            def valueOf(string: str) -> 'TypeAnnotation.TypePathComponent.Kind': ...
            @staticmethod
            def values() -> typing.MutableSequence['TypeAnnotation.TypePathComponent.Kind']: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.lang.classfile")``.

    AccessFlags: typing.Type[AccessFlags]
    Annotation: typing.Type[Annotation]
    AnnotationElement: typing.Type[AnnotationElement]
    AnnotationValue: typing.Type[AnnotationValue]
    Attribute: typing.Type[Attribute]
    AttributeMapper: typing.Type[AttributeMapper]
    AttributedElement: typing.Type[AttributedElement]
    Attributes: typing.Type[Attributes]
    BootstrapMethodEntry: typing.Type[BootstrapMethodEntry]
    BufWriter: typing.Type[BufWriter]
    ClassBuilder: typing.Type[ClassBuilder]
    ClassElement: typing.Type[ClassElement]
    ClassFile: typing.Type[ClassFile]
    ClassFileBuilder: typing.Type[ClassFileBuilder]
    ClassFileElement: typing.Type[ClassFileElement]
    ClassFileTransform: typing.Type[ClassFileTransform]
    ClassFileVersion: typing.Type[ClassFileVersion]
    ClassHierarchyResolver: typing.Type[ClassHierarchyResolver]
    ClassModel: typing.Type[ClassModel]
    ClassReader: typing.Type[ClassReader]
    ClassSignature: typing.Type[ClassSignature]
    ClassTransform: typing.Type[ClassTransform]
    CodeBuilder: typing.Type[CodeBuilder]
    CodeElement: typing.Type[CodeElement]
    CodeModel: typing.Type[CodeModel]
    CodeTransform: typing.Type[CodeTransform]
    CompoundElement: typing.Type[CompoundElement]
    CustomAttribute: typing.Type[CustomAttribute]
    FieldBuilder: typing.Type[FieldBuilder]
    FieldElement: typing.Type[FieldElement]
    FieldModel: typing.Type[FieldModel]
    FieldTransform: typing.Type[FieldTransform]
    Instruction: typing.Type[Instruction]
    Interfaces: typing.Type[Interfaces]
    Label: typing.Type[Label]
    MethodBuilder: typing.Type[MethodBuilder]
    MethodElement: typing.Type[MethodElement]
    MethodModel: typing.Type[MethodModel]
    MethodSignature: typing.Type[MethodSignature]
    MethodTransform: typing.Type[MethodTransform]
    Opcode: typing.Type[Opcode]
    PseudoInstruction: typing.Type[PseudoInstruction]
    Signature: typing.Type[Signature]
    Superclass: typing.Type[Superclass]
    TypeAnnotation: typing.Type[TypeAnnotation]
    TypeKind: typing.Type[TypeKind]
    attribute: java.lang.classfile.attribute.__module_protocol__
    constantpool: java.lang.classfile.constantpool.__module_protocol__
    instruction: java.lang.classfile.instruction.__module_protocol__
