
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.lang.classfile
import java.lang.constant
import java.util
import typing



class ConstantPool(java.lang.Iterable['PoolEntry']):
    def bootstrapMethodCount(self) -> int: ...
    def bootstrapMethodEntry(self, int: int) -> java.lang.classfile.BootstrapMethodEntry: ...
    _entryByIndex_1__T = typing.TypeVar('_entryByIndex_1__T', bound='PoolEntry')  # <T>
    @typing.overload
    def entryByIndex(self, int: int) -> 'PoolEntry': ...
    @typing.overload
    def entryByIndex(self, int: int, class_: typing.Type[_entryByIndex_1__T]) -> _entryByIndex_1__T: ...
    def iterator(self) -> java.util.Iterator['PoolEntry']: ...
    def size(self) -> int: ...

class ConstantPoolException(java.lang.IllegalArgumentException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class PoolEntry:
    TAG_CLASS: typing.ClassVar[int] = ...
    TAG_DOUBLE: typing.ClassVar[int] = ...
    TAG_DYNAMIC: typing.ClassVar[int] = ...
    TAG_FIELDREF: typing.ClassVar[int] = ...
    TAG_FLOAT: typing.ClassVar[int] = ...
    TAG_INTEGER: typing.ClassVar[int] = ...
    TAG_INTERFACE_METHODREF: typing.ClassVar[int] = ...
    TAG_INVOKE_DYNAMIC: typing.ClassVar[int] = ...
    TAG_LONG: typing.ClassVar[int] = ...
    TAG_METHOD_HANDLE: typing.ClassVar[int] = ...
    TAG_METHODREF: typing.ClassVar[int] = ...
    TAG_METHOD_TYPE: typing.ClassVar[int] = ...
    TAG_MODULE: typing.ClassVar[int] = ...
    TAG_NAME_AND_TYPE: typing.ClassVar[int] = ...
    TAG_PACKAGE: typing.ClassVar[int] = ...
    TAG_STRING: typing.ClassVar[int] = ...
    TAG_UTF8: typing.ClassVar[int] = ...
    def constantPool(self) -> ConstantPool: ...
    def index(self) -> int: ...
    def tag(self) -> int: ...
    def width(self) -> int: ...

class AnnotationConstantValueEntry(PoolEntry):
    def constantValue(self) -> java.lang.constant.ConstantDesc: ...

class ConstantPoolBuilder(ConstantPool):
    @typing.overload
    def bsmEntry(self, methodHandleEntry: 'MethodHandleEntry', list: java.util.List['LoadableConstantEntry']) -> java.lang.classfile.BootstrapMethodEntry: ...
    @typing.overload
    def bsmEntry(self, directMethodHandleDesc: java.lang.constant.DirectMethodHandleDesc, list: java.util.List[java.lang.constant.ConstantDesc]) -> java.lang.classfile.BootstrapMethodEntry: ...
    def canWriteDirect(self, constantPool: ConstantPool) -> bool: ...
    @typing.overload
    def classEntry(self, utf8Entry: 'Utf8Entry') -> 'ClassEntry': ...
    @typing.overload
    def classEntry(self, classDesc: java.lang.constant.ClassDesc) -> 'ClassEntry': ...
    @typing.overload
    def constantDynamicEntry(self, bootstrapMethodEntry: java.lang.classfile.BootstrapMethodEntry, nameAndTypeEntry: 'NameAndTypeEntry') -> 'ConstantDynamicEntry': ...
    @typing.overload
    def constantDynamicEntry(self, dynamicConstantDesc: java.lang.constant.DynamicConstantDesc[typing.Any]) -> 'ConstantDynamicEntry': ...
    def constantValueEntry(self, constantDesc: java.lang.constant.ConstantDesc) -> 'ConstantValueEntry': ...
    def doubleEntry(self, double: float) -> 'DoubleEntry': ...
    @typing.overload
    def fieldRefEntry(self, classEntry: 'ClassEntry', nameAndTypeEntry: 'NameAndTypeEntry') -> 'FieldRefEntry': ...
    @typing.overload
    def fieldRefEntry(self, classDesc: java.lang.constant.ClassDesc, string: str, classDesc2: java.lang.constant.ClassDesc) -> 'FieldRefEntry': ...
    def floatEntry(self, float: float) -> 'FloatEntry': ...
    def intEntry(self, int: int) -> 'IntegerEntry': ...
    @typing.overload
    def interfaceMethodRefEntry(self, classEntry: 'ClassEntry', nameAndTypeEntry: 'NameAndTypeEntry') -> 'InterfaceMethodRefEntry': ...
    @typing.overload
    def interfaceMethodRefEntry(self, classDesc: java.lang.constant.ClassDesc, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc) -> 'InterfaceMethodRefEntry': ...
    @typing.overload
    def invokeDynamicEntry(self, bootstrapMethodEntry: java.lang.classfile.BootstrapMethodEntry, nameAndTypeEntry: 'NameAndTypeEntry') -> 'InvokeDynamicEntry': ...
    @typing.overload
    def invokeDynamicEntry(self, dynamicCallSiteDesc: java.lang.constant.DynamicCallSiteDesc) -> 'InvokeDynamicEntry': ...
    def loadableConstantEntry(self, constantDesc: java.lang.constant.ConstantDesc) -> 'LoadableConstantEntry': ...
    def longEntry(self, long: int) -> 'LongEntry': ...
    @typing.overload
    def methodHandleEntry(self, int: int, memberRefEntry: 'MemberRefEntry') -> 'MethodHandleEntry': ...
    @typing.overload
    def methodHandleEntry(self, directMethodHandleDesc: java.lang.constant.DirectMethodHandleDesc) -> 'MethodHandleEntry': ...
    @typing.overload
    def methodRefEntry(self, classEntry: 'ClassEntry', nameAndTypeEntry: 'NameAndTypeEntry') -> 'MethodRefEntry': ...
    @typing.overload
    def methodRefEntry(self, classDesc: java.lang.constant.ClassDesc, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc) -> 'MethodRefEntry': ...
    @typing.overload
    def methodTypeEntry(self, utf8Entry: 'Utf8Entry') -> 'MethodTypeEntry': ...
    @typing.overload
    def methodTypeEntry(self, methodTypeDesc: java.lang.constant.MethodTypeDesc) -> 'MethodTypeEntry': ...
    @typing.overload
    def moduleEntry(self, utf8Entry: 'Utf8Entry') -> 'ModuleEntry': ...
    @typing.overload
    def moduleEntry(self, moduleDesc: java.lang.constant.ModuleDesc) -> 'ModuleEntry': ...
    @typing.overload
    def nameAndTypeEntry(self, utf8Entry: 'Utf8Entry', utf8Entry2: 'Utf8Entry') -> 'NameAndTypeEntry': ...
    @typing.overload
    def nameAndTypeEntry(self, string: str, classDesc: java.lang.constant.ClassDesc) -> 'NameAndTypeEntry': ...
    @typing.overload
    def nameAndTypeEntry(self, string: str, methodTypeDesc: java.lang.constant.MethodTypeDesc) -> 'NameAndTypeEntry': ...
    @typing.overload
    @staticmethod
    def of() -> 'ConstantPoolBuilder': ...
    @typing.overload
    @staticmethod
    def of(classModel: java.lang.classfile.ClassModel) -> 'ConstantPoolBuilder': ...
    @typing.overload
    def packageEntry(self, utf8Entry: 'Utf8Entry') -> 'PackageEntry': ...
    @typing.overload
    def packageEntry(self, packageDesc: java.lang.constant.PackageDesc) -> 'PackageEntry': ...
    @typing.overload
    def stringEntry(self, utf8Entry: 'Utf8Entry') -> 'StringEntry': ...
    @typing.overload
    def stringEntry(self, string: str) -> 'StringEntry': ...
    @typing.overload
    def utf8Entry(self, string: str) -> 'Utf8Entry': ...
    @typing.overload
    def utf8Entry(self, classDesc: java.lang.constant.ClassDesc) -> 'Utf8Entry': ...
    @typing.overload
    def utf8Entry(self, methodTypeDesc: java.lang.constant.MethodTypeDesc) -> 'Utf8Entry': ...

class DynamicConstantPoolEntry(PoolEntry):
    def bootstrap(self) -> java.lang.classfile.BootstrapMethodEntry: ...
    def bootstrapMethodIndex(self) -> int: ...
    def name(self) -> 'Utf8Entry': ...
    def nameAndType(self) -> 'NameAndTypeEntry': ...
    def type(self) -> 'Utf8Entry': ...

class LoadableConstantEntry(PoolEntry):
    def constantValue(self) -> java.lang.constant.ConstantDesc: ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class MemberRefEntry(PoolEntry):
    def name(self) -> 'Utf8Entry': ...
    def nameAndType(self) -> 'NameAndTypeEntry': ...
    def owner(self) -> 'ClassEntry': ...
    def type(self) -> 'Utf8Entry': ...

class ModuleEntry(PoolEntry):
    def asSymbol(self) -> java.lang.constant.ModuleDesc: ...
    def matches(self, moduleDesc: java.lang.constant.ModuleDesc) -> bool: ...
    def name(self) -> 'Utf8Entry': ...

class NameAndTypeEntry(PoolEntry):
    def name(self) -> 'Utf8Entry': ...
    def type(self) -> 'Utf8Entry': ...

class PackageEntry(PoolEntry):
    def asSymbol(self) -> java.lang.constant.PackageDesc: ...
    def matches(self, packageDesc: java.lang.constant.PackageDesc) -> bool: ...
    def name(self) -> 'Utf8Entry': ...

class ClassEntry(LoadableConstantEntry):
    def asInternalName(self) -> str: ...
    def asSymbol(self) -> java.lang.constant.ClassDesc: ...
    def constantValue(self) -> java.lang.constant.ConstantDesc: ...
    def matches(self, classDesc: java.lang.constant.ClassDesc) -> bool: ...
    def name(self) -> 'Utf8Entry': ...

class ConstantDynamicEntry(DynamicConstantPoolEntry, LoadableConstantEntry):
    def asSymbol(self) -> java.lang.constant.DynamicConstantDesc[typing.Any]: ...
    def constantValue(self) -> java.lang.constant.ConstantDesc: ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...
    def typeSymbol(self) -> java.lang.constant.ClassDesc: ...

class ConstantValueEntry(LoadableConstantEntry):
    def constantValue(self) -> java.lang.constant.ConstantDesc: ...

class FieldRefEntry(MemberRefEntry):
    def typeSymbol(self) -> java.lang.constant.ClassDesc: ...

class InterfaceMethodRefEntry(MemberRefEntry):
    def typeSymbol(self) -> java.lang.constant.MethodTypeDesc: ...

class InvokeDynamicEntry(DynamicConstantPoolEntry):
    def asSymbol(self) -> java.lang.constant.DynamicCallSiteDesc: ...
    def typeSymbol(self) -> java.lang.constant.MethodTypeDesc: ...

class MethodHandleEntry(LoadableConstantEntry):
    def asSymbol(self) -> java.lang.constant.DirectMethodHandleDesc: ...
    def constantValue(self) -> java.lang.constant.ConstantDesc: ...
    def kind(self) -> int: ...
    def reference(self) -> MemberRefEntry: ...

class MethodRefEntry(MemberRefEntry):
    def typeSymbol(self) -> java.lang.constant.MethodTypeDesc: ...

class MethodTypeEntry(LoadableConstantEntry):
    def asSymbol(self) -> java.lang.constant.MethodTypeDesc: ...
    def constantValue(self) -> java.lang.constant.ConstantDesc: ...
    def descriptor(self) -> 'Utf8Entry': ...
    def matches(self, methodTypeDesc: java.lang.constant.MethodTypeDesc) -> bool: ...

class Utf8Entry(java.lang.CharSequence, AnnotationConstantValueEntry):
    def equalsString(self, string: str) -> bool: ...
    def isFieldType(self, classDesc: java.lang.constant.ClassDesc) -> bool: ...
    def isMethodType(self, methodTypeDesc: java.lang.constant.MethodTypeDesc) -> bool: ...
    def stringValue(self) -> str: ...
    def toString(self) -> str: ...

class DoubleEntry(AnnotationConstantValueEntry, ConstantValueEntry):
    def doubleValue(self) -> float: ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class FloatEntry(AnnotationConstantValueEntry, ConstantValueEntry):
    def floatValue(self) -> float: ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class IntegerEntry(AnnotationConstantValueEntry, ConstantValueEntry):
    def intValue(self) -> int: ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class LongEntry(AnnotationConstantValueEntry, ConstantValueEntry):
    def longValue(self) -> int: ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class StringEntry(ConstantValueEntry):
    def equalsString(self, string: str) -> bool: ...
    def stringValue(self) -> str: ...
    def utf8(self) -> Utf8Entry: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.lang.classfile.constantpool")``.

    AnnotationConstantValueEntry: typing.Type[AnnotationConstantValueEntry]
    ClassEntry: typing.Type[ClassEntry]
    ConstantDynamicEntry: typing.Type[ConstantDynamicEntry]
    ConstantPool: typing.Type[ConstantPool]
    ConstantPoolBuilder: typing.Type[ConstantPoolBuilder]
    ConstantPoolException: typing.Type[ConstantPoolException]
    ConstantValueEntry: typing.Type[ConstantValueEntry]
    DoubleEntry: typing.Type[DoubleEntry]
    DynamicConstantPoolEntry: typing.Type[DynamicConstantPoolEntry]
    FieldRefEntry: typing.Type[FieldRefEntry]
    FloatEntry: typing.Type[FloatEntry]
    IntegerEntry: typing.Type[IntegerEntry]
    InterfaceMethodRefEntry: typing.Type[InterfaceMethodRefEntry]
    InvokeDynamicEntry: typing.Type[InvokeDynamicEntry]
    LoadableConstantEntry: typing.Type[LoadableConstantEntry]
    LongEntry: typing.Type[LongEntry]
    MemberRefEntry: typing.Type[MemberRefEntry]
    MethodHandleEntry: typing.Type[MethodHandleEntry]
    MethodRefEntry: typing.Type[MethodRefEntry]
    MethodTypeEntry: typing.Type[MethodTypeEntry]
    ModuleEntry: typing.Type[ModuleEntry]
    NameAndTypeEntry: typing.Type[NameAndTypeEntry]
    PackageEntry: typing.Type[PackageEntry]
    PoolEntry: typing.Type[PoolEntry]
    StringEntry: typing.Type[StringEntry]
    Utf8Entry: typing.Type[Utf8Entry]
