
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java
import java.lang.classfile
import java.lang.classfile.constantpool
import java.lang.constant
import java.util
import typing



class ArrayLoadInstruction(java.lang.classfile.Instruction):
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode) -> 'ArrayLoadInstruction': ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class ArrayStoreInstruction(java.lang.classfile.Instruction):
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode) -> 'ArrayStoreInstruction': ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class BranchInstruction(java.lang.classfile.Instruction):
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode, label: java.lang.classfile.Label) -> 'BranchInstruction': ...
    def target(self) -> java.lang.classfile.Label: ...

class CharacterRange(java.lang.classfile.PseudoInstruction):
    FLAG_STATEMENT: typing.ClassVar[int] = ...
    FLAG_BLOCK: typing.ClassVar[int] = ...
    FLAG_ASSIGNMENT: typing.ClassVar[int] = ...
    FLAG_FLOW_CONTROLLER: typing.ClassVar[int] = ...
    FLAG_FLOW_TARGET: typing.ClassVar[int] = ...
    FLAG_INVOKE: typing.ClassVar[int] = ...
    FLAG_CREATE: typing.ClassVar[int] = ...
    FLAG_BRANCH_TRUE: typing.ClassVar[int] = ...
    FLAG_BRANCH_FALSE: typing.ClassVar[int] = ...
    def characterRangeEnd(self) -> int: ...
    def characterRangeStart(self) -> int: ...
    def endScope(self) -> java.lang.classfile.Label: ...
    def flags(self) -> int: ...
    @staticmethod
    def of(label: java.lang.classfile.Label, label2: java.lang.classfile.Label, int: int, int2: int, int3: int) -> 'CharacterRange': ...
    def startScope(self) -> java.lang.classfile.Label: ...

class ConvertInstruction(java.lang.classfile.Instruction):
    def fromType(self) -> java.lang.classfile.TypeKind: ...
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode) -> 'ConvertInstruction': ...
    @typing.overload
    @staticmethod
    def of(typeKind: java.lang.classfile.TypeKind, typeKind2: java.lang.classfile.TypeKind) -> 'ConvertInstruction': ...
    def toType(self) -> java.lang.classfile.TypeKind: ...

class ExceptionCatch(java.lang.classfile.PseudoInstruction):
    def catchType(self) -> java.util.Optional[java.lang.classfile.constantpool.ClassEntry]: ...
    def handler(self) -> java.lang.classfile.Label: ...
    @typing.overload
    @staticmethod
    def of(label: java.lang.classfile.Label, label2: java.lang.classfile.Label, label3: java.lang.classfile.Label) -> 'ExceptionCatch': ...
    @typing.overload
    @staticmethod
    def of(label: java.lang.classfile.Label, label2: java.lang.classfile.Label, label3: java.lang.classfile.Label, optional: java.util.Optional[java.lang.classfile.constantpool.ClassEntry]) -> 'ExceptionCatch': ...
    def tryEnd(self) -> java.lang.classfile.Label: ...
    def tryStart(self) -> java.lang.classfile.Label: ...

class FieldInstruction(java.lang.classfile.Instruction):
    def field(self) -> java.lang.classfile.constantpool.FieldRefEntry: ...
    def name(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode, classEntry: java.lang.classfile.constantpool.ClassEntry, nameAndTypeEntry: java.lang.classfile.constantpool.NameAndTypeEntry) -> 'FieldInstruction': ...
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode, classEntry: java.lang.classfile.constantpool.ClassEntry, utf8Entry: java.lang.classfile.constantpool.Utf8Entry, utf8Entry2: java.lang.classfile.constantpool.Utf8Entry) -> 'FieldInstruction': ...
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode, fieldRefEntry: java.lang.classfile.constantpool.FieldRefEntry) -> 'FieldInstruction': ...
    def owner(self) -> java.lang.classfile.constantpool.ClassEntry: ...
    def type(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    def typeSymbol(self) -> java.lang.constant.ClassDesc: ...

class IncrementInstruction(java.lang.classfile.Instruction):
    def constant(self) -> int: ...
    @staticmethod
    def of(int: int, int2: int) -> 'IncrementInstruction': ...
    def slot(self) -> int: ...

class InvokeDynamicInstruction(java.lang.classfile.Instruction):
    def bootstrapArgs(self) -> java.util.List[java.lang.constant.ConstantDesc]: ...
    def bootstrapMethod(self) -> java.lang.constant.DirectMethodHandleDesc: ...
    def invokedynamic(self) -> java.lang.classfile.constantpool.InvokeDynamicEntry: ...
    def name(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    @staticmethod
    def of(invokeDynamicEntry: java.lang.classfile.constantpool.InvokeDynamicEntry) -> 'InvokeDynamicInstruction': ...
    def type(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    def typeSymbol(self) -> java.lang.constant.MethodTypeDesc: ...

class InvokeInstruction(java.lang.classfile.Instruction):
    def count(self) -> int: ...
    def isInterface(self) -> bool: ...
    def method(self) -> java.lang.classfile.constantpool.MemberRefEntry: ...
    def name(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode, classEntry: java.lang.classfile.constantpool.ClassEntry, nameAndTypeEntry: java.lang.classfile.constantpool.NameAndTypeEntry, boolean: bool) -> 'InvokeInstruction': ...
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode, classEntry: java.lang.classfile.constantpool.ClassEntry, utf8Entry: java.lang.classfile.constantpool.Utf8Entry, utf8Entry2: java.lang.classfile.constantpool.Utf8Entry, boolean: bool) -> 'InvokeInstruction': ...
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode, memberRefEntry: java.lang.classfile.constantpool.MemberRefEntry) -> 'InvokeInstruction': ...
    def owner(self) -> java.lang.classfile.constantpool.ClassEntry: ...
    def type(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    def typeSymbol(self) -> java.lang.constant.MethodTypeDesc: ...

class LabelTarget(java.lang.classfile.PseudoInstruction):
    def label(self) -> java.lang.classfile.Label: ...

class LineNumber(java.lang.classfile.PseudoInstruction):
    def line(self) -> int: ...
    @staticmethod
    def of(int: int) -> 'LineNumber': ...

class LoadInstruction(java.lang.classfile.Instruction):
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode, int: int) -> 'LoadInstruction': ...
    @typing.overload
    @staticmethod
    def of(typeKind: java.lang.classfile.TypeKind, int: int) -> 'LoadInstruction': ...
    def slot(self) -> int: ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class LocalVariable(java.lang.classfile.PseudoInstruction):
    def endScope(self) -> java.lang.classfile.Label: ...
    def name(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    @typing.overload
    @staticmethod
    def of(int: int, string: str, classDesc: java.lang.constant.ClassDesc, label: java.lang.classfile.Label, label2: java.lang.classfile.Label) -> 'LocalVariable': ...
    @typing.overload
    @staticmethod
    def of(int: int, utf8Entry: java.lang.classfile.constantpool.Utf8Entry, utf8Entry2: java.lang.classfile.constantpool.Utf8Entry, label: java.lang.classfile.Label, label2: java.lang.classfile.Label) -> 'LocalVariable': ...
    def slot(self) -> int: ...
    def startScope(self) -> java.lang.classfile.Label: ...
    def type(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    def typeSymbol(self) -> java.lang.constant.ClassDesc: ...

class LocalVariableType(java.lang.classfile.PseudoInstruction):
    def endScope(self) -> java.lang.classfile.Label: ...
    def name(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    @typing.overload
    @staticmethod
    def of(int: int, string: str, signature: java.lang.classfile.Signature, label: java.lang.classfile.Label, label2: java.lang.classfile.Label) -> 'LocalVariableType': ...
    @typing.overload
    @staticmethod
    def of(int: int, utf8Entry: java.lang.classfile.constantpool.Utf8Entry, utf8Entry2: java.lang.classfile.constantpool.Utf8Entry, label: java.lang.classfile.Label, label2: java.lang.classfile.Label) -> 'LocalVariableType': ...
    def signature(self) -> java.lang.classfile.constantpool.Utf8Entry: ...
    def signatureSymbol(self) -> java.lang.classfile.Signature: ...
    def slot(self) -> int: ...
    def startScope(self) -> java.lang.classfile.Label: ...

class LookupSwitchInstruction(java.lang.classfile.Instruction):
    def cases(self) -> java.util.List['SwitchCase']: ...
    def defaultTarget(self) -> java.lang.classfile.Label: ...
    @staticmethod
    def of(label: java.lang.classfile.Label, list: java.util.List['SwitchCase']) -> 'LookupSwitchInstruction': ...

class MonitorInstruction(java.lang.classfile.Instruction):
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode) -> 'MonitorInstruction': ...

class NewMultiArrayInstruction(java.lang.classfile.Instruction):
    def arrayType(self) -> java.lang.classfile.constantpool.ClassEntry: ...
    def dimensions(self) -> int: ...
    @staticmethod
    def of(classEntry: java.lang.classfile.constantpool.ClassEntry, int: int) -> 'NewMultiArrayInstruction': ...

class NewObjectInstruction(java.lang.classfile.Instruction):
    def className(self) -> java.lang.classfile.constantpool.ClassEntry: ...
    @staticmethod
    def of(classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'NewObjectInstruction': ...

class NewPrimitiveArrayInstruction(java.lang.classfile.Instruction):
    @staticmethod
    def of(typeKind: java.lang.classfile.TypeKind) -> 'NewPrimitiveArrayInstruction': ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class NewReferenceArrayInstruction(java.lang.classfile.Instruction):
    def componentType(self) -> java.lang.classfile.constantpool.ClassEntry: ...
    @staticmethod
    def of(classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'NewReferenceArrayInstruction': ...

class NopInstruction(java.lang.classfile.Instruction):
    @staticmethod
    def of() -> 'NopInstruction': ...

class OperatorInstruction(java.lang.classfile.Instruction):
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode) -> 'OperatorInstruction': ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class ReturnInstruction(java.lang.classfile.Instruction):
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode) -> 'ReturnInstruction': ...
    @typing.overload
    @staticmethod
    def of(typeKind: java.lang.classfile.TypeKind) -> 'ReturnInstruction': ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class StackInstruction(java.lang.classfile.Instruction):
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode) -> 'StackInstruction': ...

class StoreInstruction(java.lang.classfile.Instruction):
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode, int: int) -> 'StoreInstruction': ...
    @typing.overload
    @staticmethod
    def of(typeKind: java.lang.classfile.TypeKind, int: int) -> 'StoreInstruction': ...
    def slot(self) -> int: ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...

class SwitchCase:
    def caseValue(self) -> int: ...
    @staticmethod
    def of(int: int, label: java.lang.classfile.Label) -> 'SwitchCase': ...
    def target(self) -> java.lang.classfile.Label: ...

class TableSwitchInstruction(java.lang.classfile.Instruction):
    def cases(self) -> java.util.List[SwitchCase]: ...
    def defaultTarget(self) -> java.lang.classfile.Label: ...
    def highValue(self) -> int: ...
    def lowValue(self) -> int: ...
    @staticmethod
    def of(int: int, int2: int, label: java.lang.classfile.Label, list: java.util.List[SwitchCase]) -> 'TableSwitchInstruction': ...

class ThrowInstruction(java.lang.classfile.Instruction):
    @staticmethod
    def of() -> 'ThrowInstruction': ...

class TypeCheckInstruction(java.lang.classfile.Instruction):
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode, classEntry: java.lang.classfile.constantpool.ClassEntry) -> 'TypeCheckInstruction': ...
    @typing.overload
    @staticmethod
    def of(opcode: java.lang.classfile.Opcode, classDesc: java.lang.constant.ClassDesc) -> 'TypeCheckInstruction': ...
    def type(self) -> java.lang.classfile.constantpool.ClassEntry: ...

class ConstantInstruction(java.lang.classfile.Instruction):
    def constantValue(self) -> java.lang.constant.ConstantDesc: ...
    @staticmethod
    def ofArgument(opcode: java.lang.classfile.Opcode, int: int) -> 'ConstantInstruction.ArgumentConstantInstruction': ...
    @staticmethod
    def ofIntrinsic(opcode: java.lang.classfile.Opcode) -> 'ConstantInstruction.IntrinsicConstantInstruction': ...
    @staticmethod
    def ofLoad(opcode: java.lang.classfile.Opcode, loadableConstantEntry: java.lang.classfile.constantpool.LoadableConstantEntry) -> 'ConstantInstruction.LoadConstantInstruction': ...
    def typeKind(self) -> java.lang.classfile.TypeKind: ...
    class ArgumentConstantInstruction(java.lang.classfile.instruction.ConstantInstruction):
        def constantValue(self) -> int: ...
        def typeKind(self) -> java.lang.classfile.TypeKind: ...
    class IntrinsicConstantInstruction(java.lang.classfile.instruction.ConstantInstruction):
        def typeKind(self) -> java.lang.classfile.TypeKind: ...
    class LoadConstantInstruction(java.lang.classfile.instruction.ConstantInstruction):
        def constantEntry(self) -> java.lang.classfile.constantpool.LoadableConstantEntry: ...
        def typeKind(self) -> java.lang.classfile.TypeKind: ...

class DiscontinuedInstruction(java.lang.classfile.Instruction):
    class JsrInstruction(java.lang.classfile.instruction.DiscontinuedInstruction):
        @typing.overload
        @staticmethod
        def of(label: java.lang.classfile.Label) -> 'DiscontinuedInstruction.JsrInstruction': ...
        @typing.overload
        @staticmethod
        def of(opcode: java.lang.classfile.Opcode, label: java.lang.classfile.Label) -> 'DiscontinuedInstruction.JsrInstruction': ...
        def target(self) -> java.lang.classfile.Label: ...
    class RetInstruction(java.lang.classfile.instruction.DiscontinuedInstruction):
        @typing.overload
        @staticmethod
        def of(int: int) -> 'DiscontinuedInstruction.RetInstruction': ...
        @typing.overload
        @staticmethod
        def of(opcode: java.lang.classfile.Opcode, int: int) -> 'DiscontinuedInstruction.RetInstruction': ...
        def slot(self) -> int: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.lang.classfile.instruction")``.

    ArrayLoadInstruction: typing.Type[ArrayLoadInstruction]
    ArrayStoreInstruction: typing.Type[ArrayStoreInstruction]
    BranchInstruction: typing.Type[BranchInstruction]
    CharacterRange: typing.Type[CharacterRange]
    ConstantInstruction: typing.Type[ConstantInstruction]
    ConvertInstruction: typing.Type[ConvertInstruction]
    DiscontinuedInstruction: typing.Type[DiscontinuedInstruction]
    ExceptionCatch: typing.Type[ExceptionCatch]
    FieldInstruction: typing.Type[FieldInstruction]
    IncrementInstruction: typing.Type[IncrementInstruction]
    InvokeDynamicInstruction: typing.Type[InvokeDynamicInstruction]
    InvokeInstruction: typing.Type[InvokeInstruction]
    LabelTarget: typing.Type[LabelTarget]
    LineNumber: typing.Type[LineNumber]
    LoadInstruction: typing.Type[LoadInstruction]
    LocalVariable: typing.Type[LocalVariable]
    LocalVariableType: typing.Type[LocalVariableType]
    LookupSwitchInstruction: typing.Type[LookupSwitchInstruction]
    MonitorInstruction: typing.Type[MonitorInstruction]
    NewMultiArrayInstruction: typing.Type[NewMultiArrayInstruction]
    NewObjectInstruction: typing.Type[NewObjectInstruction]
    NewPrimitiveArrayInstruction: typing.Type[NewPrimitiveArrayInstruction]
    NewReferenceArrayInstruction: typing.Type[NewReferenceArrayInstruction]
    NopInstruction: typing.Type[NopInstruction]
    OperatorInstruction: typing.Type[OperatorInstruction]
    ReturnInstruction: typing.Type[ReturnInstruction]
    StackInstruction: typing.Type[StackInstruction]
    StoreInstruction: typing.Type[StoreInstruction]
    SwitchCase: typing.Type[SwitchCase]
    TableSwitchInstruction: typing.Type[TableSwitchInstruction]
    ThrowInstruction: typing.Type[ThrowInstruction]
    TypeCheckInstruction: typing.Type[TypeCheckInstruction]
