
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

from jpype.protocol import _JBigDecimal
import decimal
import java.io
import java.lang
import java.util
import jpype
import typing



class BigDecimal(java.lang.Number, java.lang.Comparable['BigDecimal'], _JBigDecimal):
    ZERO: typing.ClassVar['BigDecimal'] = ...
    ONE: typing.ClassVar['BigDecimal'] = ...
    TWO: typing.ClassVar['BigDecimal'] = ...
    TEN: typing.ClassVar['BigDecimal'] = ...
    ROUND_UP: typing.ClassVar[int] = ...
    ROUND_DOWN: typing.ClassVar[int] = ...
    ROUND_CEILING: typing.ClassVar[int] = ...
    ROUND_FLOOR: typing.ClassVar[int] = ...
    ROUND_HALF_UP: typing.ClassVar[int] = ...
    ROUND_HALF_DOWN: typing.ClassVar[int] = ...
    ROUND_HALF_EVEN: typing.ClassVar[int] = ...
    ROUND_UNNECESSARY: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, charArray: typing.Union[typing.List[str], jpype.JArray]): ...
    @typing.overload
    def __init__(self, charArray: typing.Union[typing.List[str], jpype.JArray], int: int, int2: int): ...
    @typing.overload
    def __init__(self, charArray: typing.Union[typing.List[str], jpype.JArray], int: int, int2: int, mathContext: 'MathContext'): ...
    @typing.overload
    def __init__(self, charArray: typing.Union[typing.List[str], jpype.JArray], mathContext: 'MathContext'): ...
    @typing.overload
    def __init__(self, double: float): ...
    @typing.overload
    def __init__(self, double: float, mathContext: 'MathContext'): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, int: int, mathContext: 'MathContext'): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, mathContext: 'MathContext'): ...
    @typing.overload
    def __init__(self, bigInteger: 'BigInteger'): ...
    @typing.overload
    def __init__(self, bigInteger: 'BigInteger', int: int): ...
    @typing.overload
    def __init__(self, bigInteger: 'BigInteger', int: int, mathContext: 'MathContext'): ...
    @typing.overload
    def __init__(self, bigInteger: 'BigInteger', mathContext: 'MathContext'): ...
    @typing.overload
    def __init__(self, long: int): ...
    @typing.overload
    def __init__(self, long: int, mathContext: 'MathContext'): ...
    @typing.overload
    def abs(self) -> 'BigDecimal': ...
    @typing.overload
    def abs(self, mathContext: 'MathContext') -> 'BigDecimal': ...
    @typing.overload
    def add(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal]) -> 'BigDecimal': ...
    @typing.overload
    def add(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal], mathContext: 'MathContext') -> 'BigDecimal': ...
    def byteValueExact(self) -> int: ...
    def compareTo(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal]) -> int: ...
    @typing.overload
    def divide(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal]) -> 'BigDecimal': ...
    @typing.overload
    def divide(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal], int: int) -> 'BigDecimal': ...
    @typing.overload
    def divide(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal], int: int, int2: int) -> 'BigDecimal': ...
    @typing.overload
    def divide(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal], int: int, roundingMode: 'RoundingMode') -> 'BigDecimal': ...
    @typing.overload
    def divide(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal], mathContext: 'MathContext') -> 'BigDecimal': ...
    @typing.overload
    def divide(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal], roundingMode: 'RoundingMode') -> 'BigDecimal': ...
    @typing.overload
    def divideAndRemainder(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal]) -> typing.MutableSequence['BigDecimal']: ...
    @typing.overload
    def divideAndRemainder(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal], mathContext: 'MathContext') -> typing.MutableSequence['BigDecimal']: ...
    @typing.overload
    def divideToIntegralValue(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal]) -> 'BigDecimal': ...
    @typing.overload
    def divideToIntegralValue(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal], mathContext: 'MathContext') -> 'BigDecimal': ...
    def doubleValue(self) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def floatValue(self) -> float: ...
    def hashCode(self) -> int: ...
    def intValue(self) -> int: ...
    def intValueExact(self) -> int: ...
    def longValue(self) -> int: ...
    def longValueExact(self) -> int: ...
    def max(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal]) -> 'BigDecimal': ...
    def min(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal]) -> 'BigDecimal': ...
    def movePointLeft(self, int: int) -> 'BigDecimal': ...
    def movePointRight(self, int: int) -> 'BigDecimal': ...
    @typing.overload
    def multiply(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal]) -> 'BigDecimal': ...
    @typing.overload
    def multiply(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal], mathContext: 'MathContext') -> 'BigDecimal': ...
    @typing.overload
    def negate(self) -> 'BigDecimal': ...
    @typing.overload
    def negate(self, mathContext: 'MathContext') -> 'BigDecimal': ...
    @typing.overload
    def plus(self) -> 'BigDecimal': ...
    @typing.overload
    def plus(self, mathContext: 'MathContext') -> 'BigDecimal': ...
    @typing.overload
    def pow(self, int: int) -> 'BigDecimal': ...
    @typing.overload
    def pow(self, int: int, mathContext: 'MathContext') -> 'BigDecimal': ...
    def precision(self) -> int: ...
    @typing.overload
    def remainder(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal]) -> 'BigDecimal': ...
    @typing.overload
    def remainder(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal], mathContext: 'MathContext') -> 'BigDecimal': ...
    def round(self, mathContext: 'MathContext') -> 'BigDecimal': ...
    def scale(self) -> int: ...
    def scaleByPowerOfTen(self, int: int) -> 'BigDecimal': ...
    @typing.overload
    def setScale(self, int: int) -> 'BigDecimal': ...
    @typing.overload
    def setScale(self, int: int, int2: int) -> 'BigDecimal': ...
    @typing.overload
    def setScale(self, int: int, roundingMode: 'RoundingMode') -> 'BigDecimal': ...
    def shortValueExact(self) -> int: ...
    def signum(self) -> int: ...
    def sqrt(self, mathContext: 'MathContext') -> 'BigDecimal': ...
    def stripTrailingZeros(self) -> 'BigDecimal': ...
    @typing.overload
    def subtract(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal]) -> 'BigDecimal': ...
    @typing.overload
    def subtract(self, bigDecimal: typing.Union['BigDecimal', decimal.Decimal], mathContext: 'MathContext') -> 'BigDecimal': ...
    def toBigInteger(self) -> 'BigInteger': ...
    def toBigIntegerExact(self) -> 'BigInteger': ...
    def toEngineeringString(self) -> str: ...
    def toPlainString(self) -> str: ...
    def toString(self) -> str: ...
    def ulp(self) -> 'BigDecimal': ...
    def unscaledValue(self) -> 'BigInteger': ...
    @typing.overload
    @staticmethod
    def valueOf(double: float) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def valueOf(long: int) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def valueOf(long: int, int: int) -> 'BigDecimal': ...

class BigInteger(java.lang.Number, java.lang.Comparable['BigInteger']):
    ZERO: typing.ClassVar['BigInteger'] = ...
    ONE: typing.ClassVar['BigInteger'] = ...
    TWO: typing.ClassVar['BigInteger'] = ...
    TEN: typing.ClassVar['BigInteger'] = ...
    @typing.overload
    def __init__(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]): ...
    @typing.overload
    def __init__(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes], int: int, int2: int): ...
    @typing.overload
    def __init__(self, int: int, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]): ...
    @typing.overload
    def __init__(self, int: int, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes], int2: int, int3: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int, random: java.util.Random): ...
    @typing.overload
    def __init__(self, int: int, random: java.util.Random): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, int: int): ...
    def abs(self) -> 'BigInteger': ...
    def add(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def andNot(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def and_(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def bitCount(self) -> int: ...
    def bitLength(self) -> int: ...
    def byteValueExact(self) -> int: ...
    def clearBit(self, int: int) -> 'BigInteger': ...
    def compareTo(self, bigInteger: 'BigInteger') -> int: ...
    def divide(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def divideAndRemainder(self, bigInteger: 'BigInteger') -> typing.MutableSequence['BigInteger']: ...
    def doubleValue(self) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def flipBit(self, int: int) -> 'BigInteger': ...
    def floatValue(self) -> float: ...
    def gcd(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def getLowestSetBit(self) -> int: ...
    def hashCode(self) -> int: ...
    def intValue(self) -> int: ...
    def intValueExact(self) -> int: ...
    def isProbablePrime(self, int: int) -> bool: ...
    def longValue(self) -> int: ...
    def longValueExact(self) -> int: ...
    def max(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def min(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def mod(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def modInverse(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def modPow(self, bigInteger: 'BigInteger', bigInteger2: 'BigInteger') -> 'BigInteger': ...
    def multiply(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def negate(self) -> 'BigInteger': ...
    def nextProbablePrime(self) -> 'BigInteger': ...
    def not_(self) -> 'BigInteger': ...
    def or_(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def parallelMultiply(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def pow(self, int: int) -> 'BigInteger': ...
    @staticmethod
    def probablePrime(int: int, random: java.util.Random) -> 'BigInteger': ...
    def remainder(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def setBit(self, int: int) -> 'BigInteger': ...
    def shiftLeft(self, int: int) -> 'BigInteger': ...
    def shiftRight(self, int: int) -> 'BigInteger': ...
    def shortValueExact(self) -> int: ...
    def signum(self) -> int: ...
    def sqrt(self) -> 'BigInteger': ...
    def sqrtAndRemainder(self) -> typing.MutableSequence['BigInteger']: ...
    def subtract(self, bigInteger: 'BigInteger') -> 'BigInteger': ...
    def testBit(self, int: int) -> bool: ...
    def toByteArray(self) -> typing.MutableSequence[int]: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    def toString(self, int: int) -> str: ...
    @staticmethod
    def valueOf(long: int) -> 'BigInteger': ...
    def xor(self, bigInteger: 'BigInteger') -> 'BigInteger': ...

class MathContext(java.io.Serializable):
    UNLIMITED: typing.ClassVar['MathContext'] = ...
    DECIMAL32: typing.ClassVar['MathContext'] = ...
    DECIMAL64: typing.ClassVar['MathContext'] = ...
    DECIMAL128: typing.ClassVar['MathContext'] = ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, int: int, roundingMode: 'RoundingMode'): ...
    @typing.overload
    def __init__(self, string: str): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getPrecision(self) -> int: ...
    def getRoundingMode(self) -> 'RoundingMode': ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class RoundingMode(java.lang.Enum['RoundingMode']):
    UP: typing.ClassVar['RoundingMode'] = ...
    DOWN: typing.ClassVar['RoundingMode'] = ...
    CEILING: typing.ClassVar['RoundingMode'] = ...
    FLOOR: typing.ClassVar['RoundingMode'] = ...
    HALF_UP: typing.ClassVar['RoundingMode'] = ...
    HALF_DOWN: typing.ClassVar['RoundingMode'] = ...
    HALF_EVEN: typing.ClassVar['RoundingMode'] = ...
    UNNECESSARY: typing.ClassVar['RoundingMode'] = ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(int: int) -> 'RoundingMode': ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'RoundingMode': ...
    @staticmethod
    def values() -> typing.MutableSequence['RoundingMode']: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.math")``.

    BigDecimal: typing.Type[BigDecimal]
    BigInteger: typing.Type[BigInteger]
    MathContext: typing.Type[MathContext]
    RoundingMode: typing.Type[RoundingMode]
