
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.math
import java.security
import java.security.interfaces
import java.util
import jpype
import typing



class AlgorithmParameterSpec: ...

class ECField:
    def getFieldSize(self) -> int: ...

class ECPoint:
    POINT_INFINITY: typing.ClassVar['ECPoint'] = ...
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getAffineX(self) -> java.math.BigInteger: ...
    def getAffineY(self) -> java.math.BigInteger: ...
    def hashCode(self) -> int: ...

class EdECPoint:
    def __init__(self, boolean: bool, bigInteger: java.math.BigInteger): ...
    def getY(self) -> java.math.BigInteger: ...
    def isXOdd(self) -> bool: ...

class EllipticCurve:
    @typing.overload
    def __init__(self, eCField: typing.Union[ECField, typing.Callable], bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger): ...
    @typing.overload
    def __init__(self, eCField: typing.Union[ECField, typing.Callable], bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getA(self) -> java.math.BigInteger: ...
    def getB(self) -> java.math.BigInteger: ...
    def getField(self) -> ECField: ...
    def getSeed(self) -> typing.MutableSequence[int]: ...
    def hashCode(self) -> int: ...

class InvalidKeySpecException(java.security.GeneralSecurityException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class InvalidParameterSpecException(java.security.GeneralSecurityException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class KeySpec: ...

class RSAOtherPrimeInfo:
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger, bigInteger3: java.math.BigInteger): ...
    def getCrtCoefficient(self) -> java.math.BigInteger: ...
    def getExponent(self) -> java.math.BigInteger: ...
    def getPrime(self) -> java.math.BigInteger: ...

class DSAGenParameterSpec(AlgorithmParameterSpec):
    @typing.overload
    def __init__(self, int: int, int2: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int, int3: int): ...
    def getPrimePLength(self) -> int: ...
    def getSeedLength(self) -> int: ...
    def getSubprimeQLength(self) -> int: ...

class DSAParameterSpec(AlgorithmParameterSpec, java.security.interfaces.DSAParams):
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger, bigInteger3: java.math.BigInteger): ...
    def getG(self) -> java.math.BigInteger: ...
    def getP(self) -> java.math.BigInteger: ...
    def getQ(self) -> java.math.BigInteger: ...

class DSAPrivateKeySpec(KeySpec):
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger, bigInteger3: java.math.BigInteger, bigInteger4: java.math.BigInteger): ...
    def getG(self) -> java.math.BigInteger: ...
    def getP(self) -> java.math.BigInteger: ...
    def getQ(self) -> java.math.BigInteger: ...
    def getX(self) -> java.math.BigInteger: ...

class DSAPublicKeySpec(KeySpec):
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger, bigInteger3: java.math.BigInteger, bigInteger4: java.math.BigInteger): ...
    def getG(self) -> java.math.BigInteger: ...
    def getP(self) -> java.math.BigInteger: ...
    def getQ(self) -> java.math.BigInteger: ...
    def getY(self) -> java.math.BigInteger: ...

class ECFieldF2m(ECField):
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, int: int, intArray: typing.Union[typing.List[int], jpype.JArray]): ...
    @typing.overload
    def __init__(self, int: int, bigInteger: java.math.BigInteger): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getFieldSize(self) -> int: ...
    def getM(self) -> int: ...
    def getMidTermsOfReductionPolynomial(self) -> typing.MutableSequence[int]: ...
    def getReductionPolynomial(self) -> java.math.BigInteger: ...
    def hashCode(self) -> int: ...

class ECFieldFp(ECField):
    def __init__(self, bigInteger: java.math.BigInteger): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getFieldSize(self) -> int: ...
    def getP(self) -> java.math.BigInteger: ...
    def hashCode(self) -> int: ...

class ECParameterSpec(AlgorithmParameterSpec):
    def __init__(self, ellipticCurve: EllipticCurve, eCPoint: ECPoint, bigInteger: java.math.BigInteger, int: int): ...
    def getCofactor(self) -> int: ...
    def getCurve(self) -> EllipticCurve: ...
    def getGenerator(self) -> ECPoint: ...
    def getOrder(self) -> java.math.BigInteger: ...

class ECPrivateKeySpec(KeySpec):
    def __init__(self, bigInteger: java.math.BigInteger, eCParameterSpec: ECParameterSpec): ...
    def getParams(self) -> ECParameterSpec: ...
    def getS(self) -> java.math.BigInteger: ...

class ECPublicKeySpec(KeySpec):
    def __init__(self, eCPoint: ECPoint, eCParameterSpec: ECParameterSpec): ...
    def getParams(self) -> ECParameterSpec: ...
    def getW(self) -> ECPoint: ...

class EdDSAParameterSpec(AlgorithmParameterSpec):
    @typing.overload
    def __init__(self, boolean: bool): ...
    @typing.overload
    def __init__(self, boolean: bool, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]): ...
    def getContext(self) -> java.util.Optional[typing.MutableSequence[int]]: ...
    def isPrehash(self) -> bool: ...

class EdECPrivateKeySpec(KeySpec):
    def __init__(self, namedParameterSpec: 'NamedParameterSpec', byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]): ...
    def getBytes(self) -> typing.MutableSequence[int]: ...
    def getParams(self) -> 'NamedParameterSpec': ...

class EdECPublicKeySpec(KeySpec):
    def __init__(self, namedParameterSpec: 'NamedParameterSpec', edECPoint: EdECPoint): ...
    def getParams(self) -> 'NamedParameterSpec': ...
    def getPoint(self) -> EdECPoint: ...

class EncodedKeySpec(KeySpec):
    def __init__(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]): ...
    def getAlgorithm(self) -> str: ...
    def getEncoded(self) -> typing.MutableSequence[int]: ...
    def getFormat(self) -> str: ...

class MGF1ParameterSpec(AlgorithmParameterSpec):
    SHA1: typing.ClassVar['MGF1ParameterSpec'] = ...
    SHA224: typing.ClassVar['MGF1ParameterSpec'] = ...
    SHA256: typing.ClassVar['MGF1ParameterSpec'] = ...
    SHA384: typing.ClassVar['MGF1ParameterSpec'] = ...
    SHA512: typing.ClassVar['MGF1ParameterSpec'] = ...
    SHA512_224: typing.ClassVar['MGF1ParameterSpec'] = ...
    SHA512_256: typing.ClassVar['MGF1ParameterSpec'] = ...
    SHA3_224: typing.ClassVar['MGF1ParameterSpec'] = ...
    SHA3_256: typing.ClassVar['MGF1ParameterSpec'] = ...
    SHA3_384: typing.ClassVar['MGF1ParameterSpec'] = ...
    SHA3_512: typing.ClassVar['MGF1ParameterSpec'] = ...
    def __init__(self, string: str): ...
    def getDigestAlgorithm(self) -> str: ...
    def toString(self) -> str: ...

class NamedParameterSpec(AlgorithmParameterSpec):
    X25519: typing.ClassVar['NamedParameterSpec'] = ...
    X448: typing.ClassVar['NamedParameterSpec'] = ...
    ED25519: typing.ClassVar['NamedParameterSpec'] = ...
    ED448: typing.ClassVar['NamedParameterSpec'] = ...
    ML_DSA_44: typing.ClassVar['NamedParameterSpec'] = ...
    ML_DSA_65: typing.ClassVar['NamedParameterSpec'] = ...
    ML_DSA_87: typing.ClassVar['NamedParameterSpec'] = ...
    ML_KEM_512: typing.ClassVar['NamedParameterSpec'] = ...
    ML_KEM_768: typing.ClassVar['NamedParameterSpec'] = ...
    ML_KEM_1024: typing.ClassVar['NamedParameterSpec'] = ...
    def __init__(self, string: str): ...
    def getName(self) -> str: ...

class PSSParameterSpec(AlgorithmParameterSpec):
    TRAILER_FIELD_BC: typing.ClassVar[int] = ...
    DEFAULT: typing.ClassVar['PSSParameterSpec'] = ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, algorithmParameterSpec: AlgorithmParameterSpec, int: int, int2: int): ...
    def getDigestAlgorithm(self) -> str: ...
    def getMGFAlgorithm(self) -> str: ...
    def getMGFParameters(self) -> AlgorithmParameterSpec: ...
    def getSaltLength(self) -> int: ...
    def getTrailerField(self) -> int: ...
    def toString(self) -> str: ...

class RSAKeyGenParameterSpec(AlgorithmParameterSpec):
    F0: typing.ClassVar[java.math.BigInteger] = ...
    F4: typing.ClassVar[java.math.BigInteger] = ...
    @typing.overload
    def __init__(self, int: int, bigInteger: java.math.BigInteger): ...
    @typing.overload
    def __init__(self, int: int, bigInteger: java.math.BigInteger, algorithmParameterSpec: AlgorithmParameterSpec): ...
    def getKeyParams(self) -> AlgorithmParameterSpec: ...
    def getKeysize(self) -> int: ...
    def getPublicExponent(self) -> java.math.BigInteger: ...

class RSAPrivateKeySpec(KeySpec):
    @typing.overload
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger): ...
    @typing.overload
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger, algorithmParameterSpec: AlgorithmParameterSpec): ...
    def getModulus(self) -> java.math.BigInteger: ...
    def getParams(self) -> AlgorithmParameterSpec: ...
    def getPrivateExponent(self) -> java.math.BigInteger: ...

class RSAPublicKeySpec(KeySpec):
    @typing.overload
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger): ...
    @typing.overload
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger, algorithmParameterSpec: AlgorithmParameterSpec): ...
    def getModulus(self) -> java.math.BigInteger: ...
    def getParams(self) -> AlgorithmParameterSpec: ...
    def getPublicExponent(self) -> java.math.BigInteger: ...

class XECPrivateKeySpec(KeySpec):
    def __init__(self, algorithmParameterSpec: AlgorithmParameterSpec, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]): ...
    def getParams(self) -> AlgorithmParameterSpec: ...
    def getScalar(self) -> typing.MutableSequence[int]: ...

class XECPublicKeySpec(KeySpec):
    def __init__(self, algorithmParameterSpec: AlgorithmParameterSpec, bigInteger: java.math.BigInteger): ...
    def getParams(self) -> AlgorithmParameterSpec: ...
    def getU(self) -> java.math.BigInteger: ...

class ECGenParameterSpec(NamedParameterSpec):
    def __init__(self, string: str): ...

class PKCS8EncodedKeySpec(EncodedKeySpec, java.security.DEREncodable):
    @typing.overload
    def __init__(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]): ...
    @typing.overload
    def __init__(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes], string: str): ...
    def getEncoded(self) -> typing.MutableSequence[int]: ...
    def getFormat(self) -> str: ...

class RSAMultiPrimePrivateCrtKeySpec(RSAPrivateKeySpec):
    @typing.overload
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger, bigInteger3: java.math.BigInteger, bigInteger4: java.math.BigInteger, bigInteger5: java.math.BigInteger, bigInteger6: java.math.BigInteger, bigInteger7: java.math.BigInteger, bigInteger8: java.math.BigInteger, rSAOtherPrimeInfoArray: typing.Union[typing.List[RSAOtherPrimeInfo], jpype.JArray]): ...
    @typing.overload
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger, bigInteger3: java.math.BigInteger, bigInteger4: java.math.BigInteger, bigInteger5: java.math.BigInteger, bigInteger6: java.math.BigInteger, bigInteger7: java.math.BigInteger, bigInteger8: java.math.BigInteger, rSAOtherPrimeInfoArray: typing.Union[typing.List[RSAOtherPrimeInfo], jpype.JArray], algorithmParameterSpec: AlgorithmParameterSpec): ...
    def getCrtCoefficient(self) -> java.math.BigInteger: ...
    def getOtherPrimeInfo(self) -> typing.MutableSequence[RSAOtherPrimeInfo]: ...
    def getPrimeExponentP(self) -> java.math.BigInteger: ...
    def getPrimeExponentQ(self) -> java.math.BigInteger: ...
    def getPrimeP(self) -> java.math.BigInteger: ...
    def getPrimeQ(self) -> java.math.BigInteger: ...
    def getPublicExponent(self) -> java.math.BigInteger: ...

class RSAPrivateCrtKeySpec(RSAPrivateKeySpec):
    @typing.overload
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger, bigInteger3: java.math.BigInteger, bigInteger4: java.math.BigInteger, bigInteger5: java.math.BigInteger, bigInteger6: java.math.BigInteger, bigInteger7: java.math.BigInteger, bigInteger8: java.math.BigInteger): ...
    @typing.overload
    def __init__(self, bigInteger: java.math.BigInteger, bigInteger2: java.math.BigInteger, bigInteger3: java.math.BigInteger, bigInteger4: java.math.BigInteger, bigInteger5: java.math.BigInteger, bigInteger6: java.math.BigInteger, bigInteger7: java.math.BigInteger, bigInteger8: java.math.BigInteger, algorithmParameterSpec: AlgorithmParameterSpec): ...
    def getCrtCoefficient(self) -> java.math.BigInteger: ...
    def getPrimeExponentP(self) -> java.math.BigInteger: ...
    def getPrimeExponentQ(self) -> java.math.BigInteger: ...
    def getPrimeP(self) -> java.math.BigInteger: ...
    def getPrimeQ(self) -> java.math.BigInteger: ...
    def getPublicExponent(self) -> java.math.BigInteger: ...

class X509EncodedKeySpec(EncodedKeySpec, java.security.DEREncodable):
    @typing.overload
    def __init__(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]): ...
    @typing.overload
    def __init__(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes], string: str): ...
    def getEncoded(self) -> typing.MutableSequence[int]: ...
    def getFormat(self) -> str: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.security.spec")``.

    AlgorithmParameterSpec: typing.Type[AlgorithmParameterSpec]
    DSAGenParameterSpec: typing.Type[DSAGenParameterSpec]
    DSAParameterSpec: typing.Type[DSAParameterSpec]
    DSAPrivateKeySpec: typing.Type[DSAPrivateKeySpec]
    DSAPublicKeySpec: typing.Type[DSAPublicKeySpec]
    ECField: typing.Type[ECField]
    ECFieldF2m: typing.Type[ECFieldF2m]
    ECFieldFp: typing.Type[ECFieldFp]
    ECGenParameterSpec: typing.Type[ECGenParameterSpec]
    ECParameterSpec: typing.Type[ECParameterSpec]
    ECPoint: typing.Type[ECPoint]
    ECPrivateKeySpec: typing.Type[ECPrivateKeySpec]
    ECPublicKeySpec: typing.Type[ECPublicKeySpec]
    EdDSAParameterSpec: typing.Type[EdDSAParameterSpec]
    EdECPoint: typing.Type[EdECPoint]
    EdECPrivateKeySpec: typing.Type[EdECPrivateKeySpec]
    EdECPublicKeySpec: typing.Type[EdECPublicKeySpec]
    EllipticCurve: typing.Type[EllipticCurve]
    EncodedKeySpec: typing.Type[EncodedKeySpec]
    InvalidKeySpecException: typing.Type[InvalidKeySpecException]
    InvalidParameterSpecException: typing.Type[InvalidParameterSpecException]
    KeySpec: typing.Type[KeySpec]
    MGF1ParameterSpec: typing.Type[MGF1ParameterSpec]
    NamedParameterSpec: typing.Type[NamedParameterSpec]
    PKCS8EncodedKeySpec: typing.Type[PKCS8EncodedKeySpec]
    PSSParameterSpec: typing.Type[PSSParameterSpec]
    RSAKeyGenParameterSpec: typing.Type[RSAKeyGenParameterSpec]
    RSAMultiPrimePrivateCrtKeySpec: typing.Type[RSAMultiPrimePrivateCrtKeySpec]
    RSAOtherPrimeInfo: typing.Type[RSAOtherPrimeInfo]
    RSAPrivateCrtKeySpec: typing.Type[RSAPrivateCrtKeySpec]
    RSAPrivateKeySpec: typing.Type[RSAPrivateKeySpec]
    RSAPublicKeySpec: typing.Type[RSAPublicKeySpec]
    X509EncodedKeySpec: typing.Type[X509EncodedKeySpec]
    XECPrivateKeySpec: typing.Type[XECPrivateKeySpec]
    XECPublicKeySpec: typing.Type[XECPublicKeySpec]
