"""
Copyright (c) 2010-present by Jaxl Innovations Private Limited.

All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, is strictly prohibited.
"""

from enum import Enum


class DeviceAttestationErrorReasonEnum(str, Enum):
    BYPASSED_FOR_BOT = "BYPASSED_FOR_BOT"
    COOKIE_APP_USER_NOT_FOUND = "COOKIE_APP_USER_NOT_FOUND"
    COOKIE_BAD_SIGNATURE = "COOKIE_BAD_SIGNATURE"
    DECRYPTED_PAYLOAD_IS_NONE = "DECRYPTED_PAYLOAD_IS_NONE"
    DELETED_APP_USER_COOKIE = "DELETED_APP_USER_COOKIE"
    DEVICE_APP_USER_AND_COOKIE_MISMATCH = "DEVICE_APP_USER_AND_COOKIE_MISMATCH"
    DEVICE_PLATFORM_MISMATCH = "DEVICE_PLATFORM_MISMATCH"
    INVALID_ORIGIN_SCHEME = "INVALID_ORIGIN_SCHEME"
    LOGGED_OUT = "LOGGED_OUT"
    NEW_DEVICE_WITH_CLIENT_GENESIS_KEY_AS_NONE = (
        "NEW_DEVICE_WITH_CLIENT_GENESIS_KEY_AS_NONE"
    )
    NO_ORIGIN_HEADER = "NO_ORIGIN_HEADER"
    NO_X_DEVICE_ATTEST_HEADER = "NO_X_DEVICE_ATTEST_HEADER"
    NO_X_DEVICE_ID_HEADER = "NO_X_DEVICE_ID_HEADER"
    PAYLOAD_DECRYPTION_ERROR = "PAYLOAD_DECRYPTION_ERROR"
    PAYLOAD_DECRYPT_ERROR_FOR_NEW_DEVICE = "PAYLOAD_DECRYPT_ERROR_FOR_NEW_DEVICE"
    PAYLOAD_DEVICE_AND_HEADER_DEVICE_MISMATCH = (
        "PAYLOAD_DEVICE_AND_HEADER_DEVICE_MISMATCH"
    )
    PAYLOAD_INVALID_TOKEN = "PAYLOAD_INVALID_TOKEN"
    PAYLOAD_UNABLE_TO_BAIL_OUT = "PAYLOAD_UNABLE_TO_BAIL_OUT"
    VALIDATION_STATUS_CODE_ERROR = "VALIDATION_STATUS_CODE_ERROR"
    VALIDATION_WITH_NON_200_CODE = "VALIDATION_WITH_NON_200_CODE"

    def __str__(self) -> str:
        return str(self.value)
