"""
Copyright (c) 2010-present by Jaxl Innovations Private Limited.

All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, is strictly prohibited.
"""

from typing import Any, Dict, List, Type, TypeVar

import attr

T = TypeVar("T", bound="KycUploadMetadata")


@attr.s(auto_attribs=True)
class KycUploadMetadata:
    """
    Attributes:
        mimetype (str):
        sha (str):
        size (int):
    """

    mimetype: str
    sha: str
    size: int
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        mimetype = self.mimetype
        sha = self.sha
        size = self.size

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "mimetype": mimetype,
                "sha": sha,
                "size": size,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        mimetype = d.pop("mimetype")

        sha = d.pop("sha")

        size = d.pop("size")

        kyc_upload_metadata = cls(
            mimetype=mimetype,
            sha=sha,
            size=size,
        )

        kyc_upload_metadata.additional_properties = d
        return kyc_upload_metadata

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
