/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import jdk.jshell.DeclarationSnippet;
import jdk.jshell.EvalException;
import jdk.jshell.JShell;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import jdk.jshell.UnresolvedReferenceException;
import org.dflib.jjava.execution.CodeEvaluator;
import org.dflib.jjava.execution.CodeEvaluatorBuilder;
import org.dflib.jjava.execution.CompilationException;
import org.dflib.jjava.execution.EvaluationInterruptedException;
import org.dflib.jjava.execution.EvaluationTimeoutException;
import org.dflib.jjava.execution.IncompleteSourceException;
import org.dflib.jjava.execution.MagicsSourceTransformer;
import org.dflib.jjava.jupyter.Extension;
import org.dflib.jjava.jupyter.kernel.BaseKernel;
import org.dflib.jjava.jupyter.kernel.LanguageInfo;
import org.dflib.jjava.jupyter.kernel.ReplacementOptions;
import org.dflib.jjava.jupyter.kernel.display.DisplayData;
import org.dflib.jjava.jupyter.kernel.magic.common.Load;
import org.dflib.jjava.jupyter.kernel.magic.registry.Magics;
import org.dflib.jjava.jupyter.kernel.util.CharPredicate;
import org.dflib.jjava.jupyter.kernel.util.StringStyler;
import org.dflib.jjava.jupyter.kernel.util.TextColor;
import org.dflib.jjava.magics.ClasspathMagics;
import org.dflib.jjava.magics.MavenResolver;

public class JavaKernel
extends BaseKernel {
    private static final CharPredicate IDENTIFIER_CHAR = CharPredicate.builder().inRange('a', 'z').inRange('A', 'Z').inRange('0', '9').match('_').build();
    private static final CharPredicate WS = CharPredicate.anyOf(" \t\n\r");
    private final String version;
    private final CodeEvaluator evaluator;
    private final MavenResolver mavenResolver;
    private final MagicsSourceTransformer magicsTransformer;
    private final Magics magics;
    private final LanguageInfo languageInfo;
    private final String banner;
    private final List<LanguageInfo.Help> helpLinks;
    private final StringStyler errorStyler;

    public static String completeCodeSignifier() {
        return "complete";
    }

    public static String invalidCodeSignifier() {
        return "invalid";
    }

    public static String maybeCompleteCodeSignifier() {
        return "unknown";
    }

    public JavaKernel(String version) {
        this.version = version;
        this.evaluator = new CodeEvaluatorBuilder().addClasspathFromString(System.getenv("IJAVA_CLASSPATH")).addClasspathFromString(System.getenv("JJAVA_CLASSPATH")).compilerOptsFromString(System.getenv("IJAVA_COMPILER_OPTS")).compilerOptsFromString(System.getenv("JJAVA_COMPILER_OPTS")).startupScriptFiles(System.getenv("IJAVA_STARTUP_SCRIPTS_PATH")).startupScriptFiles(System.getenv("JJAVA_STARTUP_SCRIPTS_PATH")).startupScript(System.getenv("IJAVA_STARTUP_SCRIPT")).startupScript(System.getenv("JJAVA_STARTUP_SCRIPT")).timeoutFromString(System.getenv("IJAVA_TIMEOUT")).timeoutFromString(System.getenv("JJAVA_TIMEOUT")).sysStdout().sysStderr().sysStdin().build();
        this.mavenResolver = this.buildDependencyResolver();
        this.magicsTransformer = new MagicsSourceTransformer();
        this.magics = new Magics();
        this.magics.registerMagics(this.mavenResolver);
        this.magics.registerMagics(new ClasspathMagics(this::addToClasspath));
        this.magics.registerMagics(new Load(List.of(".jsh", ".jshell", ".java", ".jjava"), this::eval));
        this.languageInfo = new LanguageInfo.Builder("Java").version(Runtime.version().toString()).mimetype("text/x-java-source").fileExtension(".jshell").pygments("java").codemirror("java").build();
        this.banner = String.format("Java %s :: JJava kernel %s \nProtocol v%s implementation by %s %s", Runtime.version().toString(), version, "5.3", KERNEL_META.getOrDefault("project", "UNKNOWN"), KERNEL_META.getOrDefault("version", "UNKNOWN"));
        this.helpLinks = List.of(new LanguageInfo.Help("Java tutorial", "https://docs.oracle.com/javase/tutorial/java/nutsandbolts/index.html"), new LanguageInfo.Help("JJava homepage", "https://github.com/dflib/jjava"));
        this.errorStyler = new StringStyler.Builder().addPrimaryStyle(TextColor.BOLD_BLACK_FG).addSecondaryStyle(TextColor.BOLD_RED_FG).addHighlightStyle(TextColor.BOLD_BLACK_FG).addHighlightStyle(TextColor.RED_BG).withLinePrefix(TextColor.BOLD_BLACK_FG + "|   ").build();
        this.mavenResolver.initImplicitExtensions();
    }

    public void addToClasspath(String path) {
        this.evaluator.getShell().addToClasspath(path);
    }

    public void handleExtensionLoading(Extension extension) {
        extension.install(this);
    }

    public MavenResolver getMavenResolver() {
        return this.mavenResolver;
    }

    public Magics getMagics() {
        return this.magics;
    }

    @Override
    public LanguageInfo getLanguageInfo() {
        return this.languageInfo;
    }

    @Override
    public String getBanner() {
        return this.banner;
    }

    @Override
    public List<LanguageInfo.Help> getHelpLinks() {
        return this.helpLinks;
    }

    public boolean autoLoadExtensions() {
        String envValue = System.getenv("JJAVA_LOAD_EXTENSIONS");
        if (envValue == null) {
            return true;
        }
        String envValueTrimmed = envValue.trim();
        return !envValueTrimmed.isEmpty() && !envValueTrimmed.equals("0") && !envValueTrimmed.equalsIgnoreCase("false");
    }

    @Override
    public List<String> formatError(Exception e) {
        if (e instanceof CompilationException) {
            return this.formatCompilationException((CompilationException)e);
        }
        if (e instanceof IncompleteSourceException) {
            return this.formatIncompleteSourceException((IncompleteSourceException)e);
        }
        if (e instanceof EvalException) {
            return this.formatEvalException((EvalException)e);
        }
        if (e instanceof UnresolvedReferenceException) {
            return this.formatUnresolvedReferenceException((UnresolvedReferenceException)e);
        }
        if (e instanceof EvaluationTimeoutException) {
            return this.formatEvaluationTimeoutException((EvaluationTimeoutException)e);
        }
        if (e instanceof EvaluationInterruptedException) {
            return this.formatEvaluationInterruptedException((EvaluationInterruptedException)e);
        }
        return new LinkedList<String>(super.formatError(e));
    }

    private MavenResolver buildDependencyResolver() {
        return new MavenResolver(this::addToClasspath, this.autoLoadExtensions() ? this::handleExtensionLoading : ext -> {});
    }

    private List<String> formatCompilationException(CompilationException e) {
        List<String> unresolvedDependencies;
        ArrayList<String> fmt = new ArrayList<String>();
        SnippetEvent event = e.getBadSnippetCompilation();
        Snippet snippet = event.snippet();
        this.evaluator.getShell().diagnostics(snippet).forEach(d -> {
            if (d.getStartPosition() >= 0L && d.getEndPosition() >= 0L) {
                fmt.addAll(this.errorStyler.highlightSubstringLines(snippet.source(), (int)d.getStartPosition(), (int)d.getEndPosition()));
            } else {
                fmt.addAll(this.errorStyler.primaryLines(snippet.source()));
            }
            for (String line : StringStyler.splitLines(d.getMessage(null))) {
                if (line.trim().startsWith("location:")) continue;
                fmt.add(this.errorStyler.secondary(line));
            }
            fmt.add("");
        });
        if (snippet instanceof DeclarationSnippet && !(unresolvedDependencies = this.evaluator.getShell().unresolvedDependencies((DeclarationSnippet)snippet).collect(Collectors.toList())).isEmpty()) {
            fmt.addAll(this.errorStyler.primaryLines(snippet.source()));
            fmt.add(this.errorStyler.secondary("Unresolved dependencies:"));
            unresolvedDependencies.forEach(dep -> fmt.add(this.errorStyler.secondary("   - " + dep)));
        }
        return fmt;
    }

    private List<String> formatIncompleteSourceException(IncompleteSourceException e) {
        ArrayList<String> fmt = new ArrayList<String>();
        String source = e.getSource();
        fmt.add(this.errorStyler.secondary("Incomplete input:"));
        fmt.addAll(this.errorStyler.primaryLines(source));
        return fmt;
    }

    private List<String> formatEvalException(EvalException e) {
        ArrayList<String> fmt = new ArrayList<String>();
        String evalExceptionClassName = EvalException.class.getName();
        String actualExceptionName = e.getExceptionClassName();
        super.formatError(e).stream().map(line -> line.replace(evalExceptionClassName, actualExceptionName)).forEach(fmt::add);
        return fmt;
    }

    private List<String> formatUnresolvedReferenceException(UnresolvedReferenceException e) {
        ArrayList<String> fmt = new ArrayList<String>();
        DeclarationSnippet snippet = e.getSnippet();
        List<String> unresolvedDependencies = this.evaluator.getShell().unresolvedDependencies(snippet).collect(Collectors.toList());
        if (!unresolvedDependencies.isEmpty()) {
            fmt.addAll(this.errorStyler.primaryLines(snippet.source()));
            fmt.add(this.errorStyler.secondary("Unresolved dependencies:"));
            unresolvedDependencies.forEach(dep -> fmt.add(this.errorStyler.secondary("   - " + dep)));
        }
        return fmt;
    }

    private List<String> formatEvaluationTimeoutException(EvaluationTimeoutException e) {
        ArrayList<String> fmt = new ArrayList<String>(this.errorStyler.primaryLines(e.getSource()));
        fmt.add(this.errorStyler.secondary(String.format("Evaluation timed out after %d %s.", e.getDuration(), e.getUnit().name().toLowerCase())));
        return fmt;
    }

    private List<String> formatEvaluationInterruptedException(EvaluationInterruptedException e) {
        ArrayList<String> fmt = new ArrayList<String>(this.errorStyler.primaryLines(e.getSource()));
        fmt.add(this.errorStyler.secondary("Evaluation interrupted."));
        return fmt;
    }

    public Object evalRaw(String expr) throws Exception {
        expr = this.magicsTransformer.transformMagics(expr);
        return this.evaluator.eval(expr);
    }

    @Override
    public DisplayData eval(String expr) throws Exception {
        Object result = this.evalRaw(expr);
        if (result != null) {
            return result instanceof DisplayData ? (DisplayData)result : this.getRenderer().render(result);
        }
        return null;
    }

    @Override
    public DisplayData inspect(String code, int at, boolean extraDetail) {
        List<SourceCodeAnalysis.Documentation> documentations;
        while (at + 1 < code.length() && IDENTIFIER_CHAR.test(code.charAt(at + 1))) {
            ++at;
        }
        int parenIdx = at;
        while (parenIdx + 1 < code.length() && WS.test(code.charAt(parenIdx + 1))) {
            ++parenIdx;
        }
        if (parenIdx + 1 < code.length() && code.charAt(parenIdx + 1) == '(') {
            at = parenIdx + 1;
        }
        if ((documentations = this.evaluator.getShell().sourceCodeAnalysis().documentation(code, at + 1, true)) == null || documentations.isEmpty()) {
            return null;
        }
        DisplayData fmtDocs = new DisplayData(documentations.stream().map(doc -> {
            Object formatted = doc.signature();
            String javadoc = doc.javadoc();
            if (javadoc != null) {
                formatted = (String)formatted + "\n" + javadoc;
            }
            return formatted;
        }).collect(Collectors.joining("\n\n")));
        fmtDocs.putHTML(documentations.stream().map(doc -> {
            Object formatted = doc.signature();
            String javadoc = doc.javadoc();
            if (javadoc != null) {
                formatted = (String)formatted + "<br/>" + javadoc;
            }
            return formatted;
        }).collect(Collectors.joining("<br/><br/>")));
        return fmtDocs;
    }

    @Override
    public ReplacementOptions complete(String code, int at) {
        int[] replaceStart = new int[1];
        List<SourceCodeAnalysis.Suggestion> suggestions = this.evaluator.getShell().sourceCodeAnalysis().completionSuggestions(code, at, replaceStart);
        if (suggestions == null || suggestions.isEmpty()) {
            return null;
        }
        List<String> options = suggestions.stream().sorted((s1, s2) -> s1.matchesType() ? (s2.matchesType() ? 0 : -1) : (s2.matchesType() ? 1 : 0)).map(SourceCodeAnalysis.Suggestion::continuation).distinct().collect(Collectors.toList());
        return new ReplacementOptions(options, replaceStart[0], at);
    }

    @Override
    public String isComplete(String code) {
        return this.evaluator.isComplete(code);
    }

    @Override
    public void onShutdown(boolean isRestarting) {
        this.evaluator.shutdown();
    }

    @Override
    public void interrupt() {
        this.evaluator.interrupt();
    }

    public JShell getJShell() {
        return this.evaluator.getShell();
    }

    public String getVersion() {
        return this.version;
    }
}

