/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.execution;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.jshell.execution.DirectExecutionControl;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.SPIResolutionException;
import org.dflib.jjava.execution.JJavaLoaderDelegate;

public class JJavaExecutionControl
extends DirectExecutionControl {
    public static final String EXECUTION_TIMEOUT_NAME = "Execution Timeout";
    public static final String EXECUTION_INTERRUPTED_NAME = "Execution Interrupted";
    private static final Object NULL = new Object();
    private static final AtomicInteger EXECUTOR_THREAD_ID = new AtomicInteger(0);
    private final ExecutorService executor;
    private final long timeoutTime;
    private final TimeUnit timeoutUnit;
    private final ConcurrentMap<String, Future<Object>> running = new ConcurrentHashMap<String, Future<Object>>();
    private final Map<String, Object> results = new ConcurrentHashMap<String, Object>();
    private final JJavaLoaderDelegate loaderDelegate = new JJavaLoaderDelegate();

    public JJavaExecutionControl() {
        this(-1L, TimeUnit.MILLISECONDS);
    }

    public JJavaExecutionControl(long timeoutTime, TimeUnit timeoutUnit) {
        super(null);
        this.timeoutTime = timeoutTime;
        this.timeoutUnit = timeoutTime > 0L ? Objects.requireNonNull(timeoutUnit) : TimeUnit.MILLISECONDS;
        this.executor = Executors.newCachedThreadPool(r -> new Thread(r, "JJava-executor-" + EXECUTOR_THREAD_ID.getAndIncrement()));
    }

    public long getTimeoutDuration() {
        return this.timeoutTime;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public Object takeResult(String key) {
        Object result = this.results.remove(key);
        if (result == null) {
            throw new IllegalStateException("No result with key: " + key);
        }
        return result == NULL ? null : result;
    }

    private Object execute(String key, Method doitMethod) throws TimeoutException, Exception {
        Future<Object> runningTask = this.executor.submit(() -> doitMethod.invoke(null, new Object[0]));
        this.running.put(key, runningTask);
        try {
            if (this.timeoutTime > 0L) {
                Object object = runningTask.get(this.timeoutTime, this.timeoutUnit);
                return object;
            }
            Object object = runningTask.get();
            return object;
        }
        catch (CancellationException e) {
            if (this.executor.isShutdown()) {
                throw new ExecutionControl.StoppedException();
            }
            throw new ExecutionControl.UserException("Execution interrupted.", EXECUTION_INTERRUPTED_NAME, e.getStackTrace());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
            }
            if (cause == null) {
                throw new ExecutionControl.UserException("null", "Unknown Invocation Exception", e.getStackTrace());
            }
            if (cause instanceof SPIResolutionException) {
                throw new ExecutionControl.ResolutionException(((SPIResolutionException)cause).id(), cause.getStackTrace());
            }
            throw new ExecutionControl.UserException(String.valueOf(cause.getMessage()), String.valueOf(cause.getClass().getName()), cause.getStackTrace());
        }
        catch (TimeoutException e) {
            throw new ExecutionControl.UserException(String.format("Execution timed out after configured timeout of %d %s.", this.timeoutTime, this.timeoutUnit.toString().toLowerCase()), EXECUTION_TIMEOUT_NAME, e.getStackTrace());
        }
        finally {
            this.running.remove(key, runningTask);
        }
    }

    @Override
    protected String invoke(Method doitMethod) throws Exception {
        String id = UUID.randomUUID().toString();
        Object value = this.execute(id, doitMethod);
        this.results.put(id, value);
        return id;
    }

    public void interrupt() {
        this.running.forEach((id, future) -> future.cancel(true));
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
    }

    @Override
    public void load(ExecutionControl.ClassBytecodes[] cbcs) throws ExecutionControl.ClassInstallException {
        this.loaderDelegate.load(cbcs);
    }

    @Override
    public void addToClasspath(String cp) throws ExecutionControl.InternalException {
        this.loaderDelegate.addToClasspath(cp);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.loaderDelegate.findClass(name);
    }

    void unloadClass(String className) throws ClassNotFoundException {
        this.loaderDelegate.unloadClass(className);
    }

    public String toString() {
        return "JJavaExecutionControl{timeoutTime=" + this.timeoutTime + ", timeoutUnit=" + this.timeoutUnit + "}";
    }
}

