/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.execution;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import jdk.jshell.execution.LoaderDelegate;
import jdk.jshell.spi.ExecutionControl;

public class JJavaLoaderDelegate
implements LoaderDelegate {
    private static final String CLASSPATH_PROPERTY = "java.class.path";
    private final Map<String, byte[]> declaredClasses = new HashMap<String, byte[]>();
    private final Map<String, Class<?>> loadedClasses = new HashMap();
    private final BytecodeClassLoader classLoader = new BytecodeClassLoader();

    public JJavaLoaderDelegate() {
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    @Override
    public void load(ExecutionControl.ClassBytecodes[] cbcs) throws ExecutionControl.ClassInstallException {
        boolean[] installed = new boolean[cbcs.length];
        int i = 0;
        for (ExecutionControl.ClassBytecodes cbc : cbcs) {
            this.declaredClasses.put(cbc.name(), cbc.bytecodes());
            try {
                Class<?> loaderClass = this.classLoader.findClass(cbc.name());
                this.loadedClasses.put(cbc.name(), loaderClass);
            }
            catch (ClassNotFoundException e) {
                throw new ExecutionControl.ClassInstallException("Unable to load class " + cbc.name() + ": " + e.getMessage(), installed);
            }
            installed[i++] = true;
        }
    }

    @Override
    public void classesRedefined(ExecutionControl.ClassBytecodes[] cbcs) {
        for (ExecutionControl.ClassBytecodes cbc : cbcs) {
            this.declaredClasses.put(cbc.name(), cbc.bytecodes());
        }
    }

    @Override
    public void addToClasspath(String path) throws ExecutionControl.InternalException {
        for (String next : path.split(File.pathSeparator)) {
            try {
                this.classLoader.addURL(Path.of(next, new String[0]).toUri().toURL());
                Object classpath = System.getProperty(CLASSPATH_PROPERTY);
                classpath = (String)classpath + System.lineSeparator() + path;
                System.setProperty(CLASSPATH_PROPERTY, (String)classpath);
            }
            catch (MalformedURLException e) {
                throw new ExecutionControl.InternalException("Unable to resolve classpath " + next + ": " + e.getMessage());
            }
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> klass = this.loadedClasses.get(name);
        if (klass == null && this.declaredClasses.containsKey(name)) {
            klass = this.loadClass(name);
        }
        if (klass == null) {
            throw new ClassNotFoundException(name + " not found");
        }
        return klass;
    }

    private Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    public void unloadClass(String name) {
        this.loadedClasses.remove(name);
        this.declaredClasses.remove(name);
    }

    class BytecodeClassLoader
    extends URLClassLoader {
        public BytecodeClassLoader() {
            super(new URL[0]);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] data = JJavaLoaderDelegate.this.declaredClasses.get(name);
            if (data == null) {
                return super.findClass(name);
            }
            return super.defineClass(name, data, 0, data.length, (CodeSource)null);
        }
    }
}

