/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel.display;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dflib.jjava.jupyter.kernel.display.DisplayData;
import org.dflib.jjava.jupyter.kernel.display.DisplayDataRenderable;
import org.dflib.jjava.jupyter.kernel.display.RenderContext;
import org.dflib.jjava.jupyter.kernel.display.RenderFunction;
import org.dflib.jjava.jupyter.kernel.display.RenderRequestTypes;
import org.dflib.jjava.jupyter.kernel.display.mime.MIMEType;
import org.dflib.jjava.jupyter.kernel.util.InheritanceIterator;

public class Renderer {
    private final Map<Class, List<RenderFunctionProps>> renderFunctions = new HashMap<Class, List<RenderFunctionProps>>();
    private final Map<String, MIMEType> suffixMappings = new HashMap<String, MIMEType>();

    public <T> RenderRegistration<T> createRegistration(Class<T> type) {
        return new RenderRegistration<T>(type);
    }

    public <T> void register(Set<MIMEType> supported, Set<MIMEType> preferred, Set<Class<? extends T>> types, RenderFunction<T> function) {
        RenderFunctionProps props = new RenderFunctionProps(function, supported, preferred);
        types.forEach(c -> this.renderFunctions.compute((Class)c, (k, v) -> {
            List functions = v != null ? v : new LinkedList();
            functions.add(props);
            return functions;
        }));
    }

    private static DisplayData finalizeDisplayData(DisplayData data, Object value) {
        if (!data.hasDataForType(MIMEType.TEXT_PLAIN)) {
            data.putText(String.valueOf(value));
        }
        return data;
    }

    public DisplayData render(Object value, Map<String, Object> params) {
        DisplayData out = new DisplayData();
        if (value instanceof DisplayDataRenderable) {
            DisplayDataRenderable renderable = (DisplayDataRenderable)value;
            RenderRequestTypes.Builder requestTypes = new RenderRequestTypes.Builder(this.suffixMappings::get);
            requestTypes.withType(MIMEType.TEXT_PLAIN);
            renderable.getPreferredRenderTypes().forEach(requestTypes::withType);
            renderable.render(new RenderContext(requestTypes.build(), this, params, out));
            return Renderer.finalizeDisplayData(out, value);
        }
        InheritanceIterator inheritedTypes = new InheritanceIterator(value.getClass());
        while (inheritedTypes.hasNext()) {
            Class type = (Class)inheritedTypes.next();
            List<RenderFunctionProps> allRenderFunctionProps = this.renderFunctions.get(type);
            if (allRenderFunctionProps == null || allRenderFunctionProps.isEmpty()) continue;
            for (RenderFunctionProps renderFunctionProps : allRenderFunctionProps) {
                RenderRequestTypes.Builder requestTypes = new RenderRequestTypes.Builder(this.suffixMappings::get);
                requestTypes.withType(MIMEType.TEXT_PLAIN);
                renderFunctionProps.getPreferredTypes().forEach(requestTypes::withType);
                renderFunctionProps.getFunction().render(value, new RenderContext(requestTypes.build(), this, params, out));
            }
            return Renderer.finalizeDisplayData(out, value);
        }
        return Renderer.finalizeDisplayData(out, value);
    }

    public DisplayData render(Object value) {
        return this.render(value, new LinkedHashMap<String, Object>());
    }

    public DisplayData renderAs(Object value, Map<String, Object> params, String ... types) {
        DisplayDataRenderable renderable;
        DisplayData out = new DisplayData();
        RenderRequestTypes.Builder builder = new RenderRequestTypes.Builder(this.suffixMappings::get);
        builder.withType(MIMEType.TEXT_PLAIN);
        for (String string : types) {
            builder.withType(string);
        }
        RenderRequestTypes requestTypes = builder.build();
        RenderContext context = new RenderContext(requestTypes, this, params, out);
        if (value instanceof DisplayDataRenderable && requestTypes.anyRequestedIsSupported((renderable = (DisplayDataRenderable)value).getSupportedRenderTypes())) {
            renderable.render(context);
            requestTypes.removeFulfilledRequests(out);
        }
        InheritanceIterator inheritedTypes = new InheritanceIterator(value.getClass());
        while (inheritedTypes.hasNext() && !requestTypes.isEmpty()) {
            Class clazz = (Class)inheritedTypes.next();
            List<RenderFunctionProps> allRenderFunctionProps = this.renderFunctions.get(clazz);
            if (allRenderFunctionProps == null) continue;
            for (RenderFunctionProps renderFunctionProps : allRenderFunctionProps) {
                if (!requestTypes.anyRequestedIsSupported(renderFunctionProps.getSupportedTypes())) continue;
                renderFunctionProps.getFunction().render(value, context);
                requestTypes.removeFulfilledRequests(out);
            }
        }
        return Renderer.finalizeDisplayData(out, value);
    }

    public DisplayData renderAs(Object value, String ... types) {
        return this.renderAs(value, new LinkedHashMap<String, Object>(), types);
    }

    public class RenderRegistration<T> {
        private final Set<MIMEType> supported = new LinkedHashSet<MIMEType>();
        private final Set<MIMEType> preferred = new LinkedHashSet<MIMEType>();
        private final Set<Class<? extends T>> types = new LinkedHashSet<Class<? extends T>>();

        public RenderRegistration(Class<? extends T> type) {
            this.types.add(type);
        }

        public RenderRegistration<T> supporting(MIMEType ... types) {
            Collections.addAll(this.supported, types);
            return this;
        }

        public RenderRegistration<T> preferring(MIMEType ... types) {
            this.supporting(types);
            Collections.addAll(this.preferred, types);
            return this;
        }

        public RenderRegistration<T> supporting(String ... types) {
            for (String type : types) {
                this.supported.add(MIMEType.parse(type));
            }
            return this;
        }

        public RenderRegistration<T> preferring(String ... types) {
            this.supporting(types);
            for (String type : types) {
                this.preferred.add(MIMEType.parse(type));
            }
            return this;
        }

        public RenderRegistration<T> onType(Class<? extends T> type) {
            this.types.add(type);
            return this;
        }

        public void register(RenderFunction<T> function) {
            Set<MIMEType> supported = this.supported.isEmpty() ? DisplayDataRenderable.ANY : this.supported;
            Set<MIMEType> preferred = this.preferred.isEmpty() ? supported : this.preferred;
            Renderer.this.register(supported, preferred, this.types, function);
        }
    }

    private static class RenderFunctionProps {
        private final RenderFunction function;
        private final Set<MIMEType> supportedTypes;
        private final Set<MIMEType> preferredTypes;

        public RenderFunctionProps(RenderFunction function, Set<MIMEType> supportedTypes, Set<MIMEType> preferredTypes) {
            this.function = function;
            this.supportedTypes = supportedTypes;
            this.preferredTypes = preferredTypes;
        }

        public RenderFunction getFunction() {
            return this.function;
        }

        public Set<MIMEType> getSupportedTypes() {
            return this.supportedTypes;
        }

        public Set<MIMEType> getPreferredTypes() {
            return this.preferredTypes;
        }
    }
}

