/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel.magic.common;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dflib.jjava.jupyter.kernel.magic.registry.LineMagic;
import org.dflib.jjava.jupyter.kernel.magic.registry.MagicsArgs;
import org.dflib.jjava.shaded.com.google.gson.Gson;
import org.dflib.jjava.shaded.com.google.gson.GsonBuilder;
import org.dflib.jjava.shaded.com.google.gson.stream.JsonReader;

public class Load {
    private static final ThreadLocal<Gson> GSON = ThreadLocal.withInitial(() -> new GsonBuilder().create());
    private static final MagicsArgs LOAD_ARGS = MagicsArgs.builder().required("source").onlyKnownFlags().onlyKnownKeywords().build();
    private final List<String> fileExtensions;
    private final Executor exec;

    private static void forEachCell(Path notebookPath, Executor handle) throws Exception {
        try (BufferedReader in = Files.newBufferedReader(notebookPath, StandardCharsets.UTF_8);){
            JsonReader reader = GSON.get().newJsonReader(in);
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (!name.equals("cells")) {
                    reader.skipValue();
                    continue;
                }
                reader.beginArray();
                while (reader.hasNext()) {
                    Boolean isCode = null;
                    String source = null;
                    reader.beginObject();
                    block15: while (reader.hasNext()) {
                        if (isCode != null && !isCode.booleanValue()) {
                            reader.skipValue();
                            continue;
                        }
                        switch (reader.nextName()) {
                            case "cell_type": {
                                String cellType = reader.nextString();
                                isCode = cellType.equals("code");
                                continue block15;
                            }
                            case "source": {
                                StringBuilder srcBuilder = new StringBuilder();
                                reader.beginArray();
                                while (reader.hasNext()) {
                                    srcBuilder.append(reader.nextString());
                                }
                                reader.endArray();
                                source = srcBuilder.toString();
                                continue block15;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    if (isCode == null || !isCode.booleanValue()) continue;
                    handle.execute(source);
                }
                reader.endArray();
            }
            reader.endObject();
        }
    }

    public Load(List<String> fileExtensions, Executor exec) {
        this.fileExtensions = fileExtensions == null ? Collections.emptyList() : fileExtensions.stream().map(e -> e.startsWith(".") ? e : "." + e).collect(Collectors.toList());
        this.exec = exec;
    }

    @LineMagic
    public void load(List<String> args) throws Exception {
        Map<String, List<String>> vals = LOAD_ARGS.parse(args);
        Path sourcePath = Paths.get(vals.get("source").get(0), new String[0]).toAbsolutePath();
        if (Files.isRegularFile(sourcePath, new LinkOption[0])) {
            if (sourcePath.getFileName().toString().endsWith(".ipynb")) {
                Load.forEachCell(sourcePath, this.exec);
                return;
            }
            String sourceContents = new String(Files.readAllBytes(sourcePath), StandardCharsets.UTF_8);
            this.exec.execute(sourceContents);
            return;
        }
        String file = sourcePath.getFileName().toString();
        for (String extension : this.fileExtensions) {
            Path scriptPath = sourcePath.resolveSibling(file + extension);
            if (!Files.isRegularFile(scriptPath, new LinkOption[0])) continue;
            String sourceContents = new String(Files.readAllBytes(scriptPath), StandardCharsets.UTF_8);
            this.exec.execute(sourceContents);
            return;
        }
        Path scriptPath = sourcePath.resolveSibling(file + ".ipynb");
        if (Files.isRegularFile(scriptPath, new LinkOption[0])) {
            Load.forEachCell(scriptPath, this.exec);
            return;
        }
        throw new FileNotFoundException("Could not find any source at '" + sourcePath + "'. Also tried with extensions: [.ipynb, " + this.fileExtensions.stream().collect(Collectors.joining(", ")) + "].");
    }

    @FunctionalInterface
    public static interface Executor {
        public void execute(String var1) throws Exception;
    }
}

