/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel.magic.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dflib.jjava.jupyter.kernel.magic.registry.MagicArgsParseException;

public class MagicsArgs {
    private static final Pattern KEYWORD_ARG_PATTERN = Pattern.compile("^--(?<name>[^=]+)(?:=(?<val>.+))?$");
    private static final Pattern FLAG_ARG_PATTERN = Pattern.compile("^-(?<flags>[a-zA-Z]+)$");
    private final List<String> positional;
    private final List<String> optional;
    private final String varargs;
    private final Map<String, KeywordAggregator> keywords;
    private final Map<Character, String> keywordFromFlag;
    private final Map<String, String> flagSuppliedDefaults;
    private final KeywordAggregator defaultKeywordAggregator;
    private final KeywordAggregator defaultFlagAggregator;

    public static MagicsArgsBuilder builder() {
        return new MagicsArgsBuilder();
    }

    public MagicsArgs(List<String> positional, List<String> optional, String varargs, Map<String, KeywordAggregator> keywords, Map<Character, String> keywordFromFlag, Map<String, String> flagSuppliedDefaults, KeywordAggregator defaultKeywordAggregator, KeywordAggregator defaultFlagAggregator) {
        this.positional = positional;
        this.optional = optional;
        this.varargs = varargs;
        this.keywords = keywords;
        this.keywordFromFlag = keywordFromFlag;
        this.flagSuppliedDefaults = flagSuppliedDefaults;
        this.defaultKeywordAggregator = defaultKeywordAggregator;
        this.defaultFlagAggregator = defaultFlagAggregator;
    }

    public Map<String, List<String>> parse(List<String> args) throws MagicArgsParseException {
        LinkedHashMap<String, List<String>> collectedArgs = new LinkedHashMap<String, List<String>>();
        this.positional.forEach(a -> collectedArgs.put((String)a, new LinkedList()));
        this.optional.forEach(a -> collectedArgs.put((String)a, new LinkedList()));
        if (this.varargs != null) {
            collectedArgs.put(this.varargs, new LinkedList());
        }
        this.keywords.keySet().forEach(a -> collectedArgs.put((String)a, new LinkedList()));
        int positionalsMatched = 0;
        while (!args.isEmpty()) {
            String arg = args.get(0);
            args = args.subList(1, args.size());
            Matcher m = KEYWORD_ARG_PATTERN.matcher(arg);
            if (m.matches()) {
                String name = m.group("name");
                String value = m.group("val");
                KeywordAggregator aggregator = this.keywords.getOrDefault(name, this.defaultKeywordAggregator);
                if (aggregator == null) {
                    throw new MagicArgsParseException("Unknown keyword argument '%s'.", name);
                }
                args = aggregator.consume(name, value, args, collectedArgs);
                continue;
            }
            m = FLAG_ARG_PATTERN.matcher(arg);
            if (m.matches()) {
                String flags = m.group("flags");
                for (int i = 0; i < flags.length(); ++i) {
                    char c = flags.charAt(i);
                    String name = this.keywordFromFlag.getOrDefault(Character.valueOf(c), Character.toString(c));
                    KeywordAggregator aggregator = this.keywords.getOrDefault(name, this.defaultFlagAggregator);
                    if (aggregator == null) {
                        throw new MagicArgsParseException("Unknown flag argument '%s'.", name);
                    }
                    args = aggregator.consume(name, this.flagSuppliedDefaults.getOrDefault(name, ""), args, collectedArgs);
                }
                continue;
            }
            if (positionalsMatched < this.positional.size()) {
                collectedArgs.compute(this.positional.get(positionalsMatched), (n, values) -> {
                    values = values != null ? values : new LinkedList();
                    values.add(arg);
                    return values;
                });
            } else if (positionalsMatched < this.positional.size() + this.optional.size()) {
                collectedArgs.compute(this.optional.get(positionalsMatched - this.positional.size()), (n, values) -> {
                    values = values != null ? values : new LinkedList();
                    values.add(arg);
                    return values;
                });
            } else if (this.varargs != null) {
                collectedArgs.compute(this.varargs, (n, values) -> {
                    values = values != null ? values : new LinkedList();
                    values.add(arg);
                    return values;
                });
            } else {
                throw new MagicArgsParseException("Too many positional arguments.", new Object[0]);
            }
            ++positionalsMatched;
        }
        if (positionalsMatched < this.positional.size()) {
            throw new MagicArgsParseException("Missing required positional arguments: %s", this.positional.subList(positionalsMatched, this.positional.size()));
        }
        return collectedArgs;
    }

    public String toString() {
        StringJoiner s = new StringJoiner(" ");
        this.positional.forEach(s::add);
        this.optional.forEach(a -> s.add("[" + a + "]"));
        if (this.varargs != null) {
            s.add(this.varargs + "...");
        }
        this.keywordFromFlag.keySet().forEach(c -> s.add("-" + c));
        if (this.defaultFlagAggregator != null) {
            s.add("-*");
        }
        this.keywords.keySet().stream().filter(a -> !this.keywordFromFlag.values().contains(a)).forEach(a -> s.add("--" + a));
        if (this.defaultKeywordAggregator != null) {
            s.add("--**");
        }
        return s.toString();
    }

    public static class MagicsArgsBuilder {
        private final List<String> requiredPositional = new LinkedList<String>();
        private final List<String> optionalPositional = new LinkedList<String>();
        private String varargs;
        private boolean acceptAnyKeyword = true;
        private boolean acceptAnyFlag = true;
        private final Map<String, Set<KeywordSpec>> keywords = new LinkedHashMap<String, Set<KeywordSpec>>();
        private final Map<Character, String> flags = new LinkedHashMap<Character, String>();
        private final Map<String, String> flagDefaultValues = new LinkedHashMap<String, String>();

        public MagicsArgsBuilder required(String name) {
            if (!this.optionalPositional.isEmpty() || this.varargs != null) {
                throw new IllegalStateException("Schema cannot have required positional arguments after optional ones.");
            }
            this.requiredPositional.add(name);
            return this;
        }

        public MagicsArgsBuilder optional(String name) {
            this.optionalPositional.add(name);
            return this;
        }

        public MagicsArgsBuilder varargs(String name) {
            if (this.varargs != null) {
                throw new IllegalStateException("Schema already has varargs: " + this.varargs);
            }
            this.varargs = name;
            return this;
        }

        public MagicsArgsBuilder keyword(String name, KeywordSpec spec, KeywordSpec ... specRest) {
            this.keywords.put(name, EnumSet.of(spec, specRest));
            return this;
        }

        public MagicsArgsBuilder keyword(String name) {
            return this.keyword(name, KeywordSpec.COLLECT, new KeywordSpec[0]);
        }

        public MagicsArgsBuilder flag(String name, char shortName, String value) {
            this.keyword(name);
            this.flags.put(Character.valueOf(shortName), name);
            this.flagDefaultValues.put(name, value);
            return this;
        }

        public MagicsArgsBuilder flag(String name, char shortName) {
            this.keyword(name);
            this.flags.put(Character.valueOf(shortName), name);
            return this;
        }

        public MagicsArgsBuilder anyKeyword() {
            this.acceptAnyKeyword = true;
            return this;
        }

        public MagicsArgsBuilder onlyKnownKeywords() {
            this.acceptAnyKeyword = false;
            return this;
        }

        public MagicsArgsBuilder anyFlag() {
            this.acceptAnyFlag = true;
            return this;
        }

        public MagicsArgsBuilder onlyKnownFlags() {
            this.acceptAnyFlag = false;
            return this;
        }

        private KeywordAggregator buildKeyword(Set<KeywordSpec> spec) {
            if (spec.contains((Object)KeywordSpec.ONCE)) {
                return (name, value, rest, args) -> {
                    if (args.containsKey(name) && !((List)args.get(name)).isEmpty()) {
                        throw new MagicArgsParseException("'%s' may only be specified once.", name);
                    }
                    if (value != null) {
                        args.put(name, Collections.singletonList(value));
                        return rest;
                    }
                    if (rest.isEmpty()) {
                        throw new MagicArgsParseException("'%s' is a keyword argument but no value was supplied.", name);
                    }
                    args.put(name, Collections.singletonList((String)rest.get(0)));
                    return rest.subList(1, rest.size());
                };
            }
            if (spec.contains((Object)KeywordSpec.REPLACE)) {
                return (name, value, rest, args) -> {
                    if (value != null) {
                        args.put(name, Collections.singletonList(value));
                        return rest;
                    }
                    if (rest.isEmpty()) {
                        throw new MagicArgsParseException("'%s' is a keyword argument but no value was supplied.", name);
                    }
                    args.put(name, Collections.singletonList((String)rest.get(0)));
                    return rest.subList(1, rest.size());
                };
            }
            return (name, value, rest, args) -> {
                args.compute(name, (k, values) -> {
                    if (values == null) {
                        values = new LinkedList<String>();
                    }
                    if (value != null) {
                        values.add(value);
                    } else {
                        if (rest.isEmpty()) {
                            throw new MagicArgsParseException("'%s' is a keyword argument but no value was supplied.", name);
                        }
                        values.add((String)rest.get(0));
                    }
                    return values;
                });
                return value != null ? rest : rest.subList(1, rest.size());
            };
        }

        public MagicsArgs build() {
            HashMap<String, KeywordAggregator> kw = new HashMap<String, KeywordAggregator>(this.keywords.size());
            this.keywords.forEach((name, spec) -> kw.put((String)name, this.buildKeyword((Set<KeywordSpec>)spec)));
            return new MagicsArgs(new ArrayList<String>(this.requiredPositional), new ArrayList<String>(this.optionalPositional), this.varargs, kw, this.flags, this.flagDefaultValues, this.acceptAnyKeyword ? this.buildKeyword(EnumSet.noneOf(KeywordSpec.class)) : null, this.acceptAnyFlag ? this.buildKeyword(EnumSet.noneOf(KeywordSpec.class)) : null);
        }
    }

    @FunctionalInterface
    private static interface KeywordAggregator {
        public List<String> consume(String var1, String var2, List<String> var3, Map<String, List<String>> var4) throws MagicArgsParseException;
    }

    public static enum KeywordSpec {
        ONCE,
        COLLECT,
        REPLACE;

    }
}

