/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class InheritanceIterator
implements Iterator<Class> {
    private final Set<Class> observedInterfaces;
    private Class concrete;
    private Iterator<Class> implementedInterfaces;

    public InheritanceIterator(Class root) {
        this.concrete = root;
        this.observedInterfaces = new LinkedHashSet<Class>();
    }

    private Iterator<Class> initializeImplementedInterfaces() {
        LinkedList<Class> implemented = new LinkedList<Class>();
        this.getAllInterfaces(implemented, this.concrete.getInterfaces());
        return implemented.iterator();
    }

    private void getAllInterfaces(List<Class> allInterfaces, Class[] declaredImplementations) {
        for (Class implementedInterface : declaredImplementations) {
            if (!this.observedInterfaces.add(implementedInterface)) continue;
            allInterfaces.add(implementedInterface);
        }
        for (Class implementedInterface : declaredImplementations) {
            this.getAllInterfaces(allInterfaces, implementedInterface.getInterfaces());
        }
    }

    @Override
    public boolean hasNext() {
        return this.implementedInterfaces == null || this.implementedInterfaces.hasNext() || this.concrete.getSuperclass() != null;
    }

    @Override
    public Class next() {
        if (this.implementedInterfaces == null) {
            this.implementedInterfaces = this.initializeImplementedInterfaces();
            return this.concrete;
        }
        if (this.implementedInterfaces.hasNext()) {
            return this.implementedInterfaces.next();
        }
        Class superClass = this.concrete.getSuperclass();
        if (superClass != null) {
            this.concrete = superClass;
            this.implementedInterfaces = this.initializeImplementedInterfaces();
            return superClass;
        }
        throw new NoSuchElementException();
    }
}

