/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.messages.reply;

import java.util.Map;
import org.dflib.jjava.jupyter.kernel.ExpressionValue;
import org.dflib.jjava.jupyter.messages.ContentType;
import org.dflib.jjava.jupyter.messages.MessageType;
import org.dflib.jjava.jupyter.messages.ReplyType;
import org.dflib.jjava.jupyter.messages.request.ExecuteRequest;
import org.dflib.jjava.shaded.com.google.gson.annotations.SerializedName;

public class ExecuteReply
implements ContentType<ExecuteReply>,
ReplyType<ExecuteRequest> {
    public static final MessageType<ExecuteReply> MESSAGE_TYPE = MessageType.EXECUTE_REPLY;
    public static final MessageType<ExecuteRequest> REQUEST_MESSAGE_TYPE = MessageType.EXECUTE_REQUEST;
    private final Status status;
    @SerializedName(value="execution_count")
    protected final int executionCount;
    @SerializedName(value="user_expressions")
    protected final Map<String, ExpressionValue> evaluatedUserExpr;

    @Override
    public MessageType<ExecuteReply> getType() {
        return MESSAGE_TYPE;
    }

    @Override
    public MessageType<ExecuteRequest> getRequestType() {
        return REQUEST_MESSAGE_TYPE;
    }

    public ExecuteReply(int executionCount, Map<String, ExpressionValue> evaluatedUserExpr) {
        this.status = Status.OK;
        this.executionCount = executionCount;
        this.evaluatedUserExpr = evaluatedUserExpr;
    }

    public ExecuteReply(int executionCount) {
        this.status = Status.ERROR;
        this.executionCount = executionCount;
        this.evaluatedUserExpr = null;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public Map<String, ExpressionValue> getEvaluatedUserExpr() {
        return this.evaluatedUserExpr;
    }

    public static enum Status {
        OK,
        ERROR;

    }
}

