/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.launcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KernelLauncher {
    private static final String JJAVA_JVM_OPTS = "JJAVA_JVM_OPTS";
    private final List<String> args;

    public KernelLauncher(List<String> args) {
        this.args = args;
    }

    public int launchKernel() {
        List<String> command = this.buildCommand(this.args);
        System.out.println("Running JJava Kernel with args: " + command);
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.inheritIO();
            Process kernel = pb.start();
            this.addShutdownHook(kernel);
            return kernel.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void addShutdownHook(Process kernel) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("Launcher is shutting down, terminating the kernel...");
            kernel.destroy();
            try {
                kernel.waitFor();
                System.out.println("Kernel terminated.");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private List<String> buildCommand(List<String> args) {
        if (args.size() < 2) {
            throw new RuntimeException(this.buildErrorMessage(args));
        }
        String kernelPath = args.get(0);
        String connectionFile = args.get(1);
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        String jvmOptions = System.getenv(JJAVA_JVM_OPTS);
        if (jvmOptions != null && !jvmOptions.isBlank()) {
            String[] options = jvmOptions.split("\\s+");
            command.addAll(Arrays.asList(options));
        }
        command.add("--add-opens");
        command.add("jdk.jshell/jdk.jshell=ALL-UNNAMED");
        command.add("-jar");
        command.add(kernelPath);
        command.add(connectionFile);
        return command;
    }

    private String buildErrorMessage(List<String> args) {
        if (args.isEmpty()) {
            return String.format("Missing arguments: <kernel_path> <connection_file>%n", new Object[0]);
        }
        if (args.size() < 2) {
            return String.format("Missing arguments: %s <connection_file>%n", args.get(0));
        }
        return String.format("Arguments provided: %s%n", String.join((CharSequence)", ", args));
    }
}

