/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.apache.ivy.ant;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;
import org.dflib.jjava.shaded.org.apache.ivy.core.settings.IvyVariableContainer;
import org.dflib.jjava.shaded.org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.dflib.jjava.shaded.org.apache.ivy.util.Message;

class IvyAntVariableContainer
extends IvyVariableContainerImpl
implements IvyVariableContainer {
    private Map<String, String> overwrittenProperties = new HashMap<String, String>();
    private Project project;

    public IvyAntVariableContainer(Project project) {
        this.project = project;
    }

    @Override
    public String getVariable(String name) {
        String r = this.overwrittenProperties.get(name);
        if (r == null) {
            r = this.project.getProperty(name);
        }
        if (r == null) {
            r = super.getVariable(name);
        }
        return r;
    }

    @Override
    public void setVariable(String varName, String value, boolean overwrite) {
        if (overwrite) {
            Message.debug("setting '" + varName + "' to '" + value + "'");
            this.overwrittenProperties.put(varName, this.substitute(value));
        } else {
            super.setVariable(varName, value, overwrite);
        }
    }

    public void updateProject(String id) {
        HashMap<String, String> r = new HashMap<String, String>(super.getVariables());
        r.putAll(this.overwrittenProperties);
        for (Map.Entry entry : r.entrySet()) {
            this.setPropertyIfNotSet((String)entry.getKey(), (String)entry.getValue());
            if (id == null) continue;
            this.setPropertyIfNotSet((String)entry.getKey() + "." + id, (String)entry.getValue());
        }
        if (this.getEnvironmentPrefix() != null) {
            Property propTask = new Property();
            propTask.setProject(this.project);
            propTask.setEnvironment(this.getEnvironmentPrefix());
            propTask.init();
            propTask.execute();
        }
    }

    private void setPropertyIfNotSet(String property, String value) {
        if (this.project.getProperty(property) == null) {
            this.project.setProperty(property, value);
        }
    }

    @Override
    public Object clone() {
        IvyAntVariableContainer result = (IvyAntVariableContainer)super.clone();
        result.overwrittenProperties = (HashMap)((HashMap)this.overwrittenProperties).clone();
        return result;
    }
}

