/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.apache.ivy.core;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.dflib.jjava.shaded.org.apache.ivy.Ivy;
import org.dflib.jjava.shaded.org.apache.ivy.core.event.EventManager;
import org.dflib.jjava.shaded.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.dflib.jjava.shaded.org.apache.ivy.core.resolve.ResolveData;
import org.dflib.jjava.shaded.org.apache.ivy.core.settings.IvySettings;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.dflib.jjava.shaded.org.apache.ivy.util.Message;
import org.dflib.jjava.shaded.org.apache.ivy.util.MessageLogger;

public class IvyContext {
    private static ThreadLocal<Stack<IvyContext>> current = new ThreadLocal();
    private Ivy defaultIvy;
    private WeakReference<Ivy> ivy = new WeakReference<Object>(null);
    private Map<String, Object> contextMap = new HashMap<String, Object>();
    private Thread operatingThread;
    private ResolveData resolveData;
    private DependencyDescriptor dd;

    public IvyContext() {
    }

    public IvyContext(IvyContext ctx) {
        this.defaultIvy = ctx.defaultIvy;
        this.ivy = ctx.ivy;
        this.contextMap = new HashMap<String, Object>(ctx.contextMap);
        this.operatingThread = ctx.operatingThread;
        this.resolveData = ctx.resolveData;
        this.dd = ctx.dd;
    }

    public static IvyContext getContext() {
        Stack<IvyContext> cur = IvyContext.getCurrentStack();
        if (cur.isEmpty()) {
            cur.push(new IvyContext());
        }
        return cur.peek();
    }

    private static Stack<IvyContext> getCurrentStack() {
        Stack<IvyContext> cur = current.get();
        if (cur == null) {
            cur = new Stack();
            current.set(cur);
        }
        return cur;
    }

    public static IvyContext pushNewContext() {
        return IvyContext.pushContext(new IvyContext());
    }

    public static IvyContext pushNewCopyContext() {
        return IvyContext.pushContext(new IvyContext(IvyContext.getContext()));
    }

    public static IvyContext pushContext(IvyContext context) {
        IvyContext.getCurrentStack().push(context);
        return context;
    }

    public static IvyContext popContext() {
        return IvyContext.getCurrentStack().pop();
    }

    public static Object peekInContextStack(String key) {
        Object value = null;
        Stack<IvyContext> contextStack = IvyContext.getCurrentStack();
        for (int i = contextStack.size() - 1; i >= 0 && value == null; --i) {
            IvyContext ctx = (IvyContext)contextStack.get(i);
            value = ctx.peek(key);
        }
        return value;
    }

    public Ivy getIvy() {
        Ivy ivy = this.peekIvy();
        return ivy == null ? this.getDefaultIvy() : ivy;
    }

    public Ivy peekIvy() {
        return (Ivy)this.ivy.get();
    }

    private Ivy getDefaultIvy() {
        if (this.defaultIvy == null) {
            this.defaultIvy = Ivy.newInstance();
            try {
                this.defaultIvy.configureDefault();
            }
            catch (Exception e) {
                Message.debug(e);
            }
        }
        return this.defaultIvy;
    }

    public void setIvy(Ivy ivy) {
        this.ivy = new WeakReference<Ivy>(ivy);
        this.operatingThread = Thread.currentThread();
    }

    public IvySettings getSettings() {
        return this.getIvy().getSettings();
    }

    public CircularDependencyStrategy getCircularDependencyStrategy() {
        return this.getSettings().getCircularDependencyStrategy();
    }

    public <T> T get(String key) {
        WeakReference ref = (WeakReference)this.contextMap.get(key);
        return ref == null ? null : (T)ref.get();
    }

    public <T> void set(String key, T value) {
        this.contextMap.put(key, new WeakReference<T>(value));
    }

    public Object peek(String key) {
        Map<String, Object> map = this.contextMap;
        synchronized (map) {
            Object o = this.contextMap.get(key);
            if (o == null) {
                return null;
            }
            if (o instanceof List) {
                if (((List)o).size() == 0) {
                    return null;
                }
                return ((List)o).get(0);
            }
            throw new RuntimeException("Cannot top from non List object " + o);
        }
    }

    public Object pop(String key) {
        Map<String, Object> map = this.contextMap;
        synchronized (map) {
            Object o = this.contextMap.get(key);
            if (o == null) {
                return null;
            }
            if (o instanceof List) {
                if (((List)o).size() == 0) {
                    return null;
                }
                return ((List)o).remove(0);
            }
            throw new RuntimeException("Cannot pop from non List object " + o);
        }
    }

    public boolean pop(String key, Object expectedValue) {
        Map<String, Object> map = this.contextMap;
        synchronized (map) {
            Object o = this.contextMap.get(key);
            if (o == null) {
                return false;
            }
            if (o instanceof List) {
                if (((List)o).size() == 0) {
                    return false;
                }
                Object top = ((List)o).get(0);
                if (!top.equals(expectedValue)) {
                    return false;
                }
                ((List)o).remove(0);
                return true;
            }
            throw new RuntimeException("Cannot pop from non List object " + o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(String key, Object value) {
        Map<String, Object> map = this.contextMap;
        synchronized (map) {
            Object o;
            if (!this.contextMap.containsKey(key)) {
                this.contextMap.put(key, new LinkedList());
            }
            if (!((o = this.contextMap.get(key)) instanceof List)) {
                throw new RuntimeException("Cannot push to non List object " + o);
            }
            ((List)o).add(0, value);
        }
    }

    public Thread getOperatingThread() {
        return this.operatingThread;
    }

    public MessageLogger getMessageLogger() {
        Ivy ivy = this.peekIvy();
        if (ivy == null) {
            if (this.defaultIvy == null) {
                return Message.getDefaultLogger();
            }
            return this.defaultIvy.getLoggerEngine();
        }
        return ivy.getLoggerEngine();
    }

    public EventManager getEventManager() {
        return this.getIvy().getEventManager();
    }

    public void checkInterrupted() {
        this.getIvy().checkInterrupted();
    }

    public void setResolveData(ResolveData data) {
        this.resolveData = data;
    }

    public ResolveData getResolveData() {
        return this.resolveData;
    }

    public void setDependencyDescriptor(DependencyDescriptor dd) {
        this.dd = dd;
    }

    public DependencyDescriptor getDependencyDescriptor() {
        return this.dd;
    }
}

