/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.apache.ivy.core.cache;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dflib.jjava.shaded.org.apache.ivy.core.RelativeUrlResolver;
import org.dflib.jjava.shaded.org.apache.ivy.core.cache.ResolutionCacheManager;
import org.dflib.jjava.shaded.org.apache.ivy.core.module.id.ModuleId;
import org.dflib.jjava.shaded.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.dflib.jjava.shaded.org.apache.ivy.core.module.status.StatusManager;
import org.dflib.jjava.shaded.org.apache.ivy.core.settings.TimeoutConstraint;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.conflict.ConflictManager;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.matcher.PatternMatcher;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.namespace.Namespace;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.parser.ParserSettings;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.resolver.DependencyResolver;
import org.dflib.jjava.shaded.org.apache.ivy.util.Message;

class ParserSettingsMonitor {
    private ParserSettings delegatedSettings;
    private final Map<String, String> substitutes;
    private ParserSettings monitoredSettings = new ParserSettings(){

        @Override
        public ConflictManager getConflictManager(String name) {
            return ParserSettingsMonitor.this.delegatedSettings.getConflictManager(name);
        }

        @Override
        public PatternMatcher getMatcher(String matcherName) {
            return ParserSettingsMonitor.this.delegatedSettings.getMatcher(matcherName);
        }

        @Override
        public Namespace getNamespace(String namespace) {
            return ParserSettingsMonitor.this.delegatedSettings.getNamespace(namespace);
        }

        @Override
        public RelativeUrlResolver getRelativeUrlResolver() {
            return ParserSettingsMonitor.this.delegatedSettings.getRelativeUrlResolver();
        }

        @Override
        public ResolutionCacheManager getResolutionCacheManager() {
            return ParserSettingsMonitor.this.delegatedSettings.getResolutionCacheManager();
        }

        @Override
        public DependencyResolver getResolver(ModuleRevisionId mRevId) {
            return ParserSettingsMonitor.this.delegatedSettings.getResolver(mRevId);
        }

        @Override
        public StatusManager getStatusManager() {
            return ParserSettingsMonitor.this.delegatedSettings.getStatusManager();
        }

        @Override
        public File resolveFile(String filename) {
            return ParserSettingsMonitor.this.delegatedSettings.resolveFile(filename);
        }

        @Override
        public String getDefaultBranch(ModuleId moduleId) {
            return ParserSettingsMonitor.this.delegatedSettings.getDefaultBranch(moduleId);
        }

        @Override
        public Namespace getContextNamespace() {
            return ParserSettingsMonitor.this.delegatedSettings.getContextNamespace();
        }

        @Override
        public Map<String, String> substitute(Map<String, String> strings) {
            LinkedHashMap<String, String> substituted = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : strings.entrySet()) {
                substituted.put(entry.getKey(), this.substitute(entry.getValue()));
            }
            return substituted;
        }

        @Override
        public String substitute(String value) {
            String r = ParserSettingsMonitor.this.delegatedSettings.substitute(value);
            if (value != null && !value.equals(r)) {
                ParserSettingsMonitor.this.substitutes.put(value, r);
            }
            return r;
        }

        @Override
        public String getVariable(String value) {
            return ParserSettingsMonitor.this.delegatedSettings.getVariable(value);
        }

        @Override
        public TimeoutConstraint getTimeoutConstraint(String name) {
            return ParserSettingsMonitor.this.delegatedSettings.getTimeoutConstraint(name);
        }
    };

    public ParserSettingsMonitor(ParserSettings settings) {
        this.delegatedSettings = settings;
        this.substitutes = new HashMap<String, String>();
    }

    public ParserSettings getMonitoredSettings() {
        return this.monitoredSettings;
    }

    public void endMonitoring() {
        this.monitoredSettings = null;
        this.delegatedSettings = null;
    }

    public boolean hasChanged(ParserSettings newSettings) {
        for (Map.Entry<String, String> entry : this.substitutes.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue().equals(newSettings.substitute(key))) continue;
            Message.debug("settings variable has changed for : " + key);
            return true;
        }
        return false;
    }
}

