/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.apache.ivy.core.sort;

import java.util.LinkedList;
import java.util.List;
import org.dflib.jjava.shaded.org.apache.ivy.Ivy;
import org.dflib.jjava.shaded.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.dflib.jjava.shaded.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.dflib.jjava.shaded.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.circular.CircularDependencyHelper;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.version.VersionMatcher;
import org.dflib.jjava.shaded.org.apache.ivy.util.Message;

class ModuleInSort {
    private final ModuleDescriptor module;
    private boolean isSorted = false;
    private List<ModuleInSort> loopElements = new LinkedList<ModuleInSort>();
    private boolean isLoopIntermediateElement = false;
    private ModuleInSort caller;

    public ModuleInSort(ModuleDescriptor moduleToSort) {
        this.module = moduleToSort;
    }

    public boolean isInLoop() {
        return this.isLoopIntermediateElement;
    }

    public boolean isSorted() {
        if (this.isSorted) {
            Message.debug("Module descriptor already sorted : " + this.module.getModuleRevisionId().toString());
            return true;
        }
        return false;
    }

    public boolean isProcessed() {
        if (this.isSorted || this.isLoopIntermediateElement) {
            Message.debug("Module descriptor is processed : " + this.module.getModuleRevisionId().toString());
            return true;
        }
        return false;
    }

    public void setCaller(ModuleInSort caller) {
        this.caller = caller;
    }

    public void endOfCall() {
        this.caller = null;
    }

    public boolean checkLoop(ModuleInSort futurCaller, CircularDependencyStrategy depStrategy) {
        if (this.caller != null) {
            LinkedList<ModuleRevisionId> elemOfLoop = new LinkedList<ModuleRevisionId>();
            elemOfLoop.add(this.module.getModuleRevisionId());
            ModuleInSort stackEl = futurCaller;
            while (stackEl != this) {
                elemOfLoop.add(stackEl.module.getModuleRevisionId());
                stackEl.isLoopIntermediateElement = true;
                this.loopElements.add(stackEl);
                stackEl = stackEl.caller;
            }
            elemOfLoop.add(this.module.getModuleRevisionId());
            ModuleRevisionId[] mrids = elemOfLoop.toArray(new ModuleRevisionId[elemOfLoop.size()]);
            depStrategy.handleCircularDependency(mrids);
            return true;
        }
        return false;
    }

    public void addToSortedListIfRequired(List<ModuleDescriptor> sorted) {
        if (!this.isLoopIntermediateElement) {
            this.addToSortList(sorted);
        }
    }

    private void addToSortList(List<ModuleDescriptor> sortedList) {
        for (ModuleInSort moduleInLoop : this.loopElements) {
            moduleInLoop.addToSortList(sortedList);
        }
        if (!this.isSorted()) {
            sortedList.add(this.module);
            this.isSorted = true;
        }
    }

    public String toString() {
        return this.module.getModuleRevisionId().toString();
    }

    public DependencyDescriptor[] getDependencies() {
        return this.module.getDependencies();
    }

    public static void logLoopWarning(List<ModuleDescriptor> loopElement) {
        Message.warn("circular dependency detected during sort: " + CircularDependencyHelper.formatMessageFromDescriptors(loopElement));
    }

    public boolean match(DependencyDescriptor descriptor, VersionMatcher versionMatcher) {
        ModuleDescriptor md = this.module;
        return md.getResolvedModuleRevisionId().getRevision() == null || md.getResolvedModuleRevisionId().getRevision().equals(Ivy.getWorkingRevision()) || versionMatcher.accept(descriptor.getDependencyRevisionId(), md);
    }

    public ModuleDescriptor getSortedModuleDescriptor() {
        return this.module;
    }
}

