/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.apache.ivy.plugins.parser.m2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dflib.jjava.shaded.org.apache.ivy.core.IvyPatternHelper;
import org.dflib.jjava.shaded.org.apache.ivy.core.module.descriptor.License;
import org.dflib.jjava.shaded.org.apache.ivy.core.module.id.ModuleId;
import org.dflib.jjava.shaded.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.parser.m2.MavenVersionRangeParser;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.repository.Resource;
import org.dflib.jjava.shaded.org.apache.ivy.util.XMLHelper;
import org.dflib.jjava.shaded.org.apache.ivy.util.url.URLHandlerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PomReader {
    private static final String PROFILES_ELEMENT = "profiles";
    private static final String PACKAGING = "packaging";
    private static final String DEPENDENCY = "dependency";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEPENDENCY_MGT = "dependencyManagement";
    private static final String PROJECT = "project";
    private static final String MODEL = "model";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    private static final String DESCRIPTION = "description";
    private static final String HOMEPAGE = "url";
    private static final String LICENSES = "licenses";
    private static final String LICENSE = "license";
    private static final String LICENSE_NAME = "name";
    private static final String LICENSE_URL = "url";
    private static final String PARENT = "parent";
    private static final String SCOPE = "scope";
    private static final String CLASSIFIER = "classifier";
    private static final String OPTIONAL = "optional";
    private static final String EXCLUSIONS = "exclusions";
    private static final String EXCLUSION = "exclusion";
    private static final String DISTRIBUTION_MGT = "distributionManagement";
    private static final String RELOCATION = "relocation";
    private static final String PROPERTIES = "properties";
    private static final String PLUGINS = "plugins";
    private static final String PLUGIN = "plugin";
    private static final String TYPE = "type";
    private static final String PROFILE = "profile";
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Element projectElement;
    private final Element parentElement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomReader(URL descriptorURL, Resource res) throws IOException, SAXException {
        AddDTDFilterInputStream stream = new AddDTDFilterInputStream(URLHandlerRegistry.getDefault().openStream(descriptorURL));
        InputSource source = new InputSource(stream);
        source.setSystemId(XMLHelper.toSystemId(descriptorURL));
        try {
            Document pomDomDoc = XMLHelper.parseToDom(source, new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId != null && systemId.endsWith("m2-entities.ent")) {
                        return new InputSource(PomReader.class.getResourceAsStream("m2-entities.ent"));
                    }
                    return null;
                }
            }, true, XMLHelper.ExternalResources.IGNORE);
            this.projectElement = pomDomDoc.getDocumentElement();
            if (!PROJECT.equals(this.projectElement.getNodeName()) && !MODEL.equals(this.projectElement.getNodeName())) {
                throw new SAXParseException("project must be the root tag", res.getName(), res.getName(), 0, 0);
            }
            this.parentElement = PomReader.getFirstChildElement(this.projectElement, PARENT);
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException pomDomDoc) {}
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            this.setProperty("env." + (String)entry.getKey(), (String)entry.getValue());
        }
        Properties sysProps = System.getProperties();
        for (String sysProp : sysProps.stringPropertyNames()) {
            this.setProperty(sysProp, sysProps.getProperty(sysProp));
        }
    }

    public boolean hasParent() {
        return this.parentElement != null;
    }

    public void setProperty(String prop, String val) {
        if (!this.properties.containsKey(prop) && val != null) {
            this.properties.put(prop, val);
        }
    }

    public String getGroupId() {
        String groupId = PomReader.getFirstChildText(this.projectElement, GROUP_ID);
        if (groupId == null) {
            groupId = PomReader.getFirstChildText(this.parentElement, GROUP_ID);
        }
        return this.replaceProps(groupId);
    }

    public String getParentGroupId() {
        String groupId = PomReader.getFirstChildText(this.parentElement, GROUP_ID);
        if (groupId == null) {
            groupId = PomReader.getFirstChildText(this.projectElement, GROUP_ID);
        }
        return this.replaceProps(groupId);
    }

    public String getArtifactId() {
        String val = PomReader.getFirstChildText(this.projectElement, ARTIFACT_ID);
        if (val == null) {
            val = PomReader.getFirstChildText(this.parentElement, ARTIFACT_ID);
        }
        return this.replaceProps(val);
    }

    public String getParentArtifactId() {
        String val = PomReader.getFirstChildText(this.parentElement, ARTIFACT_ID);
        if (val == null) {
            val = PomReader.getFirstChildText(this.projectElement, ARTIFACT_ID);
        }
        return this.replaceProps(val);
    }

    public String getVersion() {
        String val = PomReader.getFirstChildText(this.projectElement, VERSION);
        if (val == null) {
            val = PomReader.getFirstChildText(this.parentElement, VERSION);
        }
        return this.replaceProps(val);
    }

    public String getParentVersion() {
        String val = PomReader.getFirstChildText(this.parentElement, VERSION);
        if (val == null) {
            val = PomReader.getFirstChildText(this.projectElement, VERSION);
        }
        return this.replaceProps(val);
    }

    public String getPackaging() {
        String val = PomReader.getFirstChildText(this.projectElement, PACKAGING);
        if (val == null) {
            return "jar";
        }
        return this.replaceProps(val);
    }

    public String getHomePage() {
        String val = PomReader.getFirstChildText(this.projectElement, "url");
        if (val == null) {
            val = "";
        }
        return val;
    }

    public String getDescription() {
        String val = PomReader.getFirstChildText(this.projectElement, DESCRIPTION);
        if (val == null) {
            val = "";
        }
        return val.trim();
    }

    public License[] getLicenses() {
        Element licenses = PomReader.getFirstChildElement(this.projectElement, LICENSES);
        if (licenses == null) {
            return new License[0];
        }
        licenses.normalize();
        ArrayList<License> lics = new ArrayList<License>();
        for (Element license : PomReader.getAllChilds(licenses)) {
            if (!LICENSE.equals(license.getNodeName())) continue;
            String name = PomReader.getFirstChildText(license, LICENSE_NAME);
            String url = PomReader.getFirstChildText(license, "url");
            if (name == null && url == null) continue;
            if (name == null) {
                name = "Unknown License";
            }
            lics.add(new License(name, url));
        }
        return lics.toArray(new License[lics.size()]);
    }

    public ModuleRevisionId getRelocation() {
        String relocVersion;
        String relocArtId;
        Element distrMgt = PomReader.getFirstChildElement(this.projectElement, DISTRIBUTION_MGT);
        Element relocation = PomReader.getFirstChildElement(distrMgt, RELOCATION);
        if (relocation == null) {
            return null;
        }
        String relocGroupId = PomReader.getFirstChildText(relocation, GROUP_ID);
        if (relocGroupId == null) {
            relocGroupId = this.getGroupId();
        }
        if ((relocArtId = PomReader.getFirstChildText(relocation, ARTIFACT_ID)) == null) {
            relocArtId = this.getArtifactId();
        }
        if ((relocVersion = PomReader.getFirstChildText(relocation, VERSION)) == null) {
            relocVersion = this.getVersion();
        }
        return ModuleRevisionId.newInstance(relocGroupId, relocArtId, relocVersion);
    }

    public List<PomDependencyData> getDependencies() {
        return this.getDependencies(this.projectElement);
    }

    private List<PomDependencyData> getDependencies(Element parent) {
        Element dependenciesElement = PomReader.getFirstChildElement(parent, DEPENDENCIES);
        if (dependenciesElement == null) {
            return Collections.emptyList();
        }
        LinkedList<PomDependencyData> dependencies = new LinkedList<PomDependencyData>();
        NodeList children = dependenciesElement.getChildNodes();
        int sz = children.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
            dependencies.add(new PomDependencyData((Element)node));
        }
        return dependencies;
    }

    public List<PomDependencyMgt> getDependencyMgt() {
        return this.getDependencyMgt(this.projectElement);
    }

    private List<PomDependencyMgt> getDependencyMgt(Element parent) {
        Element dependenciesElement = PomReader.getFirstChildElement(PomReader.getFirstChildElement(parent, DEPENDENCY_MGT), DEPENDENCIES);
        if (dependenciesElement == null) {
            return Collections.emptyList();
        }
        LinkedList<PomDependencyMgt> dependencies = new LinkedList<PomDependencyMgt>();
        NodeList children = dependenciesElement.getChildNodes();
        int sz = children.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
            dependencies.add(new PomDependencyMgtElement((Element)node));
        }
        return dependencies;
    }

    public List<PomProfileElement> getProfiles() {
        Element profilesElement = PomReader.getFirstChildElement(this.projectElement, PROFILES_ELEMENT);
        if (profilesElement == null) {
            return Collections.emptyList();
        }
        LinkedList<PomProfileElement> result = new LinkedList<PomProfileElement>();
        NodeList children = profilesElement.getChildNodes();
        int sz = children.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !PROFILE.equals(node.getNodeName())) continue;
            result.add(new PomProfileElement((Element)node));
        }
        return result;
    }

    public List<PomPluginElement> getPlugins() {
        return this.getPlugins(this.projectElement);
    }

    private List<PomPluginElement> getPlugins(Element parent) {
        Element buildElement = PomReader.getFirstChildElement(parent, "build");
        Element pluginsElement = PomReader.getFirstChildElement(buildElement, PLUGINS);
        if (pluginsElement == null) {
            return Collections.emptyList();
        }
        NodeList children = pluginsElement.getChildNodes();
        LinkedList<PomPluginElement> plugins = new LinkedList<PomPluginElement>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !PLUGIN.equals(node.getNodeName())) continue;
            plugins.add(new PomPluginElement((Element)node));
        }
        return plugins;
    }

    private static Map<String, String> getProperties(Element parent) {
        Element propsEl = PomReader.getFirstChildElement(parent, PROPERTIES);
        if (propsEl == null) {
            return Collections.emptyMap();
        }
        propsEl.normalize();
        HashMap<String, String> props = new HashMap<String, String>();
        for (Element prop : PomReader.getAllChilds(propsEl)) {
            props.put(prop.getNodeName(), PomReader.getTextContent(prop));
        }
        return props;
    }

    public Map<String, String> getPomProperties() {
        return new HashMap<String, String>(PomReader.getProperties(this.projectElement));
    }

    private String replaceProps(String val) {
        if (val == null) {
            return null;
        }
        return IvyPatternHelper.substituteVariables(val, this.properties).trim();
    }

    private static String getTextContent(Element element) {
        StringBuilder result = new StringBuilder();
        NodeList childNodes = element.getChildNodes();
        block3: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    result.append(child.getNodeValue());
                    continue block3;
                }
            }
        }
        return result.toString();
    }

    private static String getFirstChildText(Element parentElem, String name) {
        Element node = PomReader.getFirstChildElement(parentElem, name);
        if (node != null) {
            return PomReader.getTextContent(node);
        }
        return null;
    }

    private static Element getFirstChildElement(Element parentElem, String name) {
        if (parentElem == null) {
            return null;
        }
        NodeList childs = parentElem.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!(node instanceof Element) || !name.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    private static List<Element> getAllChilds(Element parent) {
        LinkedList<Element> r = new LinkedList<Element>();
        if (parent != null) {
            NodeList childs = parent.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element)) continue;
                r.add((Element)node);
            }
        }
        return r;
    }

    private static final class AddDTDFilterInputStream
    extends FilterInputStream {
        private static final int MARK = 10000;
        private static final String DOCTYPE = "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n";
        private int count;
        private byte[] prefix = "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n".getBytes();

        private AddDTDFilterInputStream(InputStream in) throws IOException {
            super(new BufferedInputStream(in));
            this.in.mark(10000);
            int byte1 = this.in.read();
            int byte2 = this.in.read();
            int byte3 = this.in.read();
            if (byte1 == 239 && byte2 == 187 && byte3 == 191) {
                this.in.mark(10000);
            } else {
                this.in.reset();
            }
            int bytesToSkip = 0;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.in, StandardCharsets.UTF_8), 100);
            String firstLine = reader.readLine();
            if (firstLine != null) {
                String trimmed = firstLine.trim();
                if (trimmed.startsWith("<?xml ")) {
                    int endIndex = trimmed.indexOf("?>");
                    String xmlDecl = trimmed.substring(0, endIndex + 2);
                    this.prefix = (xmlDecl + "\n" + DOCTYPE).getBytes();
                    bytesToSkip = xmlDecl.getBytes().length;
                }
            } else {
                this.prefix = new byte[0];
            }
            this.in.reset();
            for (int i = 0; i < bytesToSkip; ++i) {
                this.in.read();
            }
        }

        @Override
        public int read() throws IOException {
            if (this.count < this.prefix.length) {
                return this.prefix[this.count++];
            }
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int nbrBytesCopied = 0;
            if (this.count < this.prefix.length) {
                int nbrBytesFromPrefix = Math.min(this.prefix.length - this.count, len);
                System.arraycopy(this.prefix, this.count, b, off, nbrBytesFromPrefix);
                nbrBytesCopied = nbrBytesFromPrefix;
            }
            if (nbrBytesCopied < len) {
                nbrBytesCopied += this.in.read(b, off + nbrBytesCopied, len - nbrBytesCopied);
            }
            this.count += nbrBytesCopied;
            return nbrBytesCopied;
        }
    }

    public class PomProfileElement {
        private static final String VALUE = "value";
        private static final String NAME = "name";
        private static final String PROPERTY = "property";
        private static final String ID_ELEMENT = "id";
        private static final String ACTIVATION_ELEMENT = "activation";
        private static final String ACTIVE_BY_DEFAULT_ELEMENT = "activeByDefault";
        private static final String OS = "os";
        private static final String FAMILY = "family";
        private static final String VERSION = "version";
        private static final String ARCH = "arch";
        private static final String FILE = "file";
        private static final String MISSING = "missing";
        private static final String EXISTS = "exists";
        private static final String JDK = "jdk";
        private final Element profileElement;

        PomProfileElement(Element profileElement) {
            this.profileElement = profileElement;
        }

        public String getId() {
            return PomReader.getFirstChildText(this.profileElement, ID_ELEMENT);
        }

        public boolean isActive() {
            return this.isActiveByDefault() || this.isActivatedByProperty() || this.isActiveByOS() || this.isActiveByJDK() || this.isActiveByFile();
        }

        public boolean isActiveByDefault() {
            Element activation = PomReader.getFirstChildElement(this.profileElement, ACTIVATION_ELEMENT);
            return Boolean.parseBoolean(PomReader.getFirstChildText(activation, ACTIVE_BY_DEFAULT_ELEMENT));
        }

        public boolean isActiveByOS() {
            Element activation = PomReader.getFirstChildElement(this.profileElement, ACTIVATION_ELEMENT);
            if (activation == null) {
                return false;
            }
            Element osActivation = PomReader.getFirstChildElement(activation, OS);
            if (osActivation == null) {
                return false;
            }
            String actualOS = System.getProperty("os.name");
            String expectedOSName = PomReader.getFirstChildText(osActivation, "name");
            if (expectedOSName != null && !actualOS.equals(expectedOSName.trim())) {
                return false;
            }
            String expectedOSFamily = PomReader.getFirstChildText(osActivation, FAMILY);
            if (expectedOSFamily != null && !actualOS.contains(expectedOSFamily.trim())) {
                return false;
            }
            String expectedOSArch = PomReader.getFirstChildText(osActivation, ARCH);
            if (expectedOSArch != null && !System.getProperty("os.arch").equals(expectedOSArch.trim())) {
                return false;
            }
            String expectedOSVersion = PomReader.getFirstChildText(osActivation, "version");
            if (expectedOSVersion != null && !System.getProperty("os.version").equals(expectedOSVersion.trim())) {
                return false;
            }
            return expectedOSName != null || expectedOSFamily != null || expectedOSArch != null || expectedOSVersion != null;
        }

        public boolean isActiveByJDK() {
            Element activation = PomReader.getFirstChildElement(this.profileElement, ACTIVATION_ELEMENT);
            if (activation == null) {
                return false;
            }
            String expectedJDKRange = PomReader.getFirstChildText(activation, JDK);
            if (expectedJDKRange == null) {
                return false;
            }
            boolean negate = expectedJDKRange.trim().startsWith("!");
            String nonNegatedRange = negate ? expectedJDKRange.substring(1).trim() : expectedJDKRange.trim();
            boolean javaVersionInRange = MavenVersionRangeParser.currentJavaVersionInRange(nonNegatedRange);
            return javaVersionInRange ^ negate;
        }

        public boolean isActiveByFile() {
            Element activation = PomReader.getFirstChildElement(this.profileElement, ACTIVATION_ELEMENT);
            if (activation == null) {
                return false;
            }
            Element fileActivation = PomReader.getFirstChildElement(activation, FILE);
            if (fileActivation == null) {
                return false;
            }
            String expectedMissing = PomReader.getFirstChildText(fileActivation, MISSING);
            if (expectedMissing != null && new File(expectedMissing.trim()).exists()) {
                return false;
            }
            String expectedExists = PomReader.getFirstChildText(fileActivation, EXISTS);
            if (expectedExists != null && !new File(expectedExists.trim()).exists()) {
                return false;
            }
            return expectedMissing != null || expectedExists != null;
        }

        public boolean isActivatedByProperty() {
            boolean negate;
            Element activation = PomReader.getFirstChildElement(this.profileElement, ACTIVATION_ELEMENT);
            Element propertyActivation = PomReader.getFirstChildElement(activation, PROPERTY);
            String propertyName = PomReader.getFirstChildText(propertyActivation, "name");
            if (propertyName == null || "".equals(propertyName)) {
                return false;
            }
            boolean bl = negate = propertyName.charAt(0) == '!';
            if (negate) {
                propertyName = propertyName.substring(1);
            }
            if ("".equals(propertyName)) {
                return false;
            }
            String propertyValue = PomReader.getFirstChildText(propertyActivation, VALUE);
            boolean matched = propertyValue == null || "".equals(propertyValue) ? PomReader.this.properties.containsKey(propertyName) : propertyValue.equals(PomReader.this.properties.get(propertyName));
            return matched ^ negate;
        }

        public List<PomDependencyData> getDependencies() {
            return PomReader.this.getDependencies(this.profileElement);
        }

        public List<PomDependencyMgt> getDependencyMgt() {
            return PomReader.this.getDependencyMgt(this.profileElement);
        }

        public List<PomPluginElement> getPlugins() {
            return PomReader.this.getPlugins(this.profileElement);
        }

        public Map<String, String> getProfileProperties() {
            return PomReader.getProperties(this.profileElement);
        }
    }

    public class PomDependencyData
    extends PomDependencyMgtElement {
        private final Element depElement;

        public PomDependencyData(PomDependencyData copyFrom) {
            this(copyFrom.depElement);
        }

        PomDependencyData(Element depElement) {
            super(depElement);
            this.depElement = depElement;
        }

        @Override
        public String getScope() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.SCOPE);
            return this.emptyIsNull(PomReader.this.replaceProps(val));
        }

        public String getClassifier() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.CLASSIFIER);
            return this.emptyIsNull(PomReader.this.replaceProps(val));
        }

        public String getType() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.TYPE);
            return this.emptyIsNull(PomReader.this.replaceProps(val));
        }

        public boolean isOptional() {
            return Boolean.parseBoolean(PomReader.getFirstChildText(this.depElement, PomReader.OPTIONAL));
        }

        private String emptyIsNull(String val) {
            if (val == null) {
                return null;
            }
            return val.equals("") ? null : val;
        }
    }

    public class PomPluginElement
    implements PomDependencyMgt {
        private Element pluginElement;

        PomPluginElement(Element pluginElement) {
            this.pluginElement = pluginElement;
        }

        @Override
        public String getGroupId() {
            String val = PomReader.getFirstChildText(this.pluginElement, PomReader.GROUP_ID);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getArtifactId() {
            String val = PomReader.getFirstChildText(this.pluginElement, PomReader.ARTIFACT_ID);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getVersion() {
            String val = PomReader.getFirstChildText(this.pluginElement, PomReader.VERSION);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getScope() {
            return null;
        }

        @Override
        public List<ModuleId> getExcludedModules() {
            return Collections.emptyList();
        }
    }

    public class PomDependencyMgtElement
    implements PomDependencyMgt {
        private final Element depElement;

        public PomDependencyMgtElement(PomDependencyMgtElement copyFrom) {
            this(copyFrom.depElement);
        }

        PomDependencyMgtElement(Element depElement) {
            this.depElement = depElement;
        }

        @Override
        public String getGroupId() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.GROUP_ID);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getArtifactId() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.ARTIFACT_ID);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getVersion() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.VERSION);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getScope() {
            String val = PomReader.getFirstChildText(this.depElement, PomReader.SCOPE);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public List<ModuleId> getExcludedModules() {
            Element exclusionsElement = PomReader.getFirstChildElement(this.depElement, PomReader.EXCLUSIONS);
            if (exclusionsElement == null) {
                return Collections.emptyList();
            }
            LinkedList<ModuleId> exclusions = new LinkedList<ModuleId>();
            NodeList children = exclusionsElement.getChildNodes();
            int sz = children.getLength();
            for (int i = 0; i < sz; ++i) {
                Node node = children.item(i);
                if (!(node instanceof Element) || !PomReader.EXCLUSION.equals(node.getNodeName())) continue;
                String groupId = PomReader.getFirstChildText((Element)node, PomReader.GROUP_ID);
                String artifactId = PomReader.getFirstChildText((Element)node, PomReader.ARTIFACT_ID);
                if (groupId == null || artifactId == null) continue;
                exclusions.add(ModuleId.newInstance(groupId, artifactId));
            }
            return exclusions;
        }
    }
}

