/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.apache.ivy.plugins.repository.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.dflib.jjava.shaded.org.apache.ivy.core.settings.TimeoutConstraint;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.repository.LocalizableResource;
import org.dflib.jjava.shaded.org.apache.ivy.plugins.repository.Resource;
import org.dflib.jjava.shaded.org.apache.ivy.util.url.TimeoutConstrainedURLHandler;
import org.dflib.jjava.shaded.org.apache.ivy.util.url.URLHandler;
import org.dflib.jjava.shaded.org.apache.ivy.util.url.URLHandlerRegistry;

public class URLResource
implements LocalizableResource {
    private final URL url;
    private final TimeoutConstraint timeoutConstraint;
    private boolean init = false;
    private long lastModified;
    private long contentLength;
    private boolean exists;

    public URLResource(URL url) {
        this(url, null);
    }

    public URLResource(URL url, TimeoutConstraint timeoutConstraint) {
        this.url = url;
        this.timeoutConstraint = timeoutConstraint;
    }

    @Override
    public String getName() {
        return this.url.toExternalForm();
    }

    @Override
    public Resource clone(String cloneName) {
        try {
            return new URLResource(new URL(cloneName));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("bad clone name provided: not suitable for an URLResource: " + cloneName);
        }
    }

    @Override
    public long getLastModified() {
        if (!this.init) {
            this.init();
        }
        return this.lastModified;
    }

    private void init() {
        URLHandler handler = URLHandlerRegistry.getDefault();
        URLHandler.URLInfo info = handler instanceof TimeoutConstrainedURLHandler ? ((TimeoutConstrainedURLHandler)handler).getURLInfo(this.url, this.timeoutConstraint) : handler.getURLInfo(this.url);
        this.contentLength = info.getContentLength();
        this.lastModified = info.getLastModified();
        this.exists = info.isReachable();
        this.init = true;
    }

    @Override
    public long getContentLength() {
        if (!this.init) {
            this.init();
        }
        return this.contentLength;
    }

    @Override
    public boolean exists() {
        if (!this.init) {
            this.init();
        }
        return this.exists;
    }

    public URL getURL() {
        return this.url;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isLocal() {
        return this.url.getProtocol().equals("file");
    }

    @Override
    public InputStream openStream() throws IOException {
        URLHandler handler = URLHandlerRegistry.getDefault();
        if (handler instanceof TimeoutConstrainedURLHandler) {
            return ((TimeoutConstrainedURLHandler)handler).openStream(this.url, this.timeoutConstraint);
        }
        return handler.openStream(this.url);
    }

    @Override
    public File getFile() {
        if (!this.isLocal()) {
            throw new IllegalStateException("Cannot get the local file for the not local resource " + this.url);
        }
        try {
            return new File(this.url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(this.url.getPath());
        }
    }
}

