/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.dflib.jjava.shaded.org.apache.ivy.util.FileUtil;

public final class ChecksumHelper {
    private static final int BUFFER_SIZE = 2048;
    private static final Map<String, String> algorithms = new HashMap<String, String>();
    private static final char[] CHARS;

    private static boolean isAlgorithmSupportedInJRE(String algorithm) {
        if (algorithm == null) {
            return false;
        }
        try {
            MessageDigest.getInstance(algorithm);
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public static void check(File dest, File checksumFile, String algorithm) throws IOException {
        String expected;
        String csFileContent = FileUtil.readEntirely(new BufferedReader(new FileReader(checksumFile))).trim().toLowerCase(Locale.US);
        if (csFileContent.indexOf(32) > -1 && (csFileContent.startsWith("md") || csFileContent.startsWith("sha"))) {
            int lastSpaceIndex = csFileContent.lastIndexOf(32);
            expected = csFileContent.substring(lastSpaceIndex + 1);
        } else {
            int spaceIndex = csFileContent.indexOf(32);
            if (spaceIndex != -1) {
                expected = csFileContent.substring(0, spaceIndex);
                if (expected.endsWith(":")) {
                    StringBuilder result = new StringBuilder();
                    for (char ch : csFileContent.substring(spaceIndex + 1).toCharArray()) {
                        if (Character.isWhitespace(ch)) continue;
                        result.append(ch);
                    }
                    expected = result.toString();
                }
            } else {
                expected = csFileContent;
            }
        }
        String computed = ChecksumHelper.computeAsString(dest, algorithm).trim().toLowerCase(Locale.US);
        if (!expected.equals(computed)) {
            throw new IOException("invalid " + algorithm + ": expected=" + expected + " computed=" + computed);
        }
    }

    public static String computeAsString(File f, String algorithm) throws IOException {
        return ChecksumHelper.byteArrayToHexString(ChecksumHelper.compute(f, algorithm));
    }

    private static byte[] compute(File f, String algorithm) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            MessageDigest md = ChecksumHelper.getMessageDigest(algorithm);
            md.reset();
            byte[] buf = new byte[2048];
            int len = 0;
            while ((len = ((InputStream)is).read(buf)) != -1) {
                md.update(buf, 0, len);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
    }

    public static boolean isKnownAlgorithm(String algorithm) {
        return algorithms.containsKey(algorithm);
    }

    private static MessageDigest getMessageDigest(String algorithm) {
        String mdAlgorithm = algorithms.get(algorithm);
        if (mdAlgorithm == null) {
            throw new IllegalArgumentException("unknown algorithm " + algorithm);
        }
        try {
            return MessageDigest.getInstance(mdAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("unknown algorithm " + algorithm);
        }
    }

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        StringBuilder out = new StringBuilder(in.length * 2);
        for (byte bt : in) {
            ch = (byte)(bt & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(CHARS[ch]);
            ch = (byte)(bt & 0xF);
            out.append(CHARS[ch]);
        }
        return out.toString();
    }

    private ChecksumHelper() {
    }

    static {
        algorithms.put("md5", "MD5");
        algorithms.put("sha1", "SHA-1");
        if (ChecksumHelper.isAlgorithmSupportedInJRE("SHA-256")) {
            algorithms.put("SHA-256", "SHA-256");
        }
        if (ChecksumHelper.isAlgorithmSupportedInJRE("SHA-512")) {
            algorithms.put("SHA-512", "SHA-512");
        }
        if (ChecksumHelper.isAlgorithmSupportedInJRE("SHA-384")) {
            algorithms.put("SHA-384", "SHA-384");
        }
        CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

