/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.apache.ivy.util.url;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dflib.jjava.shaded.org.apache.ivy.util.FileUtil;
import org.dflib.jjava.shaded.org.apache.ivy.util.Message;
import org.dflib.jjava.shaded.org.apache.ivy.util.url.URLHandler;
import org.dflib.jjava.shaded.org.apache.ivy.util.url.URLHandlerRegistry;

public class ApacheURLLister {
    private static final Pattern PATTERN = Pattern.compile("<a[^>]*href=\"([^\"]*)\"[^>]*>(?:<[^>]+>)*?([^<>]+?)(?:<[^>]+>)*?</a>", 2);

    public List<URL> listAll(URL url) throws IOException {
        return this.retrieveListing(url, true, true);
    }

    public List<URL> listDirectories(URL url) throws IOException {
        return this.retrieveListing(url, false, true);
    }

    public List<URL> listFiles(URL url) throws IOException {
        return this.retrieveListing(url, true, false);
    }

    public List<URL> retrieveListing(URL url, boolean includeFiles, boolean includeDirectories) throws IOException {
        URLHandler urlHandler;
        URLHandler.URLInfo urlInfo;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (!url.getPath().endsWith("/") && !url.getPath().endsWith(".html")) {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath() + "/");
        }
        if ((urlInfo = (urlHandler = URLHandlerRegistry.getDefault()).getURLInfo(url)) == URLHandler.UNAVAILABLE) {
            return urlList;
        }
        String charset = urlInfo.getBodyCharset();
        InputStream contentStream = urlHandler.openStream(url);
        BufferedReader r = null;
        r = charset == null ? new BufferedReader(new InputStreamReader(contentStream)) : new BufferedReader(new InputStreamReader(contentStream, charset));
        String htmlText = FileUtil.readEntirely(r);
        Matcher matcher = PATTERN.matcher(htmlText);
        while (matcher.find()) {
            boolean directory;
            String strippedText;
            String strippedHref;
            String text;
            String href;
            block10: {
                href = matcher.group(1);
                text = matcher.group(2);
                if (href == null || text == null) continue;
                text = text.trim();
                try {
                    URI uri = new URI(href);
                    href = uri.getPath();
                    if (uri.getScheme() == null) break block10;
                    if (!href.startsWith(url.getPath())) continue;
                    href = href.substring(url.getPath().length());
                }
                catch (URISyntaxException e) {
                    continue;
                }
            }
            if (href.startsWith("../")) continue;
            if (href.startsWith("/")) {
                int slashIndex = href.substring(0, href.length() - 1).lastIndexOf(47);
                href = href.substring(slashIndex + 1);
            }
            if (href.startsWith("./")) {
                href = href.substring("./".length());
            }
            if (text.endsWith("..>")) {
                if (!href.startsWith(text.substring(0, text.length() - 3))) {
                    continue;
                }
            } else if (!text.endsWith("..&gt;") ? !(strippedHref = href.endsWith("/") ? href.substring(0, href.length() - 1) : href).equalsIgnoreCase(strippedText = text.endsWith("/") ? text.substring(0, text.length() - 1) : text) : !href.startsWith(text.substring(0, text.length() - 6))) continue;
            if ((!(directory = href.endsWith("/")) || !includeDirectories) && (directory || !includeFiles)) continue;
            URL child = new URL(url, href);
            urlList.add(child);
            Message.debug("ApacheURLLister found URL=[" + child + "].");
        }
        return urlList;
    }
}

