/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.zeromq.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.dflib.jjava.shaded.org.zeromq.util.ZData;

public class ZDigest {
    private final byte[] buffer;
    private final MessageDigest sha1;

    public ZDigest() {
        this(new byte[8192]);
    }

    public ZDigest(byte[] buffer) {
        this.buffer = buffer;
        try {
            this.sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public ZDigest update(InputStream input) throws IOException {
        int read = input.read(this.buffer);
        while (read != -1) {
            this.sha1.update(this.buffer, 0, read);
            read = input.read(this.buffer);
        }
        return this;
    }

    public ZDigest update(byte[] input) {
        return this.update(input, 0, input.length);
    }

    public ZDigest update(byte[] input, int offset, int length) {
        this.sha1.update(input, offset, length);
        return this;
    }

    public byte[] data() {
        return this.sha1.digest();
    }

    public int size() {
        return this.sha1.digest().length;
    }

    public String string() {
        return ZData.toString(this.data());
    }
}

