/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dflib.jjava.jupyter.channels.JupyterConnection;
import org.dflib.jjava.jupyter.channels.JupyterSocket;
import org.dflib.jjava.jupyter.channels.ShellReplyEnvironment;
import org.dflib.jjava.jupyter.kernel.JupyterIO;
import org.dflib.jjava.jupyter.kernel.LanguageInfo;
import org.dflib.jjava.jupyter.kernel.ReplacementOptions;
import org.dflib.jjava.jupyter.kernel.comm.CommManager;
import org.dflib.jjava.jupyter.kernel.display.DisplayData;
import org.dflib.jjava.jupyter.kernel.display.Renderer;
import org.dflib.jjava.jupyter.kernel.display.common.Image;
import org.dflib.jjava.jupyter.kernel.display.common.Text;
import org.dflib.jjava.jupyter.kernel.display.common.Url;
import org.dflib.jjava.jupyter.kernel.history.HistoryEntry;
import org.dflib.jjava.jupyter.kernel.history.HistoryManager;
import org.dflib.jjava.jupyter.kernel.util.StringStyler;
import org.dflib.jjava.jupyter.kernel.util.TextColor;
import org.dflib.jjava.jupyter.messages.Message;
import org.dflib.jjava.jupyter.messages.MessageType;
import org.dflib.jjava.jupyter.messages.publish.PublishError;
import org.dflib.jjava.jupyter.messages.publish.PublishExecuteInput;
import org.dflib.jjava.jupyter.messages.publish.PublishExecuteResult;
import org.dflib.jjava.jupyter.messages.reply.CompleteReply;
import org.dflib.jjava.jupyter.messages.reply.ErrorReply;
import org.dflib.jjava.jupyter.messages.reply.ExecuteReply;
import org.dflib.jjava.jupyter.messages.reply.HistoryReply;
import org.dflib.jjava.jupyter.messages.reply.InspectReply;
import org.dflib.jjava.jupyter.messages.reply.InterruptReply;
import org.dflib.jjava.jupyter.messages.reply.IsCompleteReply;
import org.dflib.jjava.jupyter.messages.reply.KernelInfoReply;
import org.dflib.jjava.jupyter.messages.reply.ShutdownReply;
import org.dflib.jjava.jupyter.messages.request.CompleteRequest;
import org.dflib.jjava.jupyter.messages.request.ExecuteRequest;
import org.dflib.jjava.jupyter.messages.request.HistoryRequest;
import org.dflib.jjava.jupyter.messages.request.InspectRequest;
import org.dflib.jjava.jupyter.messages.request.InterruptRequest;
import org.dflib.jjava.jupyter.messages.request.IsCompleteRequest;
import org.dflib.jjava.jupyter.messages.request.KernelInfoRequest;
import org.dflib.jjava.jupyter.messages.request.ShutdownRequest;
import org.dflib.jjava.shaded.com.google.gson.Gson;
import org.dflib.jjava.shaded.com.google.gson.reflect.TypeToken;

public abstract class BaseKernel {
    protected final AtomicInteger executionCount = new AtomicInteger(1);
    protected static final Map<String, String> KERNEL_META;
    private final JupyterIO io;
    private boolean shouldReplaceStdStreams;
    protected CommManager commManager;
    protected Renderer renderer;
    protected StringStyler errorStyler;
    protected static final String IS_COMPLETE_YES = "complete";
    protected static final String IS_COMPLETE_BAD = "invalid";
    protected static final String IS_COMPLETE_MAYBE = "unknown";

    public BaseKernel(Charset charset) {
        this.io = new JupyterIO(charset);
        this.shouldReplaceStdStreams = true;
        this.commManager = new CommManager();
        this.renderer = new Renderer();
        Image.registerAll(this.renderer);
        Url.registerAll(this.renderer);
        Text.registerAll(this.renderer);
        this.errorStyler = new StringStyler.Builder().addPrimaryStyle(TextColor.BOLD_RESET_FG).addSecondaryStyle(TextColor.BOLD_RED_FG).addHighlightStyle(TextColor.BOLD_RESET_FG).addHighlightStyle(TextColor.RED_BG).build();
    }

    public BaseKernel() {
        this(JupyterSocket.UTF_8);
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void display(DisplayData data) {
        this.io.display.display(data);
    }

    public JupyterIO getIO() {
        return this.io;
    }

    public CommManager getCommManager() {
        return this.commManager;
    }

    public boolean shouldReplaceStdStreams() {
        return this.shouldReplaceStdStreams;
    }

    public void setShouldReplaceStdStreams(boolean shouldReplaceStdStreams) {
        this.shouldReplaceStdStreams = shouldReplaceStdStreams;
    }

    public String getBanner() {
        LanguageInfo info = this.getLanguageInfo();
        return info != null ? info.getName() + " - " + info.getVersion() : "";
    }

    public List<LanguageInfo.Help> getHelpLinks() {
        return null;
    }

    public HistoryManager getHistoryManager() {
        return null;
    }

    public abstract DisplayData eval(String var1);

    public DisplayData inspect(String code, int at, boolean extraDetail) {
        return null;
    }

    public ReplacementOptions complete(String code, int at) {
        return null;
    }

    public String isComplete(String code) {
        return IS_COMPLETE_MAYBE;
    }

    public abstract LanguageInfo getLanguageInfo();

    public void onShutdown(boolean isRestarting) {
    }

    public void interrupt() {
    }

    public List<String> formatError(Throwable e) {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add(this.errorStyler.secondary("---------------------------------------------------------------------------"));
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        printWriter.close();
        String stackTrace = stringWriter.toString();
        lines.addAll(this.errorStyler.secondaryLines(stackTrace));
        return lines;
    }

    public void becomeHandlerForConnection(JupyterConnection connection) {
        connection.setHandler(MessageType.EXECUTE_REQUEST, this::handleExecuteRequest);
        connection.setHandler(MessageType.INSPECT_REQUEST, this::handleInspectRequest);
        connection.setHandler(MessageType.COMPLETE_REQUEST, this::handleCompleteRequest);
        connection.setHandler(MessageType.HISTORY_REQUEST, this::handleHistoryRequest);
        connection.setHandler(MessageType.IS_COMPLETE_REQUEST, this::handleIsCodeCompeteRequest);
        connection.setHandler(MessageType.KERNEL_INFO_REQUEST, this::handleKernelInfoRequest);
        connection.setHandler(MessageType.SHUTDOWN_REQUEST, this::handleShutdownRequest);
        connection.setHandler(MessageType.INTERRUPT_REQUEST, this::handleInterruptRequest);
        this.commManager.setIOPubChannel(connection.getIOPub());
        connection.setHandler(MessageType.COMM_OPEN_COMMAND, this.commManager::handleCommOpenCommand);
        connection.setHandler(MessageType.COMM_MSG_COMMAND, this.commManager::handleCommMsgCommand);
        connection.setHandler(MessageType.COMM_CLOSE_COMMAND, this.commManager::handleCommCloseCommand);
        connection.setHandler(MessageType.COMM_INFO_REQUEST, this.commManager::handleCommInfoRequest);
    }

    private void replaceOutputStreams(ShellReplyEnvironment env) {
        PrintStream oldStdOut = System.out;
        PrintStream oldStdErr = System.err;
        InputStream oldStdIn = System.in;
        System.setOut(this.io.out);
        System.setErr(this.io.err);
        System.setIn(this.io.in);
        env.defer(() -> {
            System.setOut(oldStdOut);
            System.setErr(oldStdErr);
            System.setIn(oldStdIn);
        });
    }

    private synchronized void handleExecuteRequest(ShellReplyEnvironment env, Message<ExecuteRequest> executeRequestMessage) {
        this.commManager.setMessageContext(executeRequestMessage);
        ExecuteRequest request = executeRequestMessage.getContent();
        int count = this.executionCount.getAndIncrement();
        env.setBusyDeferIdle();
        env.publish(new PublishExecuteInput(request.getCode(), count));
        if (this.shouldReplaceStdStreams()) {
            this.replaceOutputStreams(env);
        }
        this.io.setEnv(env);
        env.defer(() -> this.io.retractEnv(env));
        this.io.setJupyterInEnabled(request.isStdinEnabled());
        try {
            DisplayData out = this.eval(request.getCode());
            if (out != null) {
                PublishExecuteResult result = new PublishExecuteResult(count, out);
                env.publish(result);
            }
            env.defer().reply(new ExecuteReply(count, Collections.emptyMap()));
        }
        catch (Exception e) {
            ErrorReply error = ErrorReply.of(e);
            error.setExecutionCount(count);
            env.publish(PublishError.of(e, this::formatError));
            env.defer().replyError(ExecuteReply.MESSAGE_TYPE.error(), error);
        }
    }

    private void handleInspectRequest(ShellReplyEnvironment env, Message<InspectRequest> inspectRequestMessage) {
        InspectRequest request = inspectRequestMessage.getContent();
        env.setBusyDeferIdle();
        try {
            DisplayData inspection = this.inspect(request.getCode(), request.getCursorPos(), request.getDetailLevel() > 0);
            env.reply(new InspectReply(inspection != null, DisplayData.emptyIfNull(inspection)));
        }
        catch (Exception e) {
            env.replyError(InspectReply.MESSAGE_TYPE.error(), ErrorReply.of(e));
        }
    }

    private void handleCompleteRequest(ShellReplyEnvironment env, Message<CompleteRequest> completeRequestMessage) {
        CompleteRequest request = completeRequestMessage.getContent();
        env.setBusyDeferIdle();
        try {
            ReplacementOptions options = this.complete(request.getCode(), request.getCursorPos());
            if (options == null) {
                env.reply(new CompleteReply(Collections.emptyList(), request.getCursorPos(), request.getCursorPos(), Collections.emptyMap()));
            } else {
                env.reply(new CompleteReply(options.getReplacements(), options.getSourceStart(), options.getSourceEnd(), Collections.emptyMap()));
            }
        }
        catch (Exception e) {
            env.replyError(CompleteReply.MESSAGE_TYPE.error(), ErrorReply.of(e));
        }
    }

    private void handleHistoryRequest(ShellReplyEnvironment env, Message<HistoryRequest> historyRequestMessage) {
        HistoryManager manager = this.getHistoryManager();
        if (manager == null) {
            return;
        }
        HistoryRequest request = historyRequestMessage.getContent();
        env.setBusyDeferIdle();
        EnumSet<HistoryManager.ResultFlag> flags = EnumSet.noneOf(HistoryManager.ResultFlag.class);
        if (request.includeOutput()) {
            flags.add(HistoryManager.ResultFlag.INCLUDE_OUTPUT);
        }
        if (!request.useRaw()) {
            flags.add(HistoryManager.ResultFlag.TRANSFORMED_INPUT);
        }
        List<HistoryEntry> entries = null;
        switch (request.getAccessType()) {
            case TAIL: {
                HistoryRequest.Tail tailRequest = (HistoryRequest.Tail)request;
                entries = manager.lookupTail(tailRequest.getMaxReturnLength(), flags);
                break;
            }
            case RANGE: {
                HistoryRequest.Range rangeRequest = (HistoryRequest.Range)request;
                entries = manager.lookupRange(rangeRequest.getSessionIndex(), rangeRequest.getStart(), rangeRequest.getStop(), flags);
                break;
            }
            case SEARCH: {
                HistoryRequest.Search searchRequest = (HistoryRequest.Search)request;
                if (searchRequest.filterUnique()) {
                    flags.add(HistoryManager.ResultFlag.UNIQUE);
                }
                entries = manager.search(searchRequest.getPattern(), searchRequest.getMaxReturnLength(), flags);
            }
        }
        if (entries != null) {
            env.reply(new HistoryReply(entries));
        }
    }

    private void handleIsCodeCompeteRequest(ShellReplyEnvironment env, Message<IsCompleteRequest> isCompleteRequestMessage) {
        IsCompleteReply reply;
        String isCompleteResult;
        IsCompleteRequest request = isCompleteRequestMessage.getContent();
        env.setBusyDeferIdle();
        switch (isCompleteResult = this.isComplete(request.getCode())) {
            case "complete": {
                reply = IsCompleteReply.VALID_CODE;
                break;
            }
            case "invalid": {
                reply = IsCompleteReply.INVALID_CODE;
                break;
            }
            case "unknown": {
                reply = IsCompleteReply.UNKNOWN;
                break;
            }
            default: {
                reply = IsCompleteReply.getIncompleteReplyWithIndent(isCompleteResult);
            }
        }
        env.reply(reply);
    }

    private void handleKernelInfoRequest(ShellReplyEnvironment env, Message<KernelInfoRequest> kernelInfoRequestMessage) {
        env.setBusyDeferIdle();
        env.reply(new KernelInfoReply("5.3", KERNEL_META.get("project"), KERNEL_META.get("version"), this.getLanguageInfo(), this.getBanner(), this.getHelpLinks()));
    }

    private void handleShutdownRequest(ShellReplyEnvironment env, Message<ShutdownRequest> shutdownRequestMessage) {
        ShutdownRequest request = shutdownRequestMessage.getContent();
        env.setBusyDeferIdle();
        env.defer().reply(request.isRestart() ? ShutdownReply.SHUTDOWN_AND_RESTART : ShutdownReply.SHUTDOWN);
        this.onShutdown(request.isRestart());
        env.resolveDeferrals();
        env.markForShutdown();
    }

    private void handleInterruptRequest(ShellReplyEnvironment env, Message<InterruptRequest> interruptRequestMessage) {
        env.setBusyDeferIdle();
        env.defer().reply(new InterruptReply());
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Map<String, String> meta = null;
        InputStream metaStream = BaseKernel.class.getClassLoader().getResourceAsStream("kernel-metadata.json");
        if (metaStream != null) {
            InputStreamReader metaReader = new InputStreamReader(metaStream);
            try {
                meta = (Map)new Gson().fromJson((Reader)metaReader, new TypeToken<Map<String, String>>(){}.getType());
            }
            finally {
                try {
                    ((Reader)metaReader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (meta == null) {
            meta = new HashMap<String, String>(2);
            meta.put("version", IS_COMPLETE_MAYBE);
            meta.put("project", IS_COMPLETE_MAYBE);
        }
        KERNEL_META = meta;
    }
}

