/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel;

import java.util.Map;
import org.dflib.jjava.shaded.com.google.gson.annotations.SerializedName;

public class LanguageInfo {
    protected final String name;
    protected final String version;
    protected String mimetype;
    @SerializedName(value="file_extension")
    protected String fileExtension;
    @SerializedName(value="pygments_lexer")
    protected String pygmentsLexer;
    @SerializedName(value="codemirror_mode")
    protected Object codemirrorMode;
    @SerializedName(value="nbconvert_exporter")
    protected String nbconvertExporter;

    public LanguageInfo(String name, String version, String mimetype, String fileExtension, String pygmentsLexer, Object codemirrorMode, String nbconvertExporter) {
        this.name = name;
        this.version = version;
        this.mimetype = mimetype;
        this.fileExtension = fileExtension;
        this.pygmentsLexer = pygmentsLexer;
        this.codemirrorMode = codemirrorMode;
        this.nbconvertExporter = nbconvertExporter;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getPygmentsLexer() {
        return this.pygmentsLexer;
    }

    public Object getCodemirrorMode() {
        return this.codemirrorMode;
    }

    public String getNbconvertExporter() {
        return this.nbconvertExporter;
    }

    public static class Builder {
        private final String name;
        private String version = null;
        private String mimetype = "text/plain";
        private String fileExt = ".txt";
        private String pygmentsLexer = null;
        private Object codemirrorMode = null;
        private String exporter = null;

        public Builder(String name) {
            this.name = name;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder mimetype(String mimetype) {
            this.mimetype = mimetype;
            return this;
        }

        public Builder fileExtension(String ext) {
            this.fileExt = ext;
            return this;
        }

        public Builder pygments(String lexer) {
            this.pygmentsLexer = lexer;
            return this;
        }

        public Builder codemirror(String mode) {
            this.codemirrorMode = mode;
            return this;
        }

        public Builder codemirror(Map<String, Object> mode) {
            this.codemirrorMode = mode;
            return this;
        }

        public Builder exporter(String exporter) {
            this.exporter = exporter;
            return this;
        }

        public LanguageInfo build() {
            return new LanguageInfo(this.name, this.version, this.mimetype, this.fileExt, this.pygmentsLexer, this.codemirrorMode, this.exporter);
        }
    }

    public static class Help {
        protected String text;
        protected String url;

        public Help(String text, String url) {
            this.text = text;
            this.url = url;
        }

        public String getText() {
            return this.text;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

