/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.messages;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dflib.jjava.jupyter.messages.Header;
import org.dflib.jjava.jupyter.messages.MessageContext;
import org.dflib.jjava.jupyter.messages.MessageType;

public class Message<T>
implements MessageContext {
    private List<byte[]> identities;
    private Header<T> header;
    private Header<?> parentHeader;
    private Map<String, Object> metadata;
    private T content;
    private List<byte[]> blobs;

    public Message(MessageContext ctx, MessageType<T> type, T content) {
        this(ctx, type, content, null, null);
    }

    public Message(MessageContext ctx, MessageType<T> type, T content, List<byte[]> blobs, Map<String, Object> metadata) {
        this(ctx != null ? ctx.getIdentities() : Collections.emptyList(), new Header<T>(ctx, type), ctx != null ? ctx.getHeader() : null, metadata, content, blobs);
    }

    public Message(Header<T> header, T content) {
        this(Collections.emptyList(), header, null, null, content, null);
    }

    public Message(Header<T> header, T content, Map<String, Object> metadata, List<byte[]> blobs) {
        this(Collections.emptyList(), header, null, metadata, content, blobs);
    }

    public Message(List<byte[]> identities, Header<T> header, T content) {
        this(identities, header, null, null, content, null);
    }

    public Message(List<byte[]> identities, Header<T> header, Header<?> parentHeader, Map<String, Object> metadata, T content, List<byte[]> blobs) {
        this.identities = identities;
        this.header = header;
        this.parentHeader = parentHeader;
        this.metadata = metadata;
        this.content = content;
        this.blobs = blobs;
    }

    @Override
    public List<byte[]> getIdentities() {
        return this.identities;
    }

    @Override
    public Header<T> getHeader() {
        return this.header;
    }

    public boolean hasParentHeader() {
        return this.parentHeader != null;
    }

    public Header<?> getParentHeader() {
        return this.parentHeader;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Map<String, Object> getNonNullMetadata() {
        if (this.hasMetadata()) {
            return this.getMetadata();
        }
        this.metadata = new LinkedHashMap<String, Object>();
        return this.metadata;
    }

    public T getContent() {
        return this.content;
    }

    public List<byte[]> getBlobs() {
        return this.blobs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Message {\n");
        sb.append("\tidentities = [\n");
        for (byte[] id : this.identities) {
            sb.append("\t\t").append(Arrays.toString(id)).append("\n");
        }
        sb.append("\t]\n");
        sb.append("\theader = ").append(this.header).append("\n");
        sb.append("\tparentHeader = ").append(this.parentHeader).append("\n");
        sb.append("\tmetadata = ").append(this.metadata).append("\n");
        sb.append("\tcontent = ").append(this.content).append("\n");
        sb.append("\tblobs = [\n");
        if (this.blobs != null) {
            for (byte[] blob : this.blobs) {
                sb.append("\t\t").append(Arrays.toString(blob)).append("\n");
            }
        }
        sb.append("\t]\n");
        sb.append("}\n");
        return sb.toString();
    }
}

