/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.messages.publish;

import java.util.List;
import org.dflib.jjava.jupyter.messages.ContentType;
import org.dflib.jjava.jupyter.messages.MessageType;
import org.dflib.jjava.jupyter.messages.publish.ErrorFormatter;
import org.dflib.jjava.shaded.com.google.gson.annotations.SerializedName;

public class PublishError
implements ContentType<PublishError> {
    public static final MessageType<PublishError> MESSAGE_TYPE = MessageType.PUBLISH_ERROR;
    @SerializedName(value="ename")
    protected final String errName;
    @SerializedName(value="evalue")
    protected final String errMsg;
    @SerializedName(value="traceback")
    protected final List<String> stacktrace;

    public static PublishError of(Exception exception, ErrorFormatter formatter) {
        String name = exception.getClass().getSimpleName();
        String msg = exception.getLocalizedMessage();
        List<String> stacktrace = formatter.format(exception);
        return new PublishError(name, msg == null ? "" : msg, stacktrace);
    }

    @Override
    public MessageType<PublishError> getType() {
        return MESSAGE_TYPE;
    }

    public PublishError(String errName, String errMsg, List<String> stacktrace) {
        this.errName = errName;
        this.errMsg = errMsg;
        this.stacktrace = stacktrace;
    }

    public String getErrorName() {
        return this.errName;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public List<String> getStacktrace() {
        return this.stacktrace;
    }
}

