/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import java.util.ArrayList;
import java.util.HashSet;
import javax.inject.Inject;
import org.dflib.jjava.shaded.com.google.inject.ProvisionException;
import org.dflib.jjava.shaded.com.google.inject.TypeLiteral;
import org.dflib.jjava.shaded.com.google.inject.spi.TypeEncounter;
import org.dflib.jjava.shaded.com.google.inject.spi.TypeListener;
import org.eclipse.sisu.bean.BeanBinder;
import org.eclipse.sisu.bean.BeanInjector;
import org.eclipse.sisu.bean.BeanProperties;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.PropertyBinder;
import org.eclipse.sisu.bean.PropertyBinding;

public final class BeanListener
implements TypeListener {
    private final BeanBinder beanBinder;

    public BeanListener(BeanBinder beanBinder) {
        this.beanBinder = beanBinder;
    }

    public <B> void hear(TypeLiteral<B> type, TypeEncounter<B> encounter) {
        PropertyBinder propertyBinder = this.beanBinder.bindBean(type, encounter);
        if (null == propertyBinder) {
            return;
        }
        ArrayList<PropertyBinding> bindings = new ArrayList<PropertyBinding>();
        HashSet<String> visited = new HashSet<String>();
        for (BeanProperty<Object> property : new BeanProperties(type.getRawType())) {
            String name;
            if (property.getAnnotation(Inject.class) != null || property.getAnnotation(org.dflib.jjava.shaded.com.google.inject.Inject.class) != null || !visited.add(name = property.getName())) continue;
            try {
                PropertyBinding binding = propertyBinder.bindProperty(property);
                if (binding == PropertyBinder.LAST_BINDING) break;
                if (binding != null) {
                    bindings.add(binding);
                    continue;
                }
                visited.remove(name);
            }
            catch (RuntimeException e) {
                encounter.addError((Throwable)new ProvisionException("Error binding: " + property, (Throwable)e));
            }
        }
        if (bindings.size() > 0) {
            encounter.register(new BeanInjector(bindings));
        }
    }
}

