/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.lang.annotation.Annotation;
import javax.inject.Provider;
import org.dflib.jjava.shaded.com.google.inject.Binding;
import org.dflib.jjava.shaded.com.google.inject.Key;
import org.dflib.jjava.shaded.com.google.inject.name.Named;
import org.dflib.jjava.shaded.com.google.inject.name.Names;
import org.dflib.jjava.shaded.com.google.inject.spi.ConstructorBinding;
import org.dflib.jjava.shaded.com.google.inject.spi.ProviderKeyBinding;
import org.eclipse.sisu.inject.Implementations;

enum QualifyingStrategy {
    UNRESTRICTED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier = 1.qualify(binding.getKey());
            return null != qualifier ? qualifier : BLANK_QUALIFIER;
        }
    }
    ,
    NAMED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier = 2.qualify(binding.getKey());
            return qualifier instanceof Named ? qualifier : null;
        }
    }
    ,
    NAMED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Class clazz;
            javax.inject.Named alias;
            Annotation qualifier = 3.qualify(binding.getKey());
            if (requirement.getAnnotation().equals(qualifier)) {
                return qualifier;
            }
            if (binding instanceof ConstructorBinding && null == binding.getKey().getAnnotationType() && null != (alias = (clazz = binding.getKey().getTypeLiteral().getRawType()).getAnnotation(javax.inject.Named.class)) && alias.value().equals(((Named)requirement.getAnnotation()).value()) && clazz.equals(Implementations.find(binding))) {
                return requirement.getAnnotation();
            }
            return null;
        }
    }
    ,
    MARKED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier;
            final Class markerType = requirement.getAnnotationType();
            if (markerType.isInstance(qualifier = 4.qualify(binding.getKey()))) {
                return qualifier;
            }
            if (markerType.equals(binding.getKey().getAnnotationType()) && markerType.getDeclaredMethods().length == 0) {
                return new Annotation(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return markerType;
                    }
                };
            }
            if (binding instanceof ProviderKeyBinding) {
                Key providerKey = ((ProviderKeyBinding)binding).getProviderKey();
                return providerKey.getTypeLiteral().getRawType().getAnnotation(markerType);
            }
            Class<?> implementation = Implementations.find(binding);
            return null != implementation ? (Annotation)implementation.getAnnotation(markerType) : null;
        }
    }
    ,
    MARKED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier = MARKED.qualifies(requirement, binding);
            return requirement.getAnnotation().equals(qualifier) ? qualifier : null;
        }
    };

    static final Annotation DEFAULT_QUALIFIER;
    static final Annotation BLANK_QUALIFIER;

    abstract Annotation qualifies(Key<?> var1, Binding<?> var2);

    static final QualifyingStrategy selectFor(Key<?> key) {
        Class qualifierType = key.getAnnotationType();
        if (null == qualifierType) {
            return UNRESTRICTED;
        }
        if (Named.class == qualifierType) {
            return key.hasAttributes() ? NAMED_WITH_ATTRIBUTES : NAMED;
        }
        return key.hasAttributes() ? MARKED_WITH_ATTRIBUTES : MARKED;
    }

    static final Annotation qualify(Key<?> key) {
        if (null == key.getAnnotationType()) {
            return DEFAULT_QUALIFIER;
        }
        Annotation qualifier = key.getAnnotation();
        if (qualifier instanceof Provider) {
            Object original = ((Provider)((Object)qualifier)).get();
            return original instanceof Annotation ? (Annotation)original : DEFAULT_QUALIFIER;
        }
        return qualifier;
    }

    static {
        DEFAULT_QUALIFIER = Names.named((String)"default");
        BLANK_QUALIFIER = Names.named((String)"");
    }
}

