/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.channels;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.LongSupplier;
import java.util.function.ToLongFunction;
import org.dflib.jjava.shaded.org.slf4j.Logger;
import org.dflib.jjava.shaded.org.slf4j.LoggerFactory;

public class Loop
extends Thread {
    private final Logger logger;
    private final LongSupplier loopBody = () -> {
        target.run();
        return sleep;
    };
    private final Queue<Runnable> runNextQueue = new LinkedBlockingQueue<Runnable>();
    private volatile boolean running;
    private volatile Runnable onCloseCb;
    private volatile ToLongFunction<Throwable> onErrorCb;

    public Loop(String name, long sleep, Runnable target) {
        super(name);
        this.logger = LoggerFactory.getLogger("Loop-" + name);
    }

    public void onClose(Runnable callback) {
        if (this.onCloseCb != null) {
            Runnable oldCallback = this.onCloseCb;
            this.onCloseCb = () -> {
                oldCallback.run();
                callback.run();
            };
        } else {
            this.onCloseCb = callback;
        }
    }

    public void onError(ToLongFunction<Throwable> callback) {
        if (this.onErrorCb == null) {
            this.onErrorCb = callback;
            return;
        }
        ToLongFunction<Throwable> oldCallback = this.onErrorCb;
        this.onErrorCb = t -> {
            try {
                return oldCallback.applyAsLong((Throwable)t);
            }
            catch (Throwable tPrime) {
                return callback.applyAsLong(tPrime);
            }
        };
    }

    public void doNext(Runnable next) {
        this.runNextQueue.offer(next);
    }

    @Override
    public void run() {
        while (this.running) {
            long sleep;
            try {
                Runnable next;
                sleep = this.loopBody.getAsLong();
                while ((next = this.runNextQueue.poll()) != null) {
                    next.run();
                }
            }
            catch (Throwable t) {
                if (this.onErrorCb != null) {
                    sleep = this.onErrorCb.applyAsLong(t);
                }
                throw t;
            }
            if (sleep > 0L) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    this.logger.debug("Loop interrupted. Stopping...");
                    this.running = false;
                }
                continue;
            }
            if (sleep >= 0L) continue;
            this.logger.debug("Loop interrupted by a negative sleep request. Stopping...");
            this.running = false;
        }
        this.logger.debug("Running loop shutdown callback.");
        if (this.onCloseCb != null) {
            this.onCloseCb.run();
            this.onCloseCb = null;
        }
        this.logger.info("Loop stopped.");
    }

    @Override
    public synchronized void start() {
        this.logger.debug("Loop starting...");
        this.running = true;
        super.start();
        this.logger.info("Loop started.");
    }

    public void shutdown() {
        this.running = false;
        this.logger.debug("Loop shutdown.");
    }
}

