/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.dflib.jjava.jupyter.Extension;
import org.dflib.jjava.jupyter.channels.JupyterConnection;
import org.dflib.jjava.jupyter.channels.ShellReplyEnvironment;
import org.dflib.jjava.jupyter.kernel.HelpLink;
import org.dflib.jjava.jupyter.kernel.JupyterIO;
import org.dflib.jjava.jupyter.kernel.LanguageInfo;
import org.dflib.jjava.jupyter.kernel.ReplacementOptions;
import org.dflib.jjava.jupyter.kernel.comm.CommManager;
import org.dflib.jjava.jupyter.kernel.display.DisplayData;
import org.dflib.jjava.jupyter.kernel.display.Renderer;
import org.dflib.jjava.jupyter.kernel.display.common.Image;
import org.dflib.jjava.jupyter.kernel.display.common.Text;
import org.dflib.jjava.jupyter.kernel.display.common.Url;
import org.dflib.jjava.jupyter.kernel.history.HistoryEntry;
import org.dflib.jjava.jupyter.kernel.history.HistoryManager;
import org.dflib.jjava.jupyter.kernel.magic.MagicParser;
import org.dflib.jjava.jupyter.kernel.magic.MagicsRegistry;
import org.dflib.jjava.jupyter.kernel.util.PathsHandler;
import org.dflib.jjava.jupyter.kernel.util.StringStyler;
import org.dflib.jjava.jupyter.messages.Message;
import org.dflib.jjava.jupyter.messages.MessageType;
import org.dflib.jjava.jupyter.messages.publish.PublishError;
import org.dflib.jjava.jupyter.messages.publish.PublishExecuteInput;
import org.dflib.jjava.jupyter.messages.publish.PublishExecuteResult;
import org.dflib.jjava.jupyter.messages.reply.CompleteReply;
import org.dflib.jjava.jupyter.messages.reply.ErrorReply;
import org.dflib.jjava.jupyter.messages.reply.ExecuteReply;
import org.dflib.jjava.jupyter.messages.reply.HistoryReply;
import org.dflib.jjava.jupyter.messages.reply.InspectReply;
import org.dflib.jjava.jupyter.messages.reply.InterruptReply;
import org.dflib.jjava.jupyter.messages.reply.IsCompleteReply;
import org.dflib.jjava.jupyter.messages.reply.KernelInfoReply;
import org.dflib.jjava.jupyter.messages.reply.ShutdownReply;
import org.dflib.jjava.jupyter.messages.request.CompleteRequest;
import org.dflib.jjava.jupyter.messages.request.ExecuteRequest;
import org.dflib.jjava.jupyter.messages.request.HistoryRequest;
import org.dflib.jjava.jupyter.messages.request.InspectRequest;
import org.dflib.jjava.jupyter.messages.request.InterruptRequest;
import org.dflib.jjava.jupyter.messages.request.IsCompleteRequest;
import org.dflib.jjava.jupyter.messages.request.KernelInfoRequest;
import org.dflib.jjava.jupyter.messages.request.ShutdownRequest;
import org.dflib.jjava.shaded.org.slf4j.Logger;
import org.dflib.jjava.shaded.org.slf4j.LoggerFactory;

public abstract class BaseKernel {
    private final Logger LOGGER = LoggerFactory.getLogger("BaseKernel");
    protected static BaseKernel notebookKernel;
    public static final String IS_COMPLETE_YES = "complete";
    public static final String IS_COMPLETE_BAD = "invalid";
    public static final String IS_COMPLETE_MAYBE = "unknown";
    protected final String name;
    protected final String version;
    protected final LanguageInfo languageInfo;
    protected final List<HelpLink> helpLinks;
    protected final HistoryManager historyManager;
    protected final JupyterIO io;
    protected final CommManager commManager;
    protected final Renderer renderer;
    protected final MagicParser magicParser;
    protected final MagicsRegistry magicsRegistry;
    protected final Map<String, Extension> extensions;
    protected final boolean extensionsEnabled;
    protected final StringStyler errorStyler;
    protected final AtomicInteger executionCount;

    public static BaseKernel notebookKernel() {
        return Objects.requireNonNull(notebookKernel, "No kernel running. Likely called outside of the notebook lifecycle");
    }

    protected BaseKernel(String name, String version, LanguageInfo languageInfo, List<HelpLink> helpLinks, HistoryManager historyManager, JupyterIO io, CommManager commManager, Renderer renderer, MagicParser magicParser, MagicsRegistry magicsRegistry, boolean extensionsEnabled, StringStyler errorStyler) {
        this.name = name;
        this.version = version;
        this.languageInfo = languageInfo;
        this.helpLinks = helpLinks;
        this.historyManager = historyManager;
        this.io = Objects.requireNonNull(io);
        this.commManager = Objects.requireNonNull(commManager);
        this.renderer = Objects.requireNonNull(renderer);
        this.magicParser = magicParser;
        this.magicsRegistry = magicsRegistry;
        this.extensionsEnabled = extensionsEnabled;
        this.extensions = new ConcurrentHashMap<String, Extension>();
        this.errorStyler = Objects.requireNonNull(errorStyler);
        this.executionCount = new AtomicInteger(1);
        Image.registerAll(this.renderer);
        Url.registerAll(this.renderer);
        Text.registerAll(this.renderer);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public MagicsRegistry getMagicsRegistry() {
        return this.magicsRegistry;
    }

    public MagicParser getMagicParser() {
        return this.magicParser;
    }

    public JupyterIO getIO() {
        return this.io;
    }

    public CommManager getCommManager() {
        return this.commManager;
    }

    public String getBanner() {
        return String.format("%s %s :: %s %s :: Protocol v%s", this.languageInfo != null ? this.languageInfo.getName() : "Unknown", this.languageInfo != null ? this.languageInfo.getVersion() : "", this.name != null ? this.name : IS_COMPLETE_MAYBE, this.version != null ? this.version : IS_COMPLETE_MAYBE, "5.3");
    }

    public LanguageInfo getLanguageInfo() {
        return this.languageInfo;
    }

    public List<HelpLink> getHelpLinks() {
        return this.helpLinks;
    }

    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public void display(DisplayData data) {
        this.io.display.display(data);
    }

    public abstract Object evalRaw(String var1);

    public DisplayData eval(String expr) {
        Object result = this.evalRaw(expr);
        if (result == null) {
            return null;
        }
        return result instanceof DisplayData ? (DisplayData)result : this.getRenderer().render(result);
    }

    public abstract DisplayData inspect(String var1, int var2, boolean var3);

    public abstract ReplacementOptions complete(String var1, int var2);

    public abstract String isComplete(String var1);

    public void onStartup() {
        this.installNotebookKernel();
        if (this.extensionsEnabled) {
            this.installDefaultExtensions();
        }
    }

    public void onShutdown(boolean isRestarting) {
        this.uninstallExtension();
        this.uninstallNotebookKernel();
    }

    protected void uninstallExtension() {
        HashSet<Extension> localExts = new HashSet<Extension>(this.extensions.values());
        this.extensions.clear();
        for (Extension ext : localExts) {
            try {
                ext.uninstall(this);
            }
            catch (Exception e) {
                this.LOGGER.info("Error uninstalling extension '{}', ignoring", (Object)ext.getClass().getName());
                this.LOGGER.debug("Uninstall error", e);
            }
        }
    }

    protected void installNotebookKernel() {
        if (notebookKernel != null) {
            throw new IllegalStateException("A different notebook kernel was already started: " + notebookKernel.getBanner());
        }
        notebookKernel = this;
    }

    protected void uninstallNotebookKernel() {
        if (notebookKernel != null && notebookKernel != this) {
            throw new IllegalStateException("A different notebook kernel is running: " + notebookKernel.getBanner());
        }
        notebookKernel = null;
    }

    public void interrupt() {
    }

    public List<String> formatError(Throwable e) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.errorStyler.secondary("---------------------------------------------------------------------------"));
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        printWriter.close();
        String stackTrace = stringWriter.toString();
        lines.addAll(this.errorStyler.secondaryLines(stackTrace));
        return lines;
    }

    public void becomeHandlerForConnection(JupyterConnection connection) {
        connection.setHandler(MessageType.EXECUTE_REQUEST, this::handleExecuteRequest);
        connection.setHandler(MessageType.INSPECT_REQUEST, this::handleInspectRequest);
        connection.setHandler(MessageType.COMPLETE_REQUEST, this::handleCompleteRequest);
        connection.setHandler(MessageType.HISTORY_REQUEST, this::handleHistoryRequest);
        connection.setHandler(MessageType.IS_COMPLETE_REQUEST, this::handleIsCodeCompeteRequest);
        connection.setHandler(MessageType.KERNEL_INFO_REQUEST, this::handleKernelInfoRequest);
        connection.setHandler(MessageType.SHUTDOWN_REQUEST, this::handleShutdownRequest);
        connection.setHandler(MessageType.INTERRUPT_REQUEST, this::handleInterruptRequest);
        this.commManager.setIOPubChannel(connection.getIOPub());
        connection.setHandler(MessageType.COMM_OPEN_COMMAND, this.commManager::handleCommOpenCommand);
        connection.setHandler(MessageType.COMM_MSG_COMMAND, this.commManager::handleCommMsgCommand);
        connection.setHandler(MessageType.COMM_CLOSE_COMMAND, this.commManager::handleCommCloseCommand);
        connection.setHandler(MessageType.COMM_INFO_REQUEST, this.commManager::handleCommInfoRequest);
    }

    protected void replaceOutputStreams(ShellReplyEnvironment env) {
        PrintStream oldStdOut = System.out;
        PrintStream oldStdErr = System.err;
        InputStream oldStdIn = System.in;
        System.setOut(this.io.out);
        System.setErr(this.io.err);
        System.setIn(this.io.in);
        env.defer(() -> {
            System.setOut(oldStdOut);
            System.setErr(oldStdErr);
            System.setIn(oldStdIn);
        });
    }

    protected synchronized void handleExecuteRequest(ShellReplyEnvironment env, Message<ExecuteRequest> executeRequestMessage) {
        this.commManager.setMessageContext(executeRequestMessage);
        ExecuteRequest request = executeRequestMessage.getContent();
        int count = this.executionCount.getAndIncrement();
        env.setBusyDeferIdle();
        env.publish(new PublishExecuteInput(request.getCode(), count));
        this.replaceOutputStreams(env);
        this.io.setEnv(env);
        env.defer(() -> this.io.retractEnv(env));
        this.io.setJupyterInEnabled(request.isStdinEnabled());
        try {
            DisplayData out = this.eval(request.getCode());
            if (out != null) {
                PublishExecuteResult result = new PublishExecuteResult(count, out);
                env.publish(result);
            }
            env.defer().reply(new ExecuteReply(count, Collections.emptyMap()));
        }
        catch (Exception e) {
            ErrorReply error = ErrorReply.of(e);
            error.setExecutionCount(count);
            env.publish(PublishError.of(e, this::formatError));
            env.defer().replyError(ExecuteReply.MESSAGE_TYPE.error(), error);
        }
    }

    protected void handleInspectRequest(ShellReplyEnvironment env, Message<InspectRequest> inspectRequestMessage) {
        InspectRequest request = inspectRequestMessage.getContent();
        env.setBusyDeferIdle();
        try {
            DisplayData inspection = this.inspect(request.getCode(), request.getCursorPos(), request.getDetailLevel() > 0);
            env.reply(new InspectReply(inspection != null, DisplayData.emptyIfNull(inspection)));
        }
        catch (Exception e) {
            env.replyError(InspectReply.MESSAGE_TYPE.error(), ErrorReply.of(e));
        }
    }

    protected void handleCompleteRequest(ShellReplyEnvironment env, Message<CompleteRequest> completeRequestMessage) {
        CompleteRequest request = completeRequestMessage.getContent();
        env.setBusyDeferIdle();
        try {
            ReplacementOptions options = this.complete(request.getCode(), request.getCursorPos());
            if (options == null) {
                env.reply(new CompleteReply(Collections.emptyList(), request.getCursorPos(), request.getCursorPos(), Collections.emptyMap()));
            } else {
                env.reply(new CompleteReply(options.getReplacements(), options.getSourceStart(), options.getSourceEnd(), Collections.emptyMap()));
            }
        }
        catch (Exception e) {
            env.replyError(CompleteReply.MESSAGE_TYPE.error(), ErrorReply.of(e));
        }
    }

    protected void handleHistoryRequest(ShellReplyEnvironment env, Message<HistoryRequest> historyRequestMessage) {
        HistoryManager manager = this.getHistoryManager();
        if (manager == null) {
            return;
        }
        HistoryRequest request = historyRequestMessage.getContent();
        env.setBusyDeferIdle();
        EnumSet<HistoryManager.ResultFlag> flags = EnumSet.noneOf(HistoryManager.ResultFlag.class);
        if (request.includeOutput()) {
            flags.add(HistoryManager.ResultFlag.INCLUDE_OUTPUT);
        }
        if (!request.useRaw()) {
            flags.add(HistoryManager.ResultFlag.TRANSFORMED_INPUT);
        }
        List<HistoryEntry> entries = null;
        switch (request.getAccessType()) {
            case TAIL: {
                HistoryRequest.Tail tailRequest = (HistoryRequest.Tail)request;
                entries = manager.lookupTail(tailRequest.getMaxReturnLength(), flags);
                break;
            }
            case RANGE: {
                HistoryRequest.Range rangeRequest = (HistoryRequest.Range)request;
                entries = manager.lookupRange(rangeRequest.getSessionIndex(), rangeRequest.getStart(), rangeRequest.getStop(), flags);
                break;
            }
            case SEARCH: {
                HistoryRequest.Search searchRequest = (HistoryRequest.Search)request;
                if (searchRequest.filterUnique()) {
                    flags.add(HistoryManager.ResultFlag.UNIQUE);
                }
                entries = manager.search(searchRequest.getPattern(), searchRequest.getMaxReturnLength(), flags);
            }
        }
        if (entries != null) {
            env.reply(new HistoryReply(entries));
        }
    }

    protected void handleIsCodeCompeteRequest(ShellReplyEnvironment env, Message<IsCompleteRequest> isCompleteRequestMessage) {
        IsCompleteReply reply;
        String isCompleteResult;
        IsCompleteRequest request = isCompleteRequestMessage.getContent();
        env.setBusyDeferIdle();
        switch (isCompleteResult = this.isComplete(request.getCode())) {
            case "complete": {
                reply = IsCompleteReply.VALID_CODE;
                break;
            }
            case "invalid": {
                reply = IsCompleteReply.INVALID_CODE;
                break;
            }
            case "unknown": {
                reply = IsCompleteReply.UNKNOWN;
                break;
            }
            default: {
                reply = IsCompleteReply.getIncompleteReplyWithIndent(isCompleteResult);
            }
        }
        env.reply(reply);
    }

    protected void handleKernelInfoRequest(ShellReplyEnvironment env, Message<KernelInfoRequest> kernelInfoRequestMessage) {
        env.setBusyDeferIdle();
        env.reply(new KernelInfoReply("5.3", this.name, this.version, this.getLanguageInfo(), this.getBanner(), this.getHelpLinks()));
    }

    protected void handleShutdownRequest(ShellReplyEnvironment env, Message<ShutdownRequest> shutdownRequestMessage) {
        ShutdownRequest request = shutdownRequestMessage.getContent();
        env.setBusyDeferIdle();
        env.defer().reply(request.isRestart() ? ShutdownReply.SHUTDOWN_AND_RESTART : ShutdownReply.SHUTDOWN);
        this.onShutdown(request.isRestart());
        env.resolveDeferrals();
        env.markForShutdown();
    }

    protected void handleInterruptRequest(ShellReplyEnvironment env, Message<InterruptRequest> interruptRequestMessage) {
        env.setBusyDeferIdle();
        env.defer().reply(new InterruptReply());
        this.interrupt();
    }

    protected ClassLoader getClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    protected void installDefaultExtensions() {
        this.installExtensions(this.getClassLoader());
    }

    protected void installExtensions(String classpath) {
        URL[] urls = (URL[])PathsHandler.split(classpath).stream().map(BaseKernel::pathToURL).toArray(URL[]::new);
        URLClassLoader classLoader = new URLClassLoader(urls, this.getClassLoader());
        this.installExtensions(classLoader);
    }

    protected void installExtensions(ClassLoader classLoader) {
        ServiceLoader.load(Extension.class, classLoader).stream().map(ServiceLoader.Provider::get).forEach(this::installExtension);
    }

    protected void installExtension(Extension ext) {
        if (this.extensions.putIfAbsent(ext.getClass().getName(), ext) == null) {
            ext.install(this);
        }
    }

    private static URL pathToURL(String path) {
        try {
            return Path.of(path, new String[0]).toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

